<?php

namespace App\Exports;

use App\Models\paiement;
use Illuminate\Support\Facades\Auth;
use Maatwebsite\Excel\Events\AfterSheet;
use Maatwebsite\Excel\Concerns\FromQuery;
use Maatwebsite\Excel\Concerns\WithTitle;
use Maatwebsite\Excel\Concerns\WithEvents;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithColumnWidths;

class exportPaiement implements FromQuery, WithHeadings, WithColumnWidths, WithTitle, WithEvents
{
    protected $date1;
    protected $date2;
    protected $typeP;
    protected $Courant;

    public function __construct($param1, $param2, $param3,$param4)
    {
        $this->date1 = $param1;
        $this->date2 = $param2;
        $this->typeP = $param3;
        $this->Courant = $param4;
    }

    public function query()
    {
        $condition = array();
        if (!(Auth::user()->type == 'admin_fonctionnel' or Auth::user()->type == 'admin_technique' or Auth::user()->type == 'caisse'))
            $condition['user_id'] = Auth::user()->id;

        $query = paiement::join('societe as s', 'societe_id', '=', 's.id')
            ->leftjoin('users as u', 'agent_recouvr', '=', 'u.id')
            ->where('fl_sup', 'N')
            ->where($condition)
            ->when($this->typeP != null, function ($query) {
                return $query->where('statut', 1);
            })
            // ->whereBetween('datepaie', [$this->date1, $this->date2])
            ->when($this->date1 != null && $this->date2 != null, function ($query) {

                return $query->whereBetween('datepaie', [$this->date1, $this->date2]);
            })
            ->when($this->date1 != null && $this->date2 == null, function ($query) {

                return $query->whereDate('datepaie', $this->date1);
            });
           
        if ($this->Courant== true) 
            $query ->select('paiement.datepaie', 'paiement.recu', 's.nom_ets', 'u.name', 's.adresse', 'paiement.montant');
        else
        $query->select('paiement.datepaie', 'paiement.recu', 's.nom_ets', 's.adresse', 'paiement.montant');
        
        return $query;
    }

    public function headings(): array
    {


        if ($this->Courant==true) {
            $headings = [
                "Date",
                "No Quittance",
                "Entreprise",
                "Recouvré par",
                "Adresse",
                "Montant",
            ];
        }else {
            $headings = [
                "Date",
                "No Quittance",
                "Entreprise",
                "Adresse",
                "Montant",
            ];
        }

        return $headings;
    }

    public function columnWidths(): array
    {
        return [

            'A' => 35,
            'B' => 35,
            'C' => 35,
            'D' => 35,
            'E' => 35,
            'F' => 35,
        ];
    }

    public function title(): string
    {
        return 'Recapitulatif des ' . ($this->typeP == null ? 'paiements ' : 'recettes ') . 'du '
            . $this->date1 . ' ' . ($this->date2 != null ? 'au ' . $this->date2 : '');
    }
    public function registerEvents(): array
    {
        return [
            AfterSheet::class    => function (AfterSheet $event) {

                $event->sheet->getDelegate()->freezePane('A2');
            },
        ];
    }
}
