<?php
namespace App\Http\Controllers\Api\Auth;
use App\Http\Controllers\Controller;

use App\Models\User;
use Illuminate\Support\Facades\Auth;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;



class AuthController extends Controller
{



public function login(Request $request)
{
if (!Auth::attempt($request->only('email', 'password'))) {
return response()->json([
'message' => 'Invalidation login details'
           ], 401);
       }

$user = User::where('email', $request['email'])->firstOrFail();

$token = $user->createToken('auth_token')->plainTextToken;

return response()->json([
           'access_token' => $token,
           'token_type' => 'Bearer',
]);
}


///
public function me(Request $request)
{
return $request->user();
}

//logout
public function logout(Request $request)
{
    auth()->user()->tokens()->delete();
    return [
        'message' => 'user logged out'
    ];
}



}

