<?php
namespace App\Http\Controllers\Api\Paiement;

use App\Http\Controllers\Controller;

use App\Models\paiement as ModelsPaiement;
use App\Models\identification\societe as IdentificationSociete;
use App\Models\identification\societe;
use App\Models\facture;
use App\Models\paiement;
use Auth;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;


class PaieController extends Controller {


    public function show(Request $request){

    }

  public function updateorcreate(Request $request)
  {
    try {
      DB::transaction(function () use ($request) {
        $data = request('data');
        $id_courant = $request->user();
        foreach ($data as $key => $value) {

          $ets = IdentificationSociete::find($value['societe_id']);
          $lafacture = facture::find($value['facture_id']);

          if ($lafacture->statut != 3) {
            $montantf = $lafacture->montant_negoc == 0 ? $lafacture->montant : $lafacture->montant_negoc;
            $montant = $value['montant'] > $montantf ? ($lafacture->montantpaie == 0 ? $montantf :
              $montantf - $lafacture->montantpaie) :
              ($lafacture->montantpaie + $value['montant'] <= $montantf ? $value['montant'] : $montantf - $lafacture->montantpaie);
            $montantfp = $lafacture->montantpaie + $montant;
            $montantp = $montantfp > $montantf ? $montantf : $montantfp;
            $nr = paiement::all()->last()->id_paie ?? null;

            $paiement = ModelsPaiement::create([
              'entite' => 'etablissement',
              'facture_id' => $lafacture->id,
              'montant' => $montant,
              'recu' => $nr,
              'societe_id' => $ets->id,
              'modalite' => $montantp == $montantf ? 'Totalité' : 'Avance',
              'moyen' => $value['moyen'],
              'datepaie' => $value['datepaie'] == null ? now() : $value['datepaie'],
              'agent_recouvr' => $value['user_id'],
              'statut' => $montantp == $montantf ? 3 : 2,
              'user_id' => $id_courant['id']
            ]);

            if ($montantp == $montantf) {
              $lafacture->statut = 3;
            } else {
              $lafacture->statut = 2;
            }

            $lafacture->montantpaie = $montantp;
            $lafacture->users_up = $id_courant['id'];
            $lafacture->updated_at = now();
            $lafacture->idFacture = $lafacture->id;
            $lafacture->save();

          }
        }
        DB::commit();
      });
      return response()->json(['success' => 'paiement effectué successe'], 200);
    } catch (\Exception $e) {
      DB::rollback();
      return response()->json(['error' => $e], 500);
      //  throw $e;
    } catch (\Throwable $e) {
      DB::rollback();
      throw $e;
    }
  }

    public function updateorcreates(Request $request){
        $request->validate([
            'societe_id' => ['required'],
            'montant' => ['required'],
            'moyen' => ['required'],
          ]);  
          $ets=IdentificationSociete::find(request('societe_id'));    

         if(empty(request('facture_id'))){
         
          $facture=facture::create([
            'entite' => 'etablissement',
            'societe_id' => $ets->id,
            'montant' =>$ets->categorie->montant,
            'datefact' => now(),
            'annee' => date('Y'),
            'facture'=>$ets->id.''.date('Y'),
             'montantpaie'=>request('montant'),
            'statut' => 2,            
            'users_id' =>Auth::user()->id,
            'users_up' =>Auth::user()->id]);

            $paiement=ModelsPaiement::create([
                 'entite' => $ets->form_jurid,
                'facture_id' => $facture->id,
                'montant' =>request('montant'),
                'recu' => request('recu'),
                'societe_id' => $ets->id,
                'modalite' =>request('modalite'),
                'moyen' =>request('moyen'),                    
                'datepaie' =>request('date')==null?now():request('date'),
                'agent_recouvr'=> request('user_id')==null?Auth::user()->id:request('user_id'),
                'statut' => 0,
                'user_id' =>Auth::user()->id]);

                $montantp=$facture->montantpaie+request('montant');
                $facture->statut=2;
                $facture->montantpaie=$montantp;
                $facture->idFacture = $facture->id;
                $facture->save();
                return response()->json(['success' => 'paiement effectuée successe'], 200);
    }else{              
           $lafacture = facture::find(request('facture_id')); 
           //echo($lafacture->montant);
           if($lafacture->statut!=3){              
           $montantf=$lafacture->montant_negoc==0? $lafacture->montant:$lafacture->montant_negoc;
           $montant=request('montant')>$montantf?($lafacture->montantpaie==0?$montantf:
           $montantf-$lafacture->montantpaie):
           ($lafacture->montantpaie+request('montant')<=$montantf?request('montant'):$montantf-$lafacture->montantpaie);
           $montantfp=$lafacture->montantpaie+$montant;
           $montantp= $montantfp>$montantf? $montantf: $montantfp;
            $nr=paiement::all()->last()->id_paie ?? null;
          
           $paiement=ModelsPaiement::create([
          'entite' => 'etablissement',
          'facture_id' => $lafacture->id,
          'montant' =>  $montant,
          'recu' => $nr,
          'societe_id' => $ets->id,
          'modalite' => $montantp==$montantf?'Totalité':'Avance',
          'moyen' => request('moyen'),
          'datepaie' =>request('datepaie')==null?now():request('datepaie'),
          'agent_recouvr'=> request('user_id'),
          'statut' => $montantp==$montantf?3:2,
          'user_id'=>Auth::user()->id]);

           
            if($montantp==$montantf){
              $lafacture->statut=3;
            }else{
              $lafacture->statut=2;
            }
             
             $lafacture->montantpaie=$montantp;
             $lafacture->users_up=Auth::user()->id;                 
             $lafacture->updated_at=now();  
             $lafacture->idFacture = $lafacture->id;          
             $lafacture->save();     
             return response()->json(['success' => 'paiement effectué successe'], 200);
          }else{
            return response()->json(['info' => 'Facture soldée'], 201);
          }
    }
  }

    public function detail(Request $request){

    }
    
     /**
     * Display the specified resource.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function suivis(Request $request){

        $id_courant = $request->user();
        $factureUser = DB::table('users')
        ->join('factures', 'factures.users_id', '=', 'users.id')
        ->select('factures.*')
        ->where(function ($query) use ($id_courant) {
                $query->where('users.id', '=', $id_courant['id']);
            })->get();
            return $factureUser;
    }


    // public function updateorcreatefact(Request $request){
    //   $mnt=request('montant');
    //   $request->validate([
    //       'societe_id' => ['required'],
    //       'annee' => ['required'],
    //     ]);  
    //     $ets=IdentificationSociete::find(request('societe_id'));
    //     $lafacture=$ets->factures->where('facture',$ets->id.''.request('annee'));
    //     if(!empty($lafacture[0])){                 
    //             if($lafacture[0]->statut!=3 ){ 
    //               echo($mnt);
    //               $montantf=$lafacture[0]->montant_negoc==0? $lafacture[0]->montant:$lafacture[0]->montant_negoc;
    //               $montant=$mnt>$montantf?($lafacture[0]->montantpaie==0?$montantf:
    //               $montantf-$lafacture[0]->montantpaie):
    //               ($lafacture[0]->montantpaie+$mnt<=$montantf?$mnt:$montantf-$lafacture[0]->montantpaie);
    //               $montantfp=$lafacture[0]->montantpaie+$montant;
    //               $montantp= $montantfp>$montantf? $montantf: $montantfp;
                  
    //               $lafacture[0]->montantpaie=$montantp;
    //               $lafacture[0]->users_up=Auth::user()->id;                 
    //               $lafacture[0]->updated_at=now();
    //               $lafacture[0]->montant=$ets->categorie->montant;  

    //               $ets->montant_negoc_soc=$lafacture[0]->montant_negoc;
    //               $ets->updated_at=now();
    //               if($montantp==$montantf){
    //                 $lafacture[0]->statut=3;
    //               }else{
    //                 echo($mnt);
    //                 $lafacture[0]->statut=2;
    //               }
    //               $ets->save();
    //               $lafacture[0]->save(); 
    //              return response()->json(['success' => 'paiement effectué successe'], 200);
    //             }else
    //             return response()->json(['info' => 'Facture soldée'], 201);
             
    //     }else{
    //             $facture=facture::updateOrCreate(
    //                [
    //                 'facture'=>$ets->id.''.request('annee')
    //               ], 
    //               [
    //                 'entite' => 'etablissement',
    //                 'societe_id' => $ets->id,
    //                 'montant' =>  $ets->montant_negoc_soc==0?$ets->categorie->montant:$ets->montant_negoc_soc,
    //                 'datefact' => now(),
    //                 'statut' => 2,
    //                 'montantpaie'=>request('montant'),
    //                 'annee'=>request('annee'),
    //                 'montant_negoc'=>$ets->montant_negoc_soc==0?0:$ets->montant_negoc_soc,
    //                 'users_id' =>Auth::user()->id,
    //                 'users_up' =>Auth::user()->id
    //               ]);
    //               $facture->idFacture = $facture->id;
    //               $facture->save();   
    //               return response()->json(['success' => 'paiement effectué successe'], 200);            
    //             }
    //           }
}