<?php

namespace App\Http\Controllers\Api\Rdv;

use App\Http\Controllers\Controller;
use App\Models\Service;
use App\Models\rendezvous;
use App\Models\identification\societe;
use Illuminate\Support\Facades\Auth;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Models\User;

class RdvController extends Controller
{


    /**
     * Display the specified resource.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function show(Request $request)
    {
        $id_courant = $request->user();

        $rdvUser = DB::table('users')
            ->join('rendezvous', 'rendezvous.user_id', '=', 'users.id')
            ->join('societe', 'rendezvous.societe_id', '=', 'societe.id')
            ->select('rendezvous.*')
            ->where(function ($query) use ($id_courant) {
                $query->where('users.id', '=', $id_courant['id']);
            })->orderBy('rendezvous.id_rdv', 'DESC')
            ->get();
            return $rdvUser;
    }


    /**
     * Display the specified resource.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function detail(Request $request)
    {
        try {
            $rdv = rendezvous::findOrFail($request->input('id_rdv'));
            return $rdv;
        } catch (\Illuminate\Database\Eloquent\ModelNotFoundException $e) {
            return response()->json(['error' => 'rendezvous not found'], 404);
        } catch (\Exception $e) {
            return response()->json(['error' => 'Internal server error'], 500);
        }
        
    }

    
 public function detailBySocete(Request $request)
    {
        try {
            $rdv = rendezvous::where('societe_id', $request->input('societe_id'))->get();
            return $rdv;
        } catch (\Illuminate\Database\Eloquent\ModelNotFoundException $e) {
            return response()->json(['error' => 'rendezvous not found'], 404);
        } catch (\Exception $e) {
            return response()->json(['error' => 'Internal server error'], 500);
        }
        
    }

    public function updateorcreate(Request $request)
    {
        try {
            DB::transaction(function () use ($request) {
                $request->validate([
                    'data' => ['required'],

                ]);

                $data = $request['data'];

                $id_courant = $request->user();
                foreach ($data as $key => $value) {

                    if ($value['id_rdv'] != null && $value['id_rdv'] != 0) {
                        if ($value['typeSynchro'] == "U") {
                            $rendezvous = rendezvous::find($value['id_rdv']);
                        } else {
                            $rdvs = rendezvous::where('tscreate_idusers', '=',$value['tscreate_idusers'])->get();
                            $rendezvous = $rdvs[0] ?? null ;
                            if ($rendezvous==null) {
                                $rendezvous = new rendezvous();
                                $rendezvous->societe_id = $value['societe_id'];
                            }

                        }
                    } else {
                        $rendezvous = new rendezvous();
                        if ($value['typeSynchroSociete'] == "I") {
                            $societes = societe::where('tscreate_idusers', '=',$value['tscreate_idusers_societe'])->get();
                            $rendezvous->societe_id = $societes[0]->id;
                        } else
                            $rendezvous->societe_id = $value['societe_id'];
                    }

                    $rendezvous->observation = $value['observation'];
                    $rendezvous->description = $value['description'];
                    $rendezvous->type = $value['type'];
                    $rendezvous->daterdv = $value['daterdv'];
                    $rendezvous->user_fai_rdv_id = $value['user_fai_rdv_id'];
                    $rendezvous->pa_motf_repl_rdv_id = $value['pa_motf_repl_rdv_id'];
                    $rendezvous->pa_statut_rdv_id = $value['pa_statut_rdv_id'];
                    $rendezvous->pa_motf_rdv_id = $value['pa_motf_rdv_id'];
                    $rendezvous->date_create_rdv = $value['date_create_rdv'];
                    $rendezvous->datefais = $value['datefais'];
                    $rendezvous->user_id = $id_courant['id'];
                    $rendezvous->tscreate_idusers = $value['tscreate_idusers'];
                    $rendezvous->save();

                }
                DB::commit();
            });
            return response()->json(['success' => 'Rendez-vous updated successfully'], 200);
        } catch (\Exception $e) {
            DB::rollback();
            return response()->json(['error' => $e], 500);
            //  throw $e;
        } catch (\Throwable $e) {
            DB::rollback();
            throw $e;
        }
    }

    public function updateorcreates(Request $request)
    {
        $id_courant = $request->user();
        $request->validate([
            'societe_id' => ['required'],
            'daterdv' => ['required'],
            'observation' => ['required'],
            'type' => ['required'],
        ]);
        try {
            if (request('id_rdv') != null && request('id_rdv') != 0) {
                if (request('typeSynchro') == "U") {
                    $rendezvous = rendezvous::find(request('id_rdv'));
                } else {
                    $rdvs = rendezvous::where('tscreate_idusers', '=', request('tscreate_idusers'))->get();
                    $rendezvous = $rdvs[0];
                }
            } else {
                $rendezvous = new rendezvous();
                if (request('typeSynchroSociete') == "I") {
                    $societes = societe::where('tscreate_idusers', '=', request('tscreate_idusers_societe'))->get();
                    $rendezvous->societe_id = $societes[0]->id;
                } else
                    $rendezvous->societe_id = $request['societe_id'];
            }

            $rendezvous->observation = $request['observation'];
            $rendezvous->description = request('description');
            $rendezvous->type = $request['type'];
            $rendezvous->daterdv = request('daterdv');
            $rendezvous->user_fai_rdv_id = $request['user_fai_rdv_id'];
            $rendezvous->pa_motf_repl_rdv_id = $request['pa_motf_repl_rdv_id'];
            $rendezvous->pa_statut_rdv_id = $request['pa_statut_rdv_id'];
            $rendezvous->pa_motf_rdv_id = $request['pa_motf_rdv_id'];
            $rendezvous->date_create_rdv = $request['date_create_rdv'];
            $rendezvous->datefais = $request['datefais'];
            $rendezvous->user_id = $id_courant['id'];
            $rendezvous->tscreate_idusers = $request['tscreate_idusers'];
            $rendezvous->save();


            return response()->json(['success' => 'Rendez-vous updated successfully'], 200);
        } catch (\Exception $e) {
            return response()->json(['error' => $e], 500);
        }
    }

	 public function updatePassword(Request $request)
   	 {        $id_courant = $request->user();

             $request->validate([
            'id' => ['required'],
            'password' => ['required'],
          ]);
        User::updateOrInsert(
            [  'id' => $request['id'],],
                  [
                             
            'password' => Hash::make($request['password']) ,
            
          ]
                                                  
                                                  );

          return response()->json(['success' => 'user updated successfully'], 200);
        }


}
