<?php

namespace App\Http\Controllers\Api\Service;

use App\Facades\CustomLog;
use App\Http\Controllers\Controller;
use App\Models\identification\gerant;
use App\Models\identification\societe;
use App\Models\journal;
use App\Models\Service;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Models\User;
use App\Http\Requests\PostServiceRequest;
use App\Http\Resources\ServiceResource;
use Illuminate\Support\Facades\Log;
use PhpParser\Node\Stmt\TryCatch;
class ServiceController extends Controller
{
   
    /**
     * Display the specified resource.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function show(Request $request)
    {
        $id_courant = $request->user();

        $serviceUser = DB::table('users')
            ->join('factures', 'factures.users_id', '=', 'users.id')
            ->join('societe', function($join){
                $join->on('factures.societe_id', '=', 'societe.id')->where('fl_sup','=', 'N');
            })
            ->join('categorie', 'societe.categorie_id', '=', 'categorie.id')
            ->join('arrondissement as arr', 'societe.arrondissement_id', '=', 'arr.id')
            ->join('grille as g', 'societe.grille_id', '=', 'g.id')
            ->join('gerant as u', 'societe.gerant_id', '=', 'u.id')
            ->select('societe.*','categorie.libelle','arr.libellea',
            'g.montant','u.nom as gerant_nom','u.sexe as gerant_sexe',
            'u.titre as gerant_titre','g.activite as catego','g.code as code')

            ->where(function ($query) use ($id_courant) {
                $query->where('users.id', '=', $id_courant['id']);
            })
            ->get();
            return $serviceUser;
    }

    public function showBy(Request $request)
    {
            $serviceUser = DB::table('societe')            
            ->select('societe.*')
            ->where(function ($query) {
                $query->where('fl_sup','=', 'N')
                ->where('nom_ets','LIKE', '%' . request('nom_ets') . '%');
            })
            ->get();
            return $serviceUser;
    }
    public function showPaiement(Request $request)
    {
        $id_courant = $request->user();

        $showPaiement = DB::table('users')
            ->join('factures', 'factures.users_id', '=', 'users.id')
            ->join('paiement', 'paiement.user_id', '=', 'users.id')
            ->join('societe', function($join){
                $join->on('paiement.societe_id', '=', 'societe.id')->where('fl_sup','=', 'N');
            })
            ->join('users as agent','agent.id', '=', 'paiement.agent_recouvr')
            ->select('societe.*','paiement.*','agent.name as recouvreur')
            ->where(function ($query) use ($id_courant) {
                $query->where('users.id', '=', $id_courant['id']);
            })->orderBy('paiement.datepaie', 'DESC')
            ->get();
            return $showPaiement;
    }

    
    


    /**
     * Display the specified resource.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function detail(Request $request)
    {
        try {
            $service = Service::findOrFail($request->input('id_service'));
            return $service;
        } catch (\Illuminate\Database\Eloquent\ModelNotFoundException $e) {
            return response()->json(['error' => 'Service not found'], 404);
        } catch (\Exception $e) {
            return response()->json(['error' => 'Internal server error'], 500);
        }
        
    }
    
    
    /**
     * Display the specified resource.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function geolocalisation(Request $request)
    {
        try {
            $service = Service::findOrFail($request->input('id_service'));
            return $service['geoloc'];
        } catch (\Illuminate\Database\Eloquent\ModelNotFoundException $e) {
            return response()->json(['error' => 'Service not found'], 404);
        } catch (\Exception $e) {
            return response()->json(['error' => 'Internal server error'], 500);
        }
        
        if (!isset($service['geoloc'])) {
            return response()->json(['error' => 'Geolocation not found for this service'], 404);
        }
        
    }


    public function updateorcreate(Request $request)
    {
        try {
            DB::transaction(function () use ($request) {
                $data = request('data');
                $id_courant = $request->user();
                foreach ($data as $key => $value) {                   

                    if ($value['id'] != null && $value['id'] != 0) {
                        if ($value['typeSynchro'] == "U")
                            $societe = societe::find($value['id']);
                        else {
                            $societes = societe::where('tscreate_idusers', '=', $value['tscreate_idusers'])->get();
                            $societe = $societes[0]??null;
                            if ( $societe ==null) {
                                $societe = new societe();
                                $societe = new societe();
				                $societe->nom_ets = $value['nom_ets'];
                                $societe->ville = $value['ville'];
                                $societe->form_jurid = $value['form_jurid'];
                                $societe->grille_id = $value['grille_id'];
                                $societe->categorie_id = $value['categorie_id'];
                                $societe->datercm = $value['dateRcm'];
                                $societe->datecre = now();
                                $societe->user_create_id = $value['user_create_id'];
                                $societe->src_create = 'M';
                                $societe->tscreate_idusers = $value['tscreate_idusers'];

                            }
                        }

                    } else {
                        $societe = new societe();
                        $societe->nom_ets = $value['nom_ets'];
                        $societe->ville = $value['ville'];
                        $societe->form_jurid = $value['form_jurid'];
                        $societe->grille_id = $value['grille_id'];
                        $societe->categorie_id = $value['categorie_id'];
                        $societe->datercm = $value['dateRcm'];
                        $societe->datecre = now();
                        $societe->user_create_id = $value['user_create_id'];
                        $societe->src_create = 'M';
                        $societe->tscreate_idusers = $value['tscreate_idusers'];
                    }
                    $societe->user_update_id = $value['user_update_id'];
                    $societe->fl_sup = $value['fl_sup'];
                    $societe->date_sup = $value['date_sup'];
                    $societe->id_adr_voie = $value['id_adr_voie'];
                    $societe->adresse = $value['adresse'];
                    $societe->tel = $value['tel'];
                    $societe->arrondissement_id = $value['arrondissement_id'];

                    $journal = journal::create(
                        [
                            'user_id' => $id_courant['id'],
                            'datej' => now(),
                            'contenu' => 'Modification de ' . $societe->nom_ets . '',
                            'type' => 3,
                        ]
                    );

                    $societe->save();

                }
                DB::commit();
            });
            return response()->json(['success' => 'Societe updated successfully'], 200);
        } catch (\Exception $e) {
            DB::rollback();
            return response()->json(['error' => $e], 500);
          //  throw $e;
        } catch (\Throwable $e) {
            DB::rollback();
            throw $e;
        }
    }
    
    // public function updateorcreate(Request $request)
    // {$id_courant = $request->user();
    //     $request->validate([
    //         'adresse' => ['required'],
    //         'tel' => ['required'],
    //         'arrondissement_id' => ['required'],
    //       ]);             
    
    //    if(request('id')!=null&&request('id')!=0)
    //    {
    //     if(request('typeSynchro')=="U")
    //        $societe=societe::find(request('id'));
    //     else
    //     { $societes=societe::where('tscreate_idusers', '=', request('tscreate_idusers'))->get();
    //     $societe=$societes[0];
    //     }

    //     }
    //    else {
    //     $societe=new societe();        
    //     $societe->nom_ets=request('nom_ets'); 
    //     $societe->ville=request('ville');
    //     $societe->form_jurid=request('form_jurid');
    //     $societe->grille_id=request('grille_id');       
    //     $societe->categorie_id=request('categorie_id');
    //     $societe->datercm=request('datercm'); 
    //     $societe->datecre=now();
    //     $societe->user_create_id=request('user_create_id');
    //     $societe->src_create='M';
    //     $societe->tscreate_idusers = request('tscreate_idusers');
    //    }              
    //     $societe->user_update_id=request('user_update_id');        
    //     $societe->fl_sup =request('fl_sup'); 
    //     $societe->date_sup =request('date_sup');
    //     $societe->id_adr_voie=request('id_adr_voie');
    //     $societe->adresse=request('adresse');
    //     $societe->tel=request('tel');
    //     $societe->arrondissement_id=request('arrondissement_id');


    //     $journal= journal::create(       
    //         [
    //         'user_id' => $id_courant,
    //         'datej' => now(),
    //         'contenu' => 'Modification de '.$societe->nom_ets.'',
    //         'type' => 3,
    //     ]); 
    //     if ( $societe->save()) {
    //         return response()->json(['success' => 'Societe updated successfully'], 200);
    //     } 
    //     CustomLog::info(['My info log',$societe.'\n'], 'listesNonSynchoniserEntreprise_'.date('Y-m-d'));
       
    //     //$res=response()->json(['success' => 'Société updated successfully'], 200);

    //     // if ($res->status!=200) {
    //     // // error_log(print_r($societe, TRUE), 3, storage_path('logs/listesNonSynchoniserEntreprise.log'));
    //     //   \Log::channel('entreprise')->info($societe.'\n');
    //     // }
    //     return response()->json(['success' => 'Societe updated successfully'], 200);
         
    //     }

        public function showArrondissement(Request $request)    {
        $arrondissements = DB::table('arrondissement as arr')
            ->select('arr.*')->get();
            return $arrondissements;
    }

    public function getParametreGlobals(Request $request)    {
        $parametres=DB::table('param_glob as pg')
	->select('pg.*')->get();
            return $parametres; 
    }
    public function getVoies(Request $request)    {
        $parametres = DB::table('voies  as v')
            ->select('v.*')->get();
            return $parametres;
    }

    public function getCategories(Request $request)    {
        $categories = DB::table('grille  as g')
            ->select('g.*')->get();
            return $categories;
    }
    public function getSections(Request $request)    {
        $sections = DB::table('categorie  as c')
            ->select('c.*')->get();
            return $sections;
    }
}
