<?php

namespace App\Http\Controllers;

use GeoIP;
use App\Models\User;
use Illuminate\Http\Request;
use App\Http\Controllers\ets;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use App\Models\identification\societe;
use Illuminate\Support\Facades\Session;

class SearchLocationController extends Controller
{

    public function index()
    {

        return view('searchLocation');
    }

    public function store(Request $request)
    {
       

        if ($request->proximite=='true') {
            
            if ($request->geoloc != "default") {
                $position = $request->geoloc;
                $proximite = self::calculProximite($position);
                if (count($proximite) >= 1) {
                    $coordonnees_json = self::makeJsonData($proximite);
                    return view('cartegenerale', compact('coordonnees_json'));
                } else {
                    Session::flash('erreur', 'Pas de société à proximité !');
                    return redirect()->back();
                }
            } else {
                Session::flash('erreur', 'Position indéterminée, veuillez vérifier les autorisation !');
                return redirect()->back();
            }
        } elseif ($request->localiser=='true') {
            
            $nom_societe = $request->validate([
                'ssearch' => 'required'
            ]);
            $societe = DB::table('societe')
                ->where('nom_ets', $nom_societe)
                ->where('fl_sup', 'N')
                ->first();
            if ($societe != null && $societe->geoloc != null) {
                $position = $societe->geoloc;
                $proximite = array_slice( self::calculProximite($position),0 ,29);
                $proximite[] = $societe;
                $coordonnees_json = self::makeJsonData($proximite);
                return view('cartegenerale', compact('coordonnees_json'));
            } else {
                Session::flash('erreur', 'Erreur sur le nom de la société, ou société sans coordonnées GPS !');
                return redirect('/searchLocation')->withInput();
            }
        }
        
    }

    function distance($lat1, $lon1, $lat2, $lon2)
    {
        $earth_radius = 6371; // en kilomètres
        $dLat = deg2rad($lat2 - $lat1);
        $dLon = deg2rad($lon2 - $lon1);
        $a = sin($dLat / 2) * sin($dLat / 2) + cos(deg2rad($lat1)) * cos(deg2rad($lat2)) * sin($dLon / 2) * sin($dLon / 2);
        $c = 2 * atan2(sqrt($a), sqrt(1 - $a));
        $distance = $earth_radius * $c;
        return $distance;
    }


    public function autocomplete(Request $request)
    {
        return societe::select("nom_ets")
            ->where("nom_ets", "LIKE", "%{$request->term}%")
            ->where('fl_sup', 'N')
            ->pluck('nom_ets');
    }

    public function calculProximite($position)
    {
        list($latitude, $longitude) = explode('$', $position);

        $entreprises = DB::table('societe')
            ->select('*')
            ->addSelect(DB::raw("SUBSTRING_INDEX(geoloc, '$', 1) AS latitude"), DB::raw("SUBSTRING_INDEX(geoloc, '$', -1) AS longitude"))
            ->where('fl_sup', 'N')
            ->get();

        $proximite = array();
        foreach ($entreprises as $entreprise) {
            $distance = self::distance($latitude, $longitude, $entreprise->latitude, $entreprise->longitude);


            if ($distance <= 5) {
                $proximite[] = $entreprise;
            }
        }
        shuffle($proximite);
        return $proximite;
    }


    public function makeJsonData($proximite)
    {
        if (count($proximite) >= 1) {
            $coordonnees = array();

            // Parcours de toutes les entreprises
            foreach ($proximite as $data) {
                // Récupération des coordonnées géographiques de l'entreprise
                $coords = explode('$', $data->geoloc);
                $lat = $coords[0];
                $lng = $coords[1];
                $name = $data->nom_ets;
                $id = $data->id;
                // Ajout des coordonnées géographiques dans le tableau
                $coordonnees[] = array('lat' => $lat, 'lng' => $lng, 'name' => $name, 'id' => $id);
            }
            $coordonnees_json = json_encode($coordonnees);
            return $coordonnees_json;
        }
    }
}
