<?php

namespace App\Http\Controllers;

use App\Models\journal;
use App\Models\lettres;
use App\Models\paiement;
use Illuminate\Http\Request;
use Illuminate\Support\Carbon;
use App\Models\facture;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Session;


class StatistiquesController extends Controller
{
   
    public function index()
    {   
        $paier=paiement::query();
       $paie =$paier->selectRaw('*,year(created_at) as year, month(created_at) as numberofmonth,
       monthname(created_at) as monthname, day(created_at) as numberofday,
       dayofmonth(created_at) as dayofmonth,dayofweek(created_at) as dayofweek,count(monthname(created_at)) as nombre,sum(montant) as montantT,
       dayname(created_at) as dayname')->groupByRaw('year(created_at)')->orderByRaw('year(created_at)')->get();     

        return view('visionParPeriode',compact('paie'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * 
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * 
     */
    public function store(Request $request)
    
    //données pour les graphiques(chart)
    {
        if(!empty(request('stats'))){
         
    $number = DB::table('paiement')
        ->selectRaw('*,year(created_at) as year,count(monthname(created_at)) as nombre,sum(montant) as somme,dayname(created_at) as dayname')
        ->groupByRaw('year(created_at)')

        ->orderByRaw('year(created_at)')
->get();
  
    
    return view('StatistiquesPeriodique',compact('number'));
        }





//Filtrage de la vue en fonction des combobox
        if(!empty(request('FiltreParAnnee'))){
            
           // dd(request());
            $paiement=paiement::query();
            $anne=$request->Annee;
            $month=$request->MS;
            
           //quand l'année et la semaine sont precise(Ne pas deplacer);
           if( !empty($anne) and empty(($month))){
            $paiement->selectRaw('*,year(created_at) as year,count(year(created_at)) as nombre,sum(montant) as montantT')
            ->whereRaw('COALESCE(statut,0)!= ?',[5])
            ->whereYear('created_at',$anne)
            ->groupByRaw('YEAR(created_at) ');

         }
           
            
            elseif(!empty($month) and !empty($anne)){
                
            
                if($anne == Carbon::now()->year)
                {
                    switch($month){
                    case 'month':
                       $mois= db::table('paiement as p')
                       ->selectRaw('*, sum(COALESCE(montant,0)) as montantT,count(month(created_at)) as nombre,year(DATE_CAL) as year')->
                       rightJoin('stats_calendrier as c','c.DATE_CAL','=','p.datepaie')
                       ->whereRaw('COALESCE(p.statut,0)!= ?',[5])
                       ->whereYear('DATE_CAL',$anne)
                       ->whereBetween('NUM_MOIS',[1,Carbon::now()->month])
                       ->groupBy('c.NOM_MOIS')
                       ->orderByRaw('NUM_MOIS')
                        ->get();
                        
                        return view('statistiques.visionPeriodiqueMensuelle',compact('mois'));
                       

                    case 'week':
                        $week= db::table('stats_calendrier as c')->selectRaw('
                        *, sum(COALESCE(montant,0)) as montantT,count(monthname(created_at)) as nombre,year(DATE_CAL) as year
                        ')->leftJoin('paiement as p','c.DATE_CAL','=','p.datepaie')
                        ->whereRaw('COALESCE(p.statut,0)!= ?',[5])
                        ->whereBetween('NUM_SEM',[1,Carbon::now()->weekOfYear])
                         ->whereYear('DATE_CAL',$anne)
                         ->groupBy('c.NOM_SEM')
                         ->orderBy('NUM_SEM')->get();
                        return view('statistiques.visionPeriodiqueHebdomadaire',compact('week'));
                        
                        case 'day':
                            $firtsDateOfYear =Carbon::now()->firstOfYear();
                            $paie= DB::table('stats_calendrier as c')->selectRaw('
                            *, sum(COALESCE(montant,0)) as montantT,count(month(created_at)) as nombre,year(DATE_CAL) as year
                            ')->leftJoin('paiement as p','c.DATE_CAL','=','p.datepaie')
                            ->whereRaw('COALESCE(p.statut,0)!= ?',[5])
                             ->whereYear('DATE_CAL',$anne)
                             ->whereBetween('date_cal',[$firtsDateOfYear,Carbon::now()])
                            ->groupBy('date_cal')
                            ->orderBy(('DATE_CAL'))
                            ->get();
           
                    return view('statistiques.visionPeriodiqueQuotidienne',compact('paie'));
                       
                }
            }
            else{
                switch($month){
                    case 'month':
                       $mois= db::table('paiement as p')
                       ->selectRaw('*, sum(COALESCE(montant,0)) as montantT,count(month(created_at)) as nombre,year(DATE_CAL) as year')->
                       rightJoin('stats_calendrier as c','c.DATE_CAL','=','p.datepaie')
                       ->whereRaw('COALESCE(p.statut,0)!= ?',[5])
                       ->whereYear('DATE_CAL',$anne)
                       ->groupBy('c.NOM_MOIS')
                        ->orderBy('NUM_MOIS')
                        ->get();
                        
                        return view('statistiques.visionPeriodiqueMensuelle',compact('mois'));
                       

                    case 'week':
                        $week= db::table('stats_calendrier as c')
                        ->selectRaw('
                        *, sum(COALESCE(montant,0)) as montantT,count(monthname(created_at)) as nombre,year(DATE_CAL) as year
                        ')
                        ->leftJoin('paiement as p','c.DATE_CAL','=','p.datepaie')
                        ->whereRaw('COALESCE(p.statut,0)!= ?',[5])
                         ->whereYear('DATE_CAL',$anne)
                         ->groupBy('c.NOM_SEM')
                         ->orderBy('NUM_SEM')->get();
                         return view('statistiques.visionPeriodiqueHebdomadaire',compact('week'));

                    case 'day':
                            $firtsDateOfYear =Carbon::createFromDate($anne, 1, 1)->startOfYear();
                            $paie= DB::table('stats_calendrier as c')->selectRaw('
                            *, sum(COALESCE(montant,0)) as montantT,count(month(created_at)) as nombre,year(DATE_CAL) as year
                            ')->leftJoin('paiement as p','c.DATE_CAL','=','p.datepaie')
                            ->whereRaw('COALESCE(p.statut,0)!= ?',[5])
                             ->whereYear('DATE_CAL',$anne)
                             ->whereBetween('date_cal',[$firtsDateOfYear,Carbon::now()])
                            ->groupBy('date_cal')
                            ->orderBy(('DATE_CAL'))
                            ->get(); 

                            return view('statistiques.visionPeriodiqueQuotidienne',compact('paie'));
                }
            }
            }
      
            $paie=$paiement->get();
            return view('visionParPeriode',compact('paie'));     
            
        }

        



//filtrage des statistiques


        if(!empty(request('filtreStats'))){
            //dd(request());
            $type = $request->filtrageType;
           $startday= $request->date_de_deb;
           $endday=$request->date_de_fin;
           
            switch($type){
               
                 //si c'est le jour
                case'today':
                    $datediff='';
                    $jours=db::table('stats_calendrier as c')->selectRaw('*, sum(COALESCE(montant,0)) as somme,
                    count(monthname(created_at)) as nombre,
                    year(DATE_CAL) as year')
                    ->leftJoin('paiement as p','c.DATE_CAL','=','p.datepaie')
                    ->whereRaw('COALESCE(p.statut,0)!= ?',[5])
                    ->whereYear('DATE_CAL',Carbon::now()->year)
                    ->whereDate('created_at',Carbon::now())
                    ->groupBy('c.DATE_CAL')
                    ->orderBy('DATE_CAL')->get();
        
                    return view('statistiques.histogrammeParJour',compact('jours','datediff'));
                //si c'est hier
                case'Yesterday':
                    $datediff='';
                    $jours=db::table('stats_calendrier as c')->selectRaw('*, sum(COALESCE(montant,0)) as somme,
                    count(monthname(created_at)) as nombre,year(DATE_CAL) as year')
                    ->whereRaw('COALESCE(p.statut,0)!= ?',[5])
                    ->leftJoin('paiement as p','c.DATE_CAL','=','p.datepaie')
                    ->whereYear('DATE_CAL',Carbon::now()->year)
                    ->whereDate('created_at',Carbon::yesterday())
                    ->groupBy('c.DATE_CAL')
                    ->orderBy('DATE_CAL')->get();
        
                    return view('statistiques.histogrammeParJour',compact('jours','datediff'));
        
                     //si c'est cette semaine
                case'this_week':
                    $week=db::table('stats_calendrier as c')->selectRaw('*, sum(COALESCE(montant,0)) as somme,
                    count(monthname(created_at)) as nombre,
                    year(DATE_CAL) as year')
                    ->leftJoin('paiement as p','c.DATE_CAL','=','p.datepaie')
                    ->whereRaw('COALESCE(p.statut,0)!= ?',[5])
                    ->whereBetween('created_at',[Carbon::now()->startOfWeek(),Carbon::now()->endofweek()])
                    ->groupBy('c.DATE_CAL')
                    ->orderBy('DATE_CAL')->get();
        
                    return view('statistiques.histogrammeParSemaine',compact('week'));
                   
                    //si c'est la seamine passée 
                 case'lask_week':
                    $week=db::table('stats_calendrier as c')->selectRaw('*, sum(COALESCE(montant,0)) as somme,
                    count(monthname(created_at)) as nombre,
                    year(DATE_CAL) as year')
                    ->leftJoin('paiement as p','c.DATE_CAL','=','p.datepaie')
                    ->whereRaw('COALESCE(p.statut,0)!= ?',[5])
                    ->whereBetween('created_at',[Carbon::now()->subWeek(),Carbon::now()])
                    ->groupBy('c.DATE_CAL')
                    ->orderBy('DATE_CAL')->get();
        
                    return view('statistiques.histogrammeParSemaine',compact('week'));
                       
                    //si c'est ce mois
                 case'this_month':
                    $mois=db::table('stats_calendrier as c')->selectRaw('*, sum(COALESCE(montant,0)) as somme,
                    count(monthname(created_at)) as nombre,
                    year(DATE_CAL) as year')
                    ->leftJoin('paiement as p','c.DATE_CAL','=','p.datepaie')
                    ->whereRaw('COALESCE(p.statut,0)!= ?',[5])
                    ->whereYear('DATE_CAL',Carbon::now()->year)
                    ->whereMonth('created_at',Carbon::now()->month)
                    ->groupBy('c.DATE_CAL')
                    ->orderBy('DATE_CAL')->get();
        
                    return view('statistiques.histogrammeParMois',compact('mois'));
                
                    //si c'est le mois passée
                    case'last_month':
                        $mois=db::table('stats_calendrier as c')->selectRaw('*, sum(COALESCE(montant,0)) as somme,
                        count(monthname(created_at)) as nombre,
                        year(DATE_CAL) as year')
                        ->leftJoin('paiement as p','c.DATE_CAL','=','p.datepaie')
                        ->whereRaw('COALESCE(p.statut,0)!= ?',[5])
                        ->whereYear('DATE_CAL',Carbon::now()->year)
                        ->whereMonth('created_at',Carbon::now()->subMonth())
                        ->groupBy('c.DATE_CAL')
                        ->orderBy('DATE_CAL')->get();
        
                        return view('statistiques.histogrammeParMois',compact('mois'));
        
                        //si cette Année
                    case'this_year':
                        $an=db::table('stats_calendrier as c')->selectRaw('
                        *, sum(COALESCE(montant,0)) as somme,count(monthname(created_at)) as nombre,year(DATE_CAL) as year
                        ')->leftJoin('paiement as p','c.DATE_CAL','=','p.datepaie')
                        ->whereRaw('COALESCE(p.statut,0)!= ?',[5])
                         ->whereYear('DATE_CAL',Carbon::now()->year)
                         ->groupBy('c.NOM_Mois')
                         ->orderBy('DATE_CAL')->get();
        
                         return view('statistiques.histogrammeParAn',compact('an'));
        
                         //si c'est l'année passée
                    case'last-year':
                        $an=DB::table('paiement as p')
                        ->rightJoin('stats_calendrier as c', 'c.DATE_CAL', '=', 'p.datepaie')
                        ->selectRaw('*, sum(COALESCE(montant,0)) as somme, COUNT(month(created_at)) as nombre, YEAR(DATE_CAL) as year')
                        ->whereRaw('COALESCE(p.statut,0)!= ?',[5])
                        ->whereYear('DATE_CAL', '=', Carbon::now()->subYear())
                        ->groupByRaw('NOM_MOIS')
                        ->orderBy('Num_mois')->get();
                         return view('statistiques.histogrammeParAn',compact('an'));
            }
            
        
            //pour date diff et datededebut et datedefin est #null
        
            if(!empty($startday) and !empty($endday)){
            
                $datediff=  "Du ".$startday." au ".$endday;
                $jours=db::table('stats_calendrier as c')->selectRaw('*, sum(montant) as somme,
                count(monthname(created_at)) as nombre,
                year(DATE_CAL) as year')
                ->leftJoin('paiement as p','c.DATE_CAL','=','p.datepaie')
                ->where('p.statut','!=','5')
                ->whereBetween('created_at',[$startday,$endday])
                ->groupBy('c.DATE_CAL')
                ->orderBy('NUM_SEM')->get();
                return view('statistiques.histogrammeParJour',compact('jours','datediff'));
       
                }
        
        
            
        //quand date de fin est vide
            if(!empty($startday) and empty($endday) ){
                $datediff=  "Du ".$startday;
                $jours=db::table('stats_calendrier as c')->selectRaw('*, sum(montant) as somme,
                count(monthname(created_at)) as nombre,
                year(DATE_CAL) as year')
                ->leftJoin('paiement as p','c.DATE_CAL','=','p.datepaie')
                ->where('p.statut','!=','5')
                ->whereDate('created_at',$startday)
                ->groupBy('c.DATE_CAL')
                ->orderBy('NUM_SEM')->get();
        
                return view('statistiques.histogrammeParJour',compact('jours','datediff'));
            }
        
        //quand date de debut est vide
            if(empty($startday) and !empty($endday)){
                $datediff=  "Du ".$endday;
                $jours=db::table('stats_calendrier as c')->selectRaw('*, sum(montant) as somme,
                count(monthname(created_at)) as nombre,
                year(DATE_CAL) as year')
                ->leftJoin('paiement as p','c.DATE_CAL','=','p.datepaie')
                ->where('p.statut','!=','5')
                ->whereDate('created_at',$endday)
                ->groupBy('c.DATE_CAL')
                ->orderBy('NUM_SEM')->get();
        
                return view('statistiques.histogrammeParJour',compact('jours','datediff'));
            }
        
        //controle de securité
            if(empty($startday) and empty($endday) and empty($type)){
                Session::flash('message', 'Les champs de filtre sont restés vide,Veuillez choisir un filtre');
                return redirect()->back();
            }
            
           
        }




        if(!empty(request('FiltreAgent'))){
            if (!empty(request('date1')) and !empty(request('date2'))) {
               
                $paie=paiement::select("*", DB::raw('SUM(montant) as total'), DB::raw('count(id_paie) as nb'))
                ->join('users as u','u.id','=',"agent_recouvr")->where('statut','!=',5)
                ->whereBetween('datepaie',[request('date1'),request('date2')])
                ->groupby('agent_recouvr')->orderby('nb')
                ->orderby('total')->offset(0)->limit(100)->get(); 
                
            return view('visionParAgent',compact('paie'));

            } elseif (!empty(request('date1')) and empty(request('date2'))) {
                $paie=paiement::select("*", DB::raw('SUM(montant) as total'), DB::raw('count(id_paie) as nb'))
                ->join('users as u','u.id','=',"agent_recouvr")->where('statut','!=',5)
                ->where('datepaie','>=',request('date1'))
                ->groupby('agent_recouvr')->orderby('nb')
                ->orderby('total')->offset(0)->limit(100)->get(); 
                return view('visionParAgent',compact('paie'));

            } elseif (empty(request('date1')) and !empty(request('date2'))) {               
                $paie=paiement::select("*", DB::raw('SUM(montant) as total'), DB::raw('count(id_paie) as nb'))
                ->join('users as u','u.id','=',"agent_recouvr")->where('statut','!=',5)
                ->where('datepaie','<=',request('date2'))
                ->groupby('agent_recouvr')->orderby('nb')
                ->orderby('total')->offset(0)->limit(100)->get(); 
                
            return view('visionParAgent',compact('paie'));
            }else{
                return redirect('/statAgent');
            }
             

           
    
    }
// Periode situé au dessus de la page 

    if(!empty('Periode')){
        //dd(request());

             if(!empty(request('datededebut')) and !empty(request('datedefin'))){
         
                 $startDate=$request->datededebut;
                $endDate=$request->datedefin;
                 $paie= DB::table('stats_calendrier as c')->selectRaw('
                 *, sum(COALESCE(montant,0)) as montantT,count(month(created_at)) as nombre,year(DATE_CAL) as year
                 ')->leftJoin('paiement as p','c.DATE_CAL','=','p.datepaie')
                 ->whereRaw('COALESCE(p.statut,0)!= ?',[5])
                ->whereBetween('date_cal',[$startDate,$endDate])
                 ->groupBy('date_cal')
                 ->orderBy(('DATE_CAL'))
                 ->get(); 

         return view('statistiques.visionPeriodiqueQuotidienne',compact('paie'));
      }
      
      elseif(!empty(request('datededebut')) and empty(request('datedefin'))){
        $startDate=$request->datededebut;
        
                 $paie= DB::table('stats_calendrier as c')->selectRaw('
                 *, sum(COALESCE(montant,0)) as montantT,count(month(created_at)) as nombre,year(DATE_CAL) as year
                 ')->leftJoin('paiement as p','c.DATE_CAL','=','p.datepaie')
                 ->whereRaw('COALESCE(p.statut,0)!= ?',[5])
                ->whereBetween('date_cal',[$startDate,Carbon::now()])
                 ->groupBy('date_cal')
                 ->orderBy(('DATE_CAL'))
                 ->get(); 
 
             return view('statistiques.visionPeriodiqueQuotidienne',compact('paie'));
      }

      elseif(empty(request('datededebut')) and !empty(request('datedefin'))){
                 $an= 2021;
                $firstDate = Carbon::createFromDate($an, 1, 1)->startOfYear();
                $endDate=$request->datedefin;
                 $paie= DB::table('stats_calendrier as c')->selectRaw('
                 *, sum(COALESCE(montant,0)) as montantT,count(month(created_at)) as nombre,year(DATE_CAL) as year
                 ')->leftJoin('paiement as p','c.DATE_CAL','=','p.datepaie')
                 ->whereRaw('COALESCE(p.statut,0)!= ?',[5])
                ->whereBetween('date_cal',[$firstDate,$endDate])
                 ->groupBy('date_cal')
                 ->orderBy(('DATE_CAL'))
                 ->get(); 
             return view('statistiques.visionPeriodiqueQuotidienne',compact('paie'));
      }
      
            
     }



        if(!empty(request('diagra'))){
           //dd(request('date1'));
           $periode=null;
            if (!empty(request('date1')) and !empty(request('date2'))) {
                $periode= "du ".request('date1')." au ".request('date2');
                $paie=paiement::select("*", DB::raw('SUM(montant) as total'), DB::raw('count(id_paie) as nb'))
                ->join('users as u','u.id','=',"agent_recouvr")
                ->where('statut','!=',5)
                ->whereBetween('datepaie',[request('date1'),request('date2')])
                ->groupby('agent_recouvr')->orderby('nb')
                ->orderby('total')->offset(0)->limit(200)->get(); 
            if (count($paie)!=0)
            return view('statistiquesParAgent',compact('paie','periode'));
            else {
                Session::flash('info', 'Accune donnée trouvée!');
                return  redirect('/statAgent');
            }

            } elseif (!empty(request('date1')) and empty(request('date2'))) {                
                $periode= "du ".request('date1')." à  maintenant";
                $paie=paiement::select("*", DB::raw('SUM(montant) as total'), DB::raw('count(id_paie) as nb'))
                ->join('users as u','u.id','=',"agent_recouvr")
                ->where('statut','!=',5)
                ->where('datepaie','>=',request('date1'))
                ->groupby('agent_recouvr')->orderby('nb')
                ->orderby('total')->offset(0)->limit(200)->get(); 
                if (count($paie)!=0)
                return view('statistiquesParAgent',compact('paie','periode'));
                else {
                    Session::flash('info', 'Accune donnée trouvée!');
                    return redirect('/statAgent');
                }
            } elseif (empty(request('date1')) and !empty(request('date2'))) {
                $periode= " avant le ".request('date2');
                $paie=paiement::select("*", DB::raw('SUM(montant) as total'), DB::raw('count(id_paie) as nb'))
                ->join('users as u','u.id','=',"agent_recouvr")
                ->where('statut','!=',5)
                ->where('datepaie','<=',request('date2'))
                ->groupby('agent_recouvr')->orderby('nb')
                ->orderby('total')->offset(0)->limit(200)->get(); 
                if (count($paie)!=0)
                    return view('statistiquesParAgent',compact('paie','periode'));
                else {
                Session::flash('info', 'Accune donnée trouvée!');
                    return redirect('/statAgent');
                }
            }else {
                $periode=null;
                $paie=paiement::select("*", DB::raw('SUM(montant) as total'), DB::raw('count(id_paie) as nb'))
                ->join('users as u','u.id','=',"agent_recouvr")
                ->where('statut','!=',5)
                ->groupby('agent_recouvr')->orderby('nb')
                ->orderby('total')->offset(0)->limit(200)->get();  
                if (count($paie)!=0)
                return view('statistiquesParAgent',compact('paie','periode'));
                else {
                    Session::flash('info', 'Accune donnée trouvée!');
                    return redirect('/statAgent');
                }
                       
                
            }
             
    
        }




       
        if(!empty(request('diagPerArdPerCat'))){
            if($request->input('dateD')==null && $request->input('dateF')==null){
                
                $lastdy = Carbon::now()->endOfYear();
	            $annee = Carbon::now()->year;

                 $resultats = DB::table('arrondissement')
                ->select('arrondissement.libellea as arrond', 
                DB::raw('SUM(pmnt.montant) as montantrecouvre'), 
                DB::raw('SUM(fac.montant) as montantFactur'))
                ->leftJoin('societe as soc', function ($join) use($lastdy) {
                    $join->on('soc.arrondissement_id', '=', 'arrondissement.id')
                        ->where('soc.created_at', '<=', $lastdy);
                })
                ->leftJoin('factures as fac', function ($join) use($annee) {
                    $join->on('soc.id', '=', 'fac.societe_id')
                        ->where('fac.annee', '=', $annee);
                    })
                    ->leftJoin('paiement', function ($join) {
                        $join->on('fac.id', '=', 'paiement.facture_id')
                            ->where('paiement.statut', '!=', 5);
                    })
                ->groupBy('arrondissement.id')
                ->get();

                return view('statistiques.visionPerArrondChart')->with('resultats', $resultats);
               }elseif($request->dateD!=null && $request->dateF!=null){

            $request->validate([
                'dateD' => 'required',
                'dateF' => 'required|date|after_or_equal:start_date',
            ]);


            $annee = $request->input('annee');
            $lastdy = $request->input('dateF');

            $resultats = DB::table('arrondissement')
            ->select('arrondissement.libellea as arrond', 
                DB::raw('SUM(paiement.montant) as montantrecouvre'), 
                DB::raw('SUM(factures.montant) as montantFactur'))
                ->leftJoin('societe as soc', function ($join) use($lastdy) {
                    $join->on('soc.arrondissement_id', '=', 'arrondissement.id')
                        ->where('soc.created_at', '<=', $lastdy);
                })
                ->leftJoin('factures as fac', function ($join) use($annee) {
                    $join->on('soc.id', '=', 'fac.societe_id')
                        ->where('fac.annee', '=', $annee);
                    })
                
                    ->leftJoin('paiement as pmnt', function ($join) {
                        $join->on('fac.id', '=', 'pmnt.facture_id')
                            ->where('pmnt.statut', '!=', 5);
                    })
            ->groupBy('arrondissement.id')
            ->get();

            return view('statistiques.visionPerArrondChart')->with('resultats', $resultats);
        }elseif($request->dateD==null || $request->dateF==null){
            Session::flash('error', 'Vérifier les champs de filtre,Veuillez renseigner une plage correcte');
            return redirect()->back();

        }

    }
    
}

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\paiement  $paiement
     * 
     */
    public function show(paiement $paiement)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\paiement  $paiement
     * 
     */
    public function edit(paiement $paiement)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\paiement  $paiement
     * 
     */
    public function update(Request $request, paiement $paiement)
    {
        //
    }

    public function diagramByNombre(){
        $Number = paiement::with('societe')->get();
        return view('visionParPeriode',compact('Number'));
    }
    public function indexStatAgent()
    {   
        $paie=paiement::select("*", DB::raw('SUM(montant) as total'), DB::raw('count(id_paie) as nb'))
        ->join('users as u','u.id','=',"agent_recouvr")->where('statut','!=',5)
        ->groupby('agent_recouvr')->orderByRaw('nb')->offset(0)->limit(500)->get();  

        return view('visionParAgent',compact('paie'));
    }

    public function statArrondCateg(){
        $jour_an_cours = Carbon::now()->startOfYear(); 
	    $lastdy = Carbon::now()->endOfYear();
	    $annee = Carbon::now()->year;
 
        $datas = DB::table('arrondissement as ard')
        ->select('ard.libellea as arrond', 'cat.libelle as categ',
            DB::raw('COUNT(fac.societe_id) AS nombre_soc_factures'),
            DB::raw('COUNT(DISTINCT soc.id) AS nombre_societes'),
            DB::raw('COUNT(pmnt.id_paie) AS nombre_rec'),
            DB::raw('SUM(pmnt.montant) AS recouvre'),
            DB::raw('SUM(fac.montant) AS total_facturation'),
            DB::raw('SUM(g.montant) AS total_a_facturer'),
        )
		->leftJoin('societe as soc', function ($join) use($lastdy) {
        $join->on('soc.arrondissement_id', '=', 'ard.id')
            ->where('soc.created_at', '<=', $lastdy)
            ->where('soc.fl_sup', 'N');
    })
        ->leftJoin('categorie as cat', 'cat.id', '=', 'soc.categorie_id') 
        ->leftJoin('grille as g', 'soc.grille_id',  '=', 'g.id')
        ->leftJoin('factures as fac', function ($join) use($annee) {
        $join->on('soc.id', '=', 'fac.societe_id')
            ->where('fac.annee', '=', $annee);
		})
            ->leftJoin('paiement as pmnt', function ($join) {
                $join->on('fac.id', '=', 'pmnt.facture_id')
                    ->where('pmnt.statut', '!=', 5);
            })
        ->groupBy('ard.id', 'cat.id')
        ->orderBy('arrond', 'asc')
        ->get();

        return view('statistiques.visionArrondCat', compact('datas','annee'));
    }




    public function filter(Request $request){
   
        $lastdy = $request->input('dateF');
        $annee = $request->input('annee');
        if($annee!=null &&  $lastdy!=null){
     
            $datas = DB::table('arrondissement as ard')
            ->select('ard.libellea as arrond', 'cat.libelle as categ',
                DB::raw('COUNT(fac.societe_id) AS nombre_soc_factures'),
                DB::raw('COUNT(DISTINCT soc.id) AS nombre_societes'),
                DB::raw('COUNT(pmnt.id_paie) AS nombre_rec'),
                DB::raw('SUM(pmnt.montant) AS recouvre'),
                DB::raw('SUM(fac.montant) AS total_facturation'),
                DB::raw('SUM(g.montant) AS total_a_facturer'),
            )
            ->leftJoin('societe as soc', function ($join) use($lastdy) {
            $join->on('soc.arrondissement_id', '=', 'ard.id')
                ->where('soc.created_at', '<=', $lastdy)
                ->where('soc.fl_sup', 'N');
        })
            ->leftJoin('categorie as cat', 'cat.id', '=', 'soc.categorie_id') 
            ->leftJoin('grille as g', 'soc.grille_id',  '=', 'g.id')
            ->leftJoin('factures as fac', function ($join) use($annee) {
            $join->on('soc.id', '=', 'fac.societe_id')
                ->where('fac.annee', '=', $annee);
            })
            
                ->leftJoin('paiement as pmnt', function ($join) {
                    $join->on('fac.id', '=', 'pmnt.facture_id')
                        ->where('pmnt.statut', '!=', 5);
                })
    ->groupBy('ard.id', 'cat.id')
            ->orderBy('arrond', 'asc')
    ->get();
    
    
            return response()->json($datas);
        }else{
            $datas="-1";
            return response()->json($datas);
        }
            
    }
    

   function filterDiag(Request $request){

    $annee = $request->input('annee');
    $lastdy = $request->input('dateF');

        $resultats = DB::table('arrondissement')
        ->select('arrondissement.libellea as arrond', 
        DB::raw('SUM(pmnt.montant) as montantrecouvre'), 
        DB::raw('SUM(fac.montant) as montantFactur'))
        ->leftJoin('societe as soc', function ($join) use($lastdy) {
            $join->on('soc.arrondissement_id', '=', 'arrondissement.id')
                ->where('soc.created_at', '<=', $lastdy)
                ->where('soc.fl_sup', 'N');
        })
        ->leftJoin('factures as fac', function ($join) use($annee) {
            $join->on('soc.id', '=', 'fac.societe_id')
                ->where('fac.annee', '=', $annee);
            })
            ->leftJoin('paiement as pmnt', function ($join) {
                $join->on('fac.id', '=', 'pmnt.facture_id')
                    ->where('pmnt.statut', '!=', 5);
            })
        ->groupBy('arrondissement.id')
        ->get();

        return response()->json($resultats);

}

public function stat_globale() {
    $annee = Carbon::now()->year;

    $lettre=new lettres();
    $total = DB::table('societe')
    ->leftJoin('grille', 'grille.id', '=', 'societe.grille_id') 
    ->select(DB::raw('SUM(grille.montant) as total_montant'))
    ->where('societe.fl_sup', 'N')
    ->get()
    ->first()
    ->total_montant;

    $recouvre = DB::table('factures') 
            ->leftJoin('paiement as pmnt', function ($join) {
                $join->on('factures.id', '=', 'pmnt.facture_id')
                    ->where('pmnt.statut', '!=', 5);
            })
    ->where('factures.annee', $annee) 
    ->select(DB::raw('SUM(pmnt.montant) as montant_total')) 
    ->get() 
    ->first() 
    ->montant_total; 

    $facture = DB::table('factures as fac')
    ->join('societe', 'fac.societe_id', '=', 'societe.id')
    ->where('societe.fl_sup', 'N') 
    ->where('fac.annee', $annee) 
    ->select(
        DB::raw('(SUM(fac.montant) - SUM(fac.montant_negoc)) as montant_total') 
    )
    ->get() 
    ->first() 
    ->montant_total; 

    $FactEdit = Facture::join('societe', 'factures.societe_id', '=', 'societe.id')
    
    ->where('societe.fl_sup', 'N')
    ->where('annee', $annee)->count();

    $FactSign = Facture::join('societe', 'factures.societe_id', '=', 'societe.id')
    
    ->where('societe.fl_sup', 'N')
                ->where('annee', $annee)
                ->where('statut', 1)
                ->count();

    $FactDist = Facture::join('societe', 'factures.societe_id', '=', 'societe.id')
    
    ->where('societe.fl_sup', 'N')
                ->where('annee', $annee)
                ->where('statut', 2)
                ->count();  
                
    $Paiement = Paiement::leftJoin('factures as f', 'f.id', '=', 'paiement.facture_id')
        ->where('paiement.statut','!=',5)
    
    ->where('f.annee', $annee)
    #->where('paiement.statut', 1)
    ->count();

    $attestations = DB::table('attestations')
                    ->whereYear('created_at', $annee)
                    ->count();

    $attesSign = DB::table('attestations')
                    ->whereYear('created_at', $annee)
                    ->where('etat', 1)
                    ->count();

    $journaux = journal::orderBy('idjournal', 'desc')->take(6)->get();

   
    return view('graphe', compact('total','facture','recouvre','lettre','journaux',
    'annee','FactEdit','FactSign','FactDist','Paiement','attestations','attesSign'));
}

public function getChartData(Request $request)
{
    $lettre=new lettres();
    $annee =  $request->annee;
    $lastdy = $request->lastD;
    
    $total = DB::table('societe')
        ->leftJoin('grille', function ($join) use($lastdy) {
            $join->on('grille.id', '=', 'societe.grille_id')
                ->where('societe.created_at', '<=', $lastdy)
                 ->where('societe.fl_sup', 'N');
        })
        ->select(DB::raw('COALESCE(SUM(grille.montant), 0) as total_montant'))
        ->get()
        ->first()
        ->total_montant;

    $recouvre = DB::table('factures') 
            ->leftJoin('paiement as pmnt', function ($join) {
                $join->on('factures.id', '=', 'pmnt.facture_id')
                    ->where('pmnt.statut', '!=', 5);
            })
        ->where('factures.annee', $annee) 
        ->select(DB::raw('COALESCE(SUM(paiement.montant),0) as montant_total')) 
        ->get() 
        ->first() 
        ->montant_total; 

    $facture = DB::table('factures as fac') 
        ->join('societe', 'factures.societe_id', '=', 'societe.id')
    
        ->where('societe.fl_sup', 'N')
        ->where('fac.annee', $annee) 
        ->select(DB::raw('COALESCE(SUM(fac.montant) - SUM(fac.montant_negoc),0) as montant_total')) 
        ->get() 
        ->first() 
        ->montant_total; 

        $FactEdit = Facture::join('societe', 'factures.societe_id', '=', 'societe.id')
    
                    ->where('societe.fl_sup', 'N')
                    ->where('annee', $annee)->count();

        $FactSign = Facture::join('societe', 'factures.societe_id', '=', 'societe.id')
    
                    ->where('societe.fl_sup', 'N')
                    ->where('annee', $annee)
                    ->where('statut', 1)
                    ->count();
    
        $FactDist = Facture::join('societe', 'factures.societe_id', '=', 'societe.id')
    
                    ->where('societe.fl_sup', 'N')
                    ->where('annee', $annee)
                    ->where('statut', 2)
                    ->count();  
                    
        $Paiement = Paiement::leftJoin('factures as f', 'f.id', '=', 'paiement.facture_id')
        ->where('f.annee', $annee)
        ->where('paiement.statut','!=', 5)
        ->count();
    
        $attestations = DB::table('attestations')
                        ->whereYear('created_at', $annee)
                        ->count();
    
        $attesSign = DB::table('attestations')
                        ->whereYear('created_at', $annee)
                        ->where('etat', 1)
                        ->count();

           $nbrSoc = DB::table('societe')
                        ->where('created_at', '<=', $lastdy)
                        ->where('fl_sup', 'N')
                        ->count();

    $recouvretxt = $lettre->Conversion($recouvre);
    $facturetxt = $lettre->Conversion($facture);

    $data = array(
        'facturetxt'=> $facturetxt,
        'recouvretxt'=> $recouvretxt,
        'recouvre' => $recouvre,
        'facture' => $facture,
        'total' => $total,
        'FactEdit' => $FactEdit,
        'FactSign' => $FactSign,
        'FactDist' => $FactDist,
        'Paiement' => $Paiement,
        'attestations' => $attestations,
        'attesSign' => $attesSign,
        'nbrSoc' => $nbrSoc
    );

    return response()->json($data);
}

   
    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\paiement  $paiement
     * 
     */
    public function destroy(paiement $paiement)
    {
        //
    }
}
