<?php

namespace App\Http\Controllers\clients;
use App\Models\clients;
use App\Models\identification\societe;
use App\Models\client;
use App\Http\Controllers\Controller;
use App\Models\incidents;
use DB;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use App\Models\param_glob;

class clientController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     */
    public function index()
    {
      //  $this->initializeClients();

        $clients = DB::table('societe as soc')
            ->select(
                'soc.id as id_societe',
                //'idclients',
                'soc.nom_ets',
                'soc.adresse',
                'soc.tel',
                'g.code',
                'soc.ville',
                DB::raw('count(inci.id_societe) as nombreTotal'),
            )
            ->join('grille as g', 'soc.grille_id', '=', 'g.id')
            ->leftJoin('incidents as inci', 'inci.id_societe','=','soc.id')
            ->groupBy('soc.id')
            ->where('pa_statut_soc_id', 16)
            ->get();

        $types = param_glob::select(['id', 'libelle_param'])
            ->where('code_type_param', 'PBCLT')
            ->get();
        $statuts = param_glob::select(['id', 'libelle_param'])
            ->where('code_type_param', 'PBSTU')
            ->get();

        return view('pages.clients.showClients', compact('clients', 'types', 'statuts'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create($id, Request $request)
    {

        $request->validate([
            'description' => ['required'],
            'statut_pb' => ['required'],
            'type_pb_client' => ['required'],
            'date_prob' => ['required'],
        ]);
    
        $statut = param_glob::find($request->statut_pb);
        $type = param_glob::find($request->type_pb_client);
    
        if (!$statut || !$type) {
            return redirect()->back()->withErrors('Le type ou le statut sélectionné est invalide.');
        }

        $client = societe::findOrFail($id); // Vérifie que le client existe.
    
        $incident = new incidents();
        $incident->id_societe = $client->id;
        $incident->description = $request->description;
        $incident->id_param_type_pb_client = $type->id;
        $incident->id_param_statut_pb_client = $statut->id;
        $incident->date_probleme = $request->date_prob;
    
        if (!empty($request->descriptif)) {
            $incident->description_resolution = $request->descriptif;
        }
    
        $incident->save();
    
        return redirect()->route('clients.index')->with('success', 'Incident ajouté avec succès.');
    }


    /**
     * Store a newly created resource in storage.
     * @param  \Illuminate\Http\Request  $request
     */
    public function store(Request $request)
    {
        $searchTerm = $request->searchTerm;
        $filterType = $request->filterType;
        $filterStatut = $request->filterStatut;

        $types = param_glob::select(['id', 'libelle_param'])
            ->where('code_type_param', 'PBCLT')
            ->get();
        $statuts = param_glob::select(['id', 'libelle_param'])
            ->where('code_type_param', 'PBSTU')
            ->get();

        $query = incidents::select([
            'incidents.id_societe',
            'incidents.id_incidents',
            'soc.nom_ets',
            'soc.adresse',
            'soc.tel',
            'g.code',
            DB::raw('count(id_societe) as nombreTotal'),
            'soc.ville'
        ])
            ->join('societe as soc', 'soc.id', '=', 'incidents.id_societe')
            ->join('grille as g', 'soc.grille_id', '=', 'g.id');

        if ($searchTerm) {
            $query->where(function ($q) use ($searchTerm) {
                // Jointure pour param_glob
                $q->Where('soc.nom_ets', 'like', '%' . $searchTerm . '%');
            });
        }

        if ($filterType) {
            $query
                ->where('incidents.id_param_type_pb_client', '=', $filterType)
            ;
        }

        if ($filterStatut) {
            $query->where('incidents.id_param_statut_pb_client', '=', $filterStatut);
        }
        ;

        $clients = $query->groupBy('id_societe')->get();

        return view('pages.clients.showClients', compact('clients', 'types', 'statuts'));
    }


    /**
     * Display the specified resource.
     * @param  int  $id
     */
    public function show($id)
    {
        $clients = DB::table('incidents as clt')
            ->select(
                'id_societe',
                'id_incidents',
                'soc.nom_ets',
                'clt.description',
                'clt.description_resolution',
                'clt.date_resolution',
                'soc.tel',
                'pType.libelle_param as type',
                'pStatut.libelle_param as statut',
                'clt.date_probleme',
                'soc.ville'
            )
            ->join('societe as soc', 'soc.id', '=', 'clt.id_societe')
            ->join('param_glob as pType', 'pType.id', '=', 'clt.id_param_type_pb_client')
            ->join('param_glob as pStatut', 'pStatut.id', '=', 'clt.id_param_statut_pb_client')
            ->where('id_societe', $id)
            ->get();
        return view('pages.clients.clientDetail', compact('clients'));
    }

    /**
     * Show the form for editing the specified resource.
     * @param  int  $id
     */
    public function edit($id)
    {
        $client = societe::find($id);
        $types = param_glob::select(['id', 'libelle_param'])
            ->where('code_type_param', 'PBCLT')
            ->get();
        $statuts = param_glob::select(['id', 'libelle_param'])
            ->where('code_type_param', 'PBSTU')
            ->get();
        return view('clients.AddClientProblem', compact('client', 'types', 'statuts'));
    }
    public function showEditPage($id)
    {
        $client = incidents::find($id);
        $types = param_glob::select(['id', 'libelle_param'])
            ->where('code_type_param', 'PBCLT')
            ->get();
        $statuts = param_glob::select(['id', 'libelle_param'])
            ->where('code_type_param', 'PBSTU')
            ->get();
        return view('clients.editClientProblem', compact('client', 'types', 'statuts'));
    }

    /**
     * Update the specified resource in storage.
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     */
    public function update(Request $request, $id)
    {
        $request->validate([
            'description' => ['required'],
            'statut_pb' => ['required'],
            'type_pb_client' => ['required'],
            'date_prob' => ['required'],
        ]);
    
        $statut = param_glob::find($request->statut_pb);
        $type = param_glob::find($request->type_pb_client);
    
        if (!$statut || !$type) {
            return redirect()->back()->withErrors('Le type ou le statut sélectionné est invalide.');
        }

        $client = societe::findOrFail($id); // Vérifie que le client existe.
    
        $incident =incidents::find($id);
       // $incident->id_societe = $client->id;
        $incident->description = $request->description;
        $incident->id_param_type_pb_client = $type->id;
        $incident->id_param_statut_pb_client = $statut->id;
        $incident->date_probleme = $request->date_prob;
    
        if (!empty($request->descriptif)) {
            $incident->description_resolution = $request->descriptif;
        }
    
        $incident->save();
    
        return redirect()->route('clients.index')->with('success', 'Incident modifié avec succès.');
    }

    /**
     * Remove the specified resource from storage.
     * @param  int  $id
     */
    public function destroy($id)
    {
        $clients = societe::find($id);
        $clients->pa_statut_soc_id = 17;
        $clients->save();
        return redirect()->route('clients.index')->with('success', 'Client archivé avec succès.');

    }

    public function validerProblemClient(Request $request, $id)
    {
        $client = incidents::find($id);
        $param = param_glob::find(41);
        $client->id_param_statut_pb_client = $param->id;
        $client->description_resolution = $request->descriptif;
        $client->date_resolution = $request->date_resol;
        $client->date_upd = Carbon::now();
        $client->save();
        return redirect()->route('clients.index')
            ->with('success', 'Les informations du client ont été mises à jour avec succès.');
    }

    public function comboboxData()
    {
        $types = param_glob::select(['id', 'libelle_param'])
            ->where('code_type_param', 'PBCLT')
            ->get();
        $statuts = param_glob::select(['id', 'libelle_param'])
            ->where('code_type_param', 'PBSTU')
            ->get();
    }
}
