<?php

namespace App\Http\Controllers\clients;
use App\Http\Controllers\Controller;
use App\Models\clients;
use Carbon\Carbon;
use Illuminate\Http\Request;
use App\Models\client;
use DB;
use App\Models\param_glob;
use Barryvdh\DomPDF\Facade\Pdf;
use App\Models\identification\societe;
use Illuminate\Support\Facades\Auth;

class suiviClientController extends Controller
{
    public function index()
    {
        $this->initializeClients();

        $clients = DB::table('client as clts')
            ->select(
                'idclient',
                'soc.id',
                'soc.nom_ets',
                'soc.adresse',
                'soc.tel',
                'statut.libelle_param',
                'soc.ville'
            )
            ->join('societe as soc', 'soc.id', '=', 'clts.id_societe')
            ->join('grille as g', 'soc.grille_id', '=', 'g.id')
            ->join('param_glob as statut', 'clts.id_param_statut_client', '=', 'statut.id')
            ->where('id_param_statut_client', '<>', 42)
            ->get();
        return view("pages.clients.suiviClients", compact('clients'));
    }

    public function create($id)
    {

        $clients = DB::table('client as clts')
            ->select(
                'idclient',
                'id_societe',
                'soc.id',
                'soc.nom_ets',
                'soc.adresse',
                'soc.tel',
                'id_param_statut_client',
                'statut.libelle_param'
            )
            ->join('societe as soc', 'soc.id', '=', 'clts.id_societe')
            ->join('param_glob as statut', 'clts.id_param_statut_client', '=', 'statut.id')
            ->where('idclient', $id)
            ->first();

        $statuts = param_glob::select(['id', 'libelle_param'])
            ->where('code_type_param', 'CLTSTU')
            ->get();

        return view('clients.addClientTrackingContract', compact('clients', 'statuts'));
    }

    public function destroy($id)
    {
        $clients = clients::find($id);
        $statut = param_glob::where('code_param', 'CLTSTU06')->first();
        //echo $statut->id;
        $clients->id_param_statut_client = $statut->id;
        $clients->save();
        return redirect()->back()->with('success', 'Client archivé avec succès.');
    }

    public function store(Request $request)
    {
        if (!empty(request('proforma'))) {
         //  dd($request);
            $PrintDate = $request->dateFacture;
            $IntendantName = $request->nom_intendant;
            $ShoolShort = $request->nom_abrege;
            $SetUp = $request->setUpFees;
            $Desktop = $request->DesktopFees;
            $Screen = $request->ScreenFees;
            $keyboard = $request->KeyboardFees;
            $Mouse = $request->MouseFees;
            $VGA = $request->VGAFees;
            $Office = $request->officeFees;

            $bills = societe::where('id', $request->id)->get();
            $now = Carbon::now()->format('y-m-d');
            $pdf = PDF::loadView(
                'print.proformaFacture'
                , compact('bills', 'now',
                'PrintDate','IntendantName','ShoolShort','SetUp',
                'Desktop','Screen','keyboard','Mouse','VGA','Office')
            );
            return $pdf->stream();
        }

        if (!empty(request('statut'))) {
            //dd($request);
            // $bills = societe::where('societe_id', $id)->orderBy('daterdv')->get();
            $now = Carbon::now();
            $pdf = PDF::loadView(
                'print.proformaFacture'
                //, compact('bills', 'now')
            );
            return $pdf->stream();
        }
    }

    public function PrintProformaBill(Request $request, $id)
    {
        $bills = societe::where('societe_id', $id)->orderBy('daterdv')->get();
        $now = Carbon::now();
        $pdf = PDF::loadView('print.proformaFacture', compact('bills', 'now'));
        return $pdf->stream();
    }


    // initialisation de la table cliente avec les données de prospect
    private function initializeClients()
    {
        $existingSocieteIds = clients::pluck('id_societe')->toArray();
        $societes = societe::where('pa_statut_soc_id', 16)
            ->whereNotIn('id', $existingSocieteIds)
            ->get();

        $param = param_glob::find(33);

        $data = [];
        foreach ($societes as $societe) {
            $data[] = [
                'id_societe' => $societe->id,
                'user_id' => Auth::user()->id,
                'id_param_statut_client' => $param->id
            ];
        }

        if (!empty($data)) {
            clients::insert($data);
        }
    }
}