<?php

namespace App\Http\Controllers\compta;

use Carbon\Carbon;
use App\Models\paiement;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Session;
use App\Http\Controllers\recouvrement\PaiementSearchAndActions;
use App\Models\lettres;

class Comptabilite extends Controller
{
    public function index()
    {


        $lettre = new lettres();
        $lespaiements = paiement::leftjoin('societe', 'paiement.societe_id', '=', 'societe.id')->where('paiement.statut','=', '1')->orderBy('datepaie', 'DESC')->offset(0)->limit(100)->get();
        $total = $lespaiements->sum('montant');
        return view('pages.compta.paiement', compact('lespaiements', 'total', 'lettre'));
    }

    public function store(Request $request)
    {
        if (request('dataExportation')) {

            $dateD = Carbon::createFromFormat('Y-m-d', request('date1'));
            $dateF = Carbon::createFromFormat('Y-m-d', request('date2'));

            if ($dateD->greaterThan($dateF)) {
                Session::flash('info', 'La date de début de la période est supérieure à la date de fin!');
                return redirect('compta');
            }
            $object = new PaiementSearchAndActions();
            $file = $object->dataExportationProcess($request, 1);
            if (request('fileType') == 'PDF' && $file != null) {
                return $file->stream();
            }elseif (request('fileType') == 'Excel' && $file == 1) {
                Session::flash("download", $object->box);
                Session::flash("success", "Fichier généré avec succès");

                return redirect("/compta");
            } 
            elseif ($file == null) {
                Session::flash('info', 'Pas de donnée pour cette période!');
                return redirect('/compta');
            }
        }

        if(request('chercher')){

            $lettre = new lettres();
            $object = new PaiementSearchAndActions();
            $statut = 1;
            $lespaiements = $object->searchProcess($request, $statut);
            
            if($lespaiements == null){
                Session::flash('info', 'Pas de critère de recherche!');
                return redirect('/compta');
            }
            $total = $lespaiements->sum('montant');
            return view('pages.compta.paiement', compact('lespaiements', 'total', 'lettre'));
        }

    }
}
