<?php

namespace App\Http\Controllers\entreprises;

use App\Models\param_glob;
use App\Models\User;
use App\Models\Voie;
use App\Models\journal;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use App\Models\admin\arrondissement;
use Illuminate\Support\Facades\Auth;
use App\Models\identification\societe;
use Illuminate\Support\Facades\Session;
use App\Models\identification\etablissement;

class ets extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function __construct()
    {
        $this->middleware('fichier');
    }
    public function index()
    {

        $lettre = new \App\Models\lettres();
        $users = User::select('id', 'name')->get();
        $auth = Auth::user();
        $ets = societe::where('fl_sup', 'N')
        ->where('pa_statut_soc_id','<>',16)
        ->whereNull('date_sup')->orderBy('id', 'DESC')
        ->offset(0)->limit(25)->get();
        return view("pages.entreprises.ets", compact('ets', 'users'));
    }

    /*
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $ets = new etablissement();
        return view("pages.entreprises.createts", compact('ets'));
    }

    public function showEtsUpd($id)
    {
        $paramResult = param_glob::select(['id', 'libelle_param'])->where('code_type_param', 'RDRSLT')->get();
        $parametreRepl = param_glob::select(['id', 'libelle_param'])->where('code_type_param', 'RDRPL')->get();
        $parametreMotif = param_glob::select(['id', 'libelle_param'])->where('code_type_param', 'RDMTF')->get();
        $paramType = param_glob::select(['id', 'libelle_param'])->where('code_type_param', 'TYPRD')->get();
        $socNat = param_glob::select(['id', 'libelle_param'])->where('code_type_param', 'NOTSO')->get();
        $socType = param_glob::select(['id', 'libelle_param'])->where('code_type_param', 'TYPSO')->get();
        $socStat = param_glob::select(['id', 'libelle_param'])->where('code_type_param', 'STCSO')->get();
        $ets = societe::find($id);
        $action = request()->query('action');
        $details = false;

        if ($action == 'detailsUpdEts') {
            $details = true;
        }
        //  dd($details);

        return view('pages.entreprises.modifets', compact(
            'ets',
            'parametreRepl',
            'paramType',
            'parametreMotif',
            'paramResult',
            'socNat',
            'socType',
            'socStat',
            'details'
        ));
    }

    public function showEtsDetails($id)
    {
        $paramResult = param_glob::select(['id', 'libelle_param'])->where('code_type_param', 'RDRSLT')->get();
        $parametreRepl = param_glob::select(['id', 'libelle_param'])->where('code_type_param', 'RDRPL')->get();
        $parametreMotif = param_glob::select(['id', 'libelle_param'])->where('code_type_param', 'RDMTF')->get();
        $paramType = param_glob::select(['id', 'libelle_param'])->where('code_type_param', 'TYPRD')->get();
        $socNat = param_glob::select(['id', 'libelle_param'])->where('code_type_param', 'NOTSO')->get();
        $socType = param_glob::select(['id', 'libelle_param'])->where('code_type_param', 'TYPSO')->get();
        $socStat = param_glob::select(['id', 'libelle_param'])->where('code_type_param', 'STCSO')->get();
        $ets = societe::where('id', $id)->get();
        //  dd($ets);
        return view('pages/entreprises/detailsets', compact(
            'ets',
            'parametreRepl',
            'paramType',
            'parametreMotif',
            'paramResult',
            'socNat',
            'socType',
            'socStat',
        ));

        if (!empty(request('retour_arr'))) {
            $users = User::select('id', 'name')->get();
            $lettre = new \App\Models\lettres();
            $ets = societe::where('fl_sup', 'N')->orderBy('id', 'DESC')->offset(0)->limit(50)->get();
            return view("pages/entreprises/ets", compact('ets', 'lettre', 'users'));
        }
    }

    public function showEtsLocalisation($id)
    {

        if ($id != null) {
            $ets = societe::find($id);
            if (!empty($ets->geoloc) & ($ets->geoloc != "undefined&undefined")) {
                $coordonnees_json = self::makeJsonCoordonnees($id);
                return view('cartegenerale', compact('coordonnees_json'));
            } else {

                Session::flash('erreur', 'L\'établissement choisi n\'a pas de coordonnées maps définies!');
                return redirect('/ets');
            }
        } else {

            $coordonnees_json = self::makeJsonCoordonnees();
            return view('cartegenerale', compact('coordonnees_json'));
        }
    }
    /*
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $condition = array();
        $cond = 'form_jurid';
        if (!empty(request('myinput'))) {
            $request->validate([
                'idets' => ['required'],
            ]);
            $ets = societe::find(request('idets'));

            if (count($ets->factures) > 0) {
                Session::flash('message', 'Vous ne pouvez pas supprimer le Ressortissant');
                return redirect('/ets');
            } else {
                $journal = new journal();
                $journal->type = 5;
                $journal->user_id = Auth::user()->id;
                $journal->contenu = 'Suppression de ' . $ets->nom_ets . '';
                $journal->datej = now();

                DB::transaction(function () use ($ets, $journal) {
                    $ets->delete();
                    $ets->gerant->delete();
                    $journal->save();
                    Session::flash('message', 'Suppression  effectuée avec succès');
                });
                return redirect('/ets');
            }
        }

        if (!empty(request('printf'))) {
            $request->validate([
                'idets' => ['required'],
            ]);

            $ets = societe::find(request('idets'));
            $lettre = new \App\Models\lettres();
            //dd($facture);
            return view('print/fiche', compact('ets', 'lettre'));
        } elseif (!empty(request('printai'))) {
            $request->validate([
                'idets' => ['required'],
            ]);

            $ets = societe::find(request('idets'));
            $lettre = new \App\Models\lettres();
            //dd($facture);
            if ($ets->categorie->id == 2) {
                return view('print/iets', compact('ets', 'lettre'));
            } else {
                return view('print/isociete', compact('ets', 'lettre'));
            }
        }

        if (!empty(request('query'))) {

            $ets = societe::where('nom_ets', 'LIKE', '%' . request('query') . '%')->get();


            //dd(app('url')->previous());
            $adresse = explode('/', app('url')->previous());
            //dd($adresse);
            $adr = $adresse[3];
            if ($adr == 'caisse') {
                return view("pages/caisse", compact('ets'));
            } elseif ($adr == 'facturation') {
                return view("pages/facturation", compact('ets'));
            } else {
                return view("pages/entreprises/ets", compact('ets'));
            }
        }

        if (!empty(request('supprimer'))) {
            // dd($request);
            
            $selectedIds = $request->input('selectedIds', []);
            $dateSup = now()->format('Y-m-d H:i:s');
            $userUpdateId = Auth::user()->id;
            $value = societe::whereIn('id', $selectedIds)->get();
            foreach ($value as $societe) {
                $societe->fl_sup = 'O';
                $societe->date_sup = $dateSup;
                $societe->user_update_id = $userUpdateId;
                $societe->save();
                // update(['fl_sup' => 'O', 'date_sup' => $dateSup, 'user_update_id' => $userUpdateId]);
            }
            
            Session::flash('success', 'Opération reussie!');
            return $this->index();
        }

        if (!empty(request('recherche'))) {

             $lettre = new \App\Models\lettres();
            $users = User::select('id', 'name')->get();

            // Début de la requête
            $query = societe::query()
                ->where('fl_sup', 'N')
                ->where('pa_statut_soc_id', '<>', 16);

            // Liste des champs à filtrer dynamiquement
            $filters = [
                'grille_id'       => request('grille_id'),
                'id_pa_origin'    => request('form_jurid'),
                'arrondissement_id' => request('numero'),
                'categorie_id'    => request('categorie_id'),
                'id_pa_commune'   => request('ville_ets'),
                'id_pa_province'  => request('province_ets'),
                'id_pa_region'    => request('regions_ets'),
            ];

            // Appliquer les filtres seulement si la valeur est valide
            foreach ($filters as $field => $value) {
                if (!empty($value) && $value !== 'Choisissez une province' && $value !== 'Choisissez une ville' && $value !== 'Choisissez une région' && $value !== 'Sélectionnez un champ') {
                    $query->where($field, $value);
                }
            }

            // Ajout des filtres LIKE pour `nom_ets` et `adresse`
            if (!empty(request('nom_ets')) && request('nom_ets') !== 'Sélectionnez un champ') {
                $query->where('nom_ets', 'LIKE', '%' . request('nom_ets') . '%');
            }

            if (!empty(request('adresse')) && request('adresse') !== 'Sélectionnez un champ') {
                $query->where('adresse', 'LIKE', '%' . request('adresse') . '%');
            }

            
            $ets = $query->limit(35)->get();

            // Vérifier si des résultats existent
            if ($ets->isEmpty()) {
                Session::flash('message', 'Aucune donnée existante');
                return view("pages/entreprises/ets", compact('ets', 'lettre', 'users'));
            }

            return view("pages/entreprises/ets", compact('ets', 'lettre', 'users'));
        }


        if (!empty(request('recherche_validation_supp'))) {

            // dd("recheche dans la liste des ets a valides");
            $lettre = new \App\Models\lettres();

            $ets = $this->rechercheDonneesValider(
                request('grille_id'),
                request('activite_id'),
                request('numero'),
                request('form_jurid'),
                request('categorie_id'),
                request('auteur_sup'),
                request('nom_ets'),
                request('adresse')
            );

            // $ets = $this->modalResearch($request);
            if (count($ets) < 1) {
                Session::flash('message', 'Aucune donnée existante');
                $ets = [];
                return view("pages/entreprises/validationentreprisesupp", compact('ets', 'lettre'));
            }
            return view("pages/entreprises/validationentreprisesupp", compact('ets', 'lettre'));
        }

        if (!empty(request('rechercherValider'))) {
            $this->rechercheValider();
            return $this->show();
        }

        if (!empty(request('rechercherAnnuler'))) {
            $this->rechercheAnnuler();
            return $this->show();
        }

        if (!empty(request('affecter'))) {
            $selectedIds = $request->input('selectedIds', []);
            // dd($request->userAffecterId);
            // Récupérer les sociétés sélectionnées
            $societes = societe::whereIn('id', $request->selectedIds)->get();
            $agent = User::find($request->userAffecterId);
            foreach ($societes as $societe) {
                $societe->user_affecte_id = $agent->id;
                $societe->save();
            }
            Session::flash('message', 'Société(s) affectée(s) ');
            return redirect()->back();
        }
    }

    function makeJsonCoordonnees($id = null)
    {
        if ($id != null) {
            $data = societe::find($id);
            $coords = explode('$', $data->geoloc);
            $lat = $coords[0];
            $lng = $coords[1];
            $name = $data->nom_ets;
            $id = $data->id;

            // Ajout des coordonnées géographiques dans le tableau
            $coordonnees[] = array('lat' => $lat, 'lng' => $lng, 'name' => $name, 'id' => $id);
            $coordonnees_json = json_encode($coordonnees);
        } else {
            $datas = societe::whereNotNull('geoloc')->take(100)->get();
            $coordonnees = array();

            // Parcours de toutes les entreprises
            foreach ($datas as $data) {
                // Récupération des coordonnées géographiques de l'entreprise
                $coords = explode('$', $data->geoloc);
                $lat = $coords[0];
                $lng = $coords[1];
                $name = $data->nom_ets;
                $id = $data->id;
                // Ajout des coordonnées géographiques dans le tableau
                $coordonnees[] = array('lat' => $lat, 'lng' => $lng, 'name' => $name, 'id' => $id);
            }
            $coordonnees_json = json_encode($coordonnees);
        }



        return $coordonnees_json;
    }

    public function supprimer($id)
    {
        $dateSup = now()->format('Y-m-d H:i:s');
        $userUpdateId = Auth::user()->id;
        $value = DB::table('societe')->where('id', $id)->update(['fl_sup' => 'O', 'date_sup' => $dateSup, 'user_update_id' => $userUpdateId]);
        Session::flash('success', 'Opération reussie!');
        return redirect()->route('ets.index');
    }

    public function recherche(Request $request)
    {
        if (!empty(request('query'))) {

            $ets = etablissement::with('societe')
                ->leftJoin('societe', 'etablissement.idsociete', '=', 'societe.idsociete')
                ->join('gerant', 'etablissement.idgerant', '=', 'gerant.idgerant')
                ->leftjoin('zone_admin', 'etablissement.idzadmin', '=', 'zone_admin.idzadmin')
                ->leftjoin('quartier', 'zone_admin.idquartier', '=', 'quartier.idquartier')
                ->where('nom_ets', 'LIKE', '%' . request('query') . '%')->where('fl_sup', 'N')
                ->get();
            //dd(app('url')->previous());
            $adresse = explode('/', app('url')->previous());
            //dd($adresse);
            $adr = $adresse[3];
            if ($adr == 'caisse') {
                return view("pages/caisse", compact('ets'));
            } else {
                Session::flash('info', 'Aucune donnée n\'a été trouvée.!');
                return view("pages/ets", compact('ets'));
            }
        }
    }

    public function show()
    {
        $lettre = new \App\Models\lettres();
        $ets = societe::where('fl_sup', 'O')->whereNotNull('date_sup')->orderBy('id', 'DESC')->offset(0)->limit(50)->get();
        return view("pages.entreprises.validationentreprisesupp", compact('ets', 'lettre'));
    }

    public function annulerSuppression($id)
    {

        $dateSup = now()->format('Y-m-d H:i:s');
        $userUpdateId = Auth::user()->id;
        $value = DB::table('societe')
            ->where('id', $id)
            ->update(['fl_sup' => 'N', 'date_sup' => null, 'user_update_id' => $userUpdateId]);
        Session::flash('success', 'Opération reussie!');
        return $this->show();
    }

    public function rechercheValider()
    {

        $results = $this->rechercheDonneesValider(
            request('grille_id'),
            request('activite_id'),
            request('numero'),
            request('form_jurid'),
            request('categorie_id'),
            request('auteur_sup'),
            request('nom_ets'),
            request('adresse')
        );
        // dd($results);
        $dateSup = now()->format('Y-m-d H:i:s');
        $userUpdateId = Auth::user()->id;
        if (count($results) > 0) {
            foreach ($results as $ent) {
                $value = DB::table('societe')
                    ->where('id', $ent->id)
                    ->update(['fl_sup' => 'O', 'user_update_id' => $userUpdateId]);
            }
            Session::flash('success', 'Opération réussie!');
        }
    }

    public function rechercheAnnuler()
    {

        $results = $this->rechercheDonneesValider(
            request('grille_id'),
            request('activite_id'),
            request('numero'),
            request('form_jurid'),
            request('categorie_id'),
            request('auteur_sup'),
            request('nom_ets'),
            request('adresse')
        );

        $dateSup = now()->format('Y-m-d H:i:s');
        $userUpdateId = Auth::user()->id;

        if (count($results) > 0) {
            foreach ($results as $ets) {
                $ets = DB::table('societe')->where('id', $ets->id)
                    ->update(['fl_sup' => 'O', 'date_sup' => null]);
            }
            Session::flash('success', 'Opération réussie!');
        }
        return view('pages.entreprises.validationentreprisesupp', compact('ets'));
    }

    public function rechercheDonnees($grilleId, $activiteId, $numero, $formJurid, $categorieId, $auteurSup, $nomEts, $adresse)
    {
        $condition = [];

        if (!empty($grilleId)) {
            $condition['grille_id'] = $grilleId;
        }
        if (!empty($activiteId)) {
            $condition['activite_id'] = $activiteId;
        }
        if (!empty($numero)) {
            $condition['arrondissement_id'] = $numero;
        }
        if (!empty($formJurid)) {
            $condition['date_sup'] = $formJurid;
        }
        if (!empty($categorieId)) {
            $condition['categorie_id'] = $categorieId;
        }
        if (!empty($auteurSup)) {
            $condition['user_update_id'] = $auteurSup;
        }

        $ets_dtb = !empty($nomEts) ? 'nom_ets' : 'nom_ets';
        $ets_arg = !empty($nomEts) ? 'LIKE' : '<>';
        $ets_sai = !empty($nomEts) ? '%' . $nomEts . '%' : '';

        $adr_dtb = !empty($adresse) ? 'adresse' : 'adresse';
        $adr_arg = !empty($adresse) ? 'LIKE' : '<>';
        $adr_sai = !empty($adresse) ? '%' . $adresse . '%' : '';

        $ets = Societe::where($condition)
            ->where($ets_dtb, $ets_arg, $ets_sai)
            ->where($adr_dtb, $adr_arg, $adr_sai)
            ->where('fl_sup', 'O')
            ->get();

        return $ets;
    }

    public function rechercheDonneesValider($grilleId, $activiteId, $numero, $formJurid, $categorieId, $auteurSup, $nomEts, $adresse)
    {
        $condition = [];

        if (!empty($grilleId)) {
            $condition['grille_id'] = $grilleId;
        }
        if (!empty($activiteId)) {
            $condition['activite_id'] = $activiteId;
        }
        if (!empty($numero)) {
            $condition['arrondissement_id'] = $numero;
        }
        if (!empty($formJurid)) {
            $condition['date_sup'] = $formJurid;
        }
        if (!empty($categorieId)) {
            $condition['categorie_id'] = $categorieId;
        }
        if (!empty($auteurSup)) {
            $condition['user_update_id'] = $auteurSup;
        }

        $ets_dtb = !empty($nomEts) ? 'nom_ets' : 'nom_ets';
        $ets_arg = !empty($nomEts) ? 'LIKE' : '<>';
        $ets_sai = !empty($nomEts) ? '%' . $nomEts . '%' : '';

        $adr_dtb = !empty($adresse) ? 'adresse' : 'adresse';
        $adr_arg = !empty($adresse) ? 'LIKE' : '<>';
        $adr_sai = !empty($adresse) ? '%' . $adresse . '%' : '';

        $ets = Societe::where($condition)
            ->where($ets_dtb, $ets_arg, $ets_sai)
            ->where($adr_dtb, $adr_arg, $adr_sai)
            ->where('fl_sup', 'O')
            ->whereNotNull('date_sup')
            ->get();

        return $ets;
    }

    public function affecterAgent(Request $request)
    {
        dd(request());
    }


}