<?php

namespace App\Http\Controllers\entreprises;


//use App\Models\identification\location;
use App\ConsoleDeb;
use App\Models\taxe;
use App\Models\facture;
use App\Models\journal;
use App\Models\paiement;
use App\Models\ConsoleDebug;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Auth\AuthManager;
use App\Http\Controllers\Controller;
use App\Models\admin\arrondissement;
use Illuminate\Support\Facades\Auth;
use App\Models\identification\compte;
use App\Models\identification\gerant;
use Psy\Readline\Hoa\ConsoleException;
use App\Models\identification\societe;
use Illuminate\Support\Facades\Session;
use SebastianBergmann\Environment\Console;
use App\Models\identification\etablissement;
//use Auth;

class etsControler extends Controller
{
  public function __construct()
  {
    $this->middleware('fichier');

  }

  public function index()
  {
    //$users = App\User::paginate(15);
    $listets = etablissement::paginate(5);
    return view('identification/etablissement', compact('listets'));
  }
  public function create(Request $request)
  {
    $new = new arrondissement();

    return view('identification/etablissement', compact('new'));
  }
  public function store(Request $request)
  {
    if (!empty(request('ajouter'))) {
      $request->validate([
        'nom_ets' => ['required'],
        'nom_resp' => ['required'],
        'tel' => ['required'],
        'region_id' => ['required'],
        'id_province' => ['required'],
        'id_ville' => ['required'],
        'origin_prospect' => ['required'],
        'section_id' => ['required'],
        'grille_id' => ['required']
      ]);
      $data = $request->all();
      $societe = new Societe();

      $societe->fl_sup = 'N';
      $societe->src_create = 'W';
      $societe->user_create_id = Auth::user()->id;

      
      $societe->categorie_id = request('section_id');
      $societe->fill($data);
    
      $societe->nom_ets = $request->nom_ets;
      $societe->tel = $request->tel;
      $societe->adresse = $request->nom_resp;
      $societe->id_pa_region= $request->region_id;
      $societe->id_pa_province=$request->id_province;
      $societe->id_pa_commune=$request->id_ville;
      $societe->id_pa_origin = $request->origin_prospect;
      $societe->pa_statut_soc_id = request('statut');
      $societe->pa_type_soc_id = $request->type;
      $societe->pa_nature_soc_id = $request->nature;
      $societe->description = $request->description;
      $societe->save();
      $journal = new journal();
      $journal->type = 2;
      $journal->user_id = Auth::user()->id;
      $journal->contenu = 'Creation de ' . $societe->nom_ets . '';
      $journal->datej = now();
      $journal->save();
      Session::flash('message', 'Enregistrement effectué avec succès');
      return redirect('/ets');
         }

    if (!empty(request('modifier'))) {
      $gerant = new gerant();
      $request->validate([
        'idets' => ['required'],
        'nom_ets' => ['required'],
        'nom_resp' => ['required'],
        'tel' => ['required'],
        'region_id' => ['required'],
        'id_province' => ['required'],
        'id_ville' => ['required'],
        'origin_prospect' => ['required'],
        'section_id' => ['required'],
        'grille_id' => ['required']
      ]);

      $data = $request->all();
      $societe = societe::where('id', $request->idets)->get();
      $getSociete = societe::find($request->idets);
      $getSociete->user_update_id = Auth::user()->id;


      $getSociete->fill($data);
      $getSociete->nom_ets = $request->nom_ets;
      $getSociete->tel = $request->tel;
      $getSociete->adresse = $request->nom_resp;
      $getSociete->id_pa_region= $request->region_id;
      $getSociete->id_pa_province=$request->id_province;
      $getSociete->id_pa_commune=$request->id_ville;
      $getSociete->id_pa_origin = $request->origin_prospect;
      $getSociete->pa_statut_soc_id = request('statut');
      $getSociete->pa_type_soc_id = $request->type;
      $getSociete->pa_nature_soc_id = $request->nature;
      $getSociete->description = $request->description;
      $getSociete->pa_statut_soc_id = $request->statut;
      $getSociete->pa_type_soc_id = $request->type;
      $getSociete->pa_nature_soc_id = $request->nature;
      $getSociete->description = $request->description;
      $getSociete->save();

      $journal = new journal();
      $journal->type = 3;
      $journal->user_id = Auth::user()->id;
      $journal->contenu = 'Modification de ' . $getSociete->nom_ets . '';
      $journal->datej = now();
      $journal->save();
      // dd($request);
      if ($request->detailsUpdEts) {
        return redirect()->route('rdv.showDetails', $getSociete->id)->with('message', 'Modiffication effectuée avec succès');
      } else {
        return redirect()->route('ets.index')->with('message', 'Modiffication effectuée avec succès');
      }


      if (Auth::user()->type == 'Facturation') {
        return redirect('/facturation');
      } else {
        return redirect()->back()->with('message', 'Modiffication effectué avec succès!');
      }
    }

    if (!empty(request('retour'))) {
      $users = User::select('id', 'name')->get();
      $lettre = new \App\Models\lettres();
      $ets = societe::where('fl_sup', 'N')->orderBy('id', 'DESC')->offset(0)->limit(50)->get();
      return view("pages/entreprises/ets", compact('ets', 'lettre', 'users'));
    }
  }
  public function update(Request $request)
  {
    $data = $request->all();
  }
  public function edit($idcat)
  {
    $taxe = taxe::find(1);
    $champ = explode('->', $taxe->champs);
    $ets = etablissement::find($idcat);
    //$taxe->lavaleur();
    $l = '';
    if (count($champ) == 1) {
      $champ1 = $champ[0];
      $l = $ets->$champ1;
    } elseif (count($champ) == 2) {
      $champ1 = $champ[0];
      $champ2 = $champ[1];
      $l = $ets->$champ1->$champ2;
    }
    $facture = facture::create([
      'entite' => 'etablissement',
      'numero' => $ets->idets,
      'montant' => $l * $taxe->valeur,
      'datefact' => now(),
      'statut' => 0,
      'users_id' => auth()->user()->id
    ]);
    $facture->taxe()->attach($taxe->id, array('montant' => $l * $taxe->valeur));
    return redirect('/ets');
  }

  public function show($idcat)
  {

  }
}