<?php

namespace app\Http\Controllers\equipes;

use App\Models\User;
use App\Models\equipes;
use App\Models\equipes_users;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Session;

class Equipe extends Controller
{
    public function __construct()
    {
       // $this->middleware('admin');
      
    }
    //
    public function index()
    {
        $lettre = new \App\Models\lettres();
        
        $equipes = DB::table('equipes')->where('fl_sup', 'N')->distinct()->get();

        return view('pages/equipes/equipe', compact('equipes', 'lettre'));
    }

    public function create()
    {
        dd("dans la fonction create");
        $equipes = new \App\Models\equipes();

        return view ('pages.equipes.equipe', compact('equipes'));
        
    }

    public function store(Request $request)
    {
        
        if(!empty(request('enregistrer'))) {

            $lettre = new \App\Models\lettres();

            $request->validate([
                'nom' => ['required'],
                'responsable_id' =>  ['required'],
            ]);

            $equipes = new \App\Models\equipes();

            $equipes->nom = request('nom');
            $equipes->user_id = request('responsable_id');

            $equipes->save();

            $equipeId = $equipes->equipe_id;

            $equipes_users = new \App\Models\equipes_users();
            $equipeF = equipes::where('equipe_id', $equipeId)->get();

            $equipes_users->equipe_id = $equipeId;
            $equipes_users->user_id = $equipes->user_id;
            $equipes_users->user_role = "Chef Equipe";

            $equipes_users->save();
            \Session::flash('message', 'Opération réussie..');
            return $this->index();
        }

        if (!empty(request('update'))) {
            // dd("modification");
            // dd($request);
            $request->validate([
                'equipe_id' => ['required'],
                'responsable_id' => ['required'],
            ]);

            $membreEquipe = DB::table('equipes_users')
                        ->where('equipe_id', request('equipe_id'))
                        ->where('fl_actif', 'O')
                        ->where('user_role', '=', 'Membre Simple')->get();

            $chefEquipes = DB::table('equipes_users')
                        ->where('equipe_id', request('equipe_id'))
                        ->where('user_role', '=', 'Chef Equipe')
                        ->where('fl_actif', 'O')
                        ->get();

            foreach($chefEquipes as $key => $chef) {

                if($chef->user_id == request('responsable_id')) {

                    \Session::flash('info', 'Cet utilisateur existe déjà.');
                    return $this->index();
                }
            }

            foreach($membreEquipe as $key => $memb) {

                if ($memb->user_id == request('responsable_id')) {

                    $updatedResp = equipes_users::where('equipe_id', request('equipe_id'))
                            ->where('user_id', request('responsable_id'))
                            ->update(['user_role' => 'Chef Equipe']);

                    $equipes = equipes::where('equipe_id', $request->equipe_id)
                            ->update(['user_id' => request('responsable_id'), 'nom' => request('nom')]);
                    foreach($chefEquipes as $key => $chef) {
                        $update = DB::table('equipes_users')
                            ->where('user_id', $chef->user_id)
                            ->update(['user_role' => 'Membre Simple']);
                    }
                    return $this->index();
                }
            }

            
            $equipes_users = new \App\Models\equipes_users();
            $equipeF = equipes::where('equipe_id', request('equipe_id'))->get();

            $equipes_users->equipe_id = request('equipe_id');
            $equipes_users->user_id = request('responsable_id');
            $equipes_users->user_role = "Chef Equipe";
            $equipes_users->save();

            $updatedResp = equipes_users::where('equipe_id', request('equipe_id'))
                        ->where('user_id', request('responsable_id'))
                        ->update(['user_role' => 'Chef Equipe']);

            $equipes = equipes::where('equipe_id', $request->equipe_id)
                        ->update(['user_id' => request('responsable_id'), 'nom' => request('nom')]);
            foreach($chefEquipes as $key => $chef) {
                $update = DB::table('equipes_users')
                        ->where('user_id', $chef->user_id)
                        ->update(['user_role' => 'Membre Simple']);
            }
            return $this->index();
        }

        if(!empty(request('affecter'))) {
            $lettre = new \App\Models\lettres();

            $request->validate([
                'equipe_id' => ['required'],
                'responsable_id' =>  ['required']
            ]);

            $equipes_users = new \App\Models\equipes_users();
            $equipeF = equipes::where('equipe_id', request('equipe_id'))->get();
            

            $equipes_users->equipe_id = request('equipe_id');
            $equipes_users->user_id = request('responsable_id');

            $equipeUser = DB::table('equipes_users')->where('fl_actif', 'O')
                ->where('user_id', request('responsable_id'))
                ->where('equipe_id', request('equipe_id'))->get();
            foreach($equipeUser as $key => $user) {
                if ($user->user_id == request('responsable_id')) {
                    \Session::flash('info', 'Cet utilisateur existe déjà.');
                    return $this->index();
                }     
            }
            $equipes_users->save();
            \Session::flash('message', 'Opération réussie.');
            return $this->index();
        }

        if(!empty(request('retour'))) {
            return $this->index();
        }

        if (!empty(request('retirerUtilisateur'))) {
            dd($request);
            $equipeUsers = DB::table('equipes_users')->where('equipe_id', request('equipe_id'))->update(['fl_actif' => 'N']);
            return redirect()->back();
        }
        
    }

    public function edit(Equipes $equipe)
    {
        $users = User::all();
        return view('equipes.edit', compact('equipe', 'users'));
    }

    public function show(equipes $equipe)
    {
        $equipes = DB::table('equipes')->where('equipe_id', $equipe->equipe_id)->get();
        return view("pages.equipes.detailsequipes", compact('equipes'));
    }

    public function utilisateurs($id)
    {
        
        $utilisateurs = [];

        $equipesUsers = DB::table('equipes_users')->where('fl_actif', 'O')->get();

        foreach($equipesUsers as $key => $value) {
            if ($value->equipe_id == $id) {
                $user = new \App\Models\User();

                $user->id = $value->user_id;
                $user->name = \App\Models\User::where('id', $value->user_id)->value('name');
                $user->signature = $value->user_role;
                $utilisateurs[] = $user;
            }
        }

        // dd($utilisateurs);       
        return view('pages.equipes.utilisateurs', compact('utilisateurs'));
    }


    public function retirer($id) {
        // dd("suppression d'un utisateur");
        $dateFin = now()->format('Y-m-d H:i:s');
        $chef = DB::table('equipes_users')->where('user_id', $id)->get();
        // dd($chef[0]->user_role);
        if($chef[0]->user_role == 'Chef Equipe') {

            \Session::flash('info', "Impossible de supprimé le chef d'équipe. Veuillez définir un nouveau chef avant d'effectuer l'opération.");
            return $this->index();
        }
        $equipeUsers = DB::table('equipes_users')->where('user_id', $id)->update(['fl_actif' => 'N', 'date_fin' => $dateFin]);
        return redirect()->back();
    }

    public function delete() {
        $equipe = DB::table('equipes')->where('equipe_id', request('equipe_id'))->update(['fl_sup' => 'O']);
        Session::flash('success', 'Opération reussie!');
        return redirect()->back()->with("suppression reussi!");
    }
}
