<?php

namespace App\Http\Controllers\facturation;

use Carbon\Carbon;
use App\Models\taxe;
use App\Models\facture;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use App\Models\identification\societe;
use Illuminate\Support\Facades\Session;
use App\Models\identification\etablissement;

class Facturation extends Controller
{
  public function __construct()
  {
    $this->middleware('facturation');
  }

  public function index()
  {
    $ets = societe::orderBy('nom_ets')->where('fl_sup', 'N')->offset(0)->limit(35)->get();
    $annee = Carbon::now()->format('Y');
    return view('pages.facturation.facturation', compact('ets','annee'));
  }

  public function create(Request $request)
  {
  }
  public function store(Request $request)
  {
    $condition = array();
    $cond = 'form_jurid';


    if (!empty(request('facturer'))) {

      $mnt = request('montant');
      $request->validate([
        'idets' => ['required'],
        'annee' => ['required'],
      ]);

      $message = "Notification Réussie";
      $factAvcPmnt = 0;
      foreach ($request->idets as $value) {
        $ets = societe::where('fl_sup', 'N')->find($value);
        if (!$ets->factures->sum('montantpaie') > 0) {
          if (request('user_id'))
            self::facturer($ets, $request->annee, request('user_id'));
          else
            self::facturer($ets, $request->annee);
        } else {
          $factAvcPmnt++;
        }
      }
      if ($factAvcPmnt > 0)
        $message = $factAvcPmnt . ' société(s) avec déjà paiements';

      Session::flash('message', $message);
      return redirect()->route('facturation.index');
    }
    if (!empty(request('remiser'))) {
      $request->validate([
        'idets' => ['required'],
      ]);
      $ets = etablissement::find(request('idets'))->first();

      return view('pages.createts', compact('ets'));
    }

    if (!empty(request('visualiser'))) {
      $factures = facture::find(request('idets'));
      $lettre = new \App\Models\lettres();
      return view('facture', compact('factures', 'lettre'));
      // return redirect()->back();
    }
    if (!empty(request('modifier'))) {
      $request->validate([
        'idets' => ['required'],
      ]);
      $ets = etablissement::find(request('idets'))->first();

      return view('pages.createts', compact('ets'));
    }
  }

  public function facturer($ets, $annee, $user_id = null)
  {

    $lafacture = $ets->factures->where('facture', $ets->id . '' . $annee);
    if (!empty($lafacture[0])) {
      if ($lafacture[0]->statut == 0 and (date("Y") <= $annee)) {
        $lafacture[0]->montant = $ets->categorie->montant;
        #$ets->montant_negoc_soc=$lafacture[0]->montant_negoc;
        $ets->updated_at = now();
        $ets->save();
        $lafacture[0]->save();
      }
    } else {
      $facture = facture::updateOrCreate(
        [
          'facture' => $ets->id . '' . $annee
        ],
        [
          'entite' => 'etablissement',
          'societe_id' => $ets->id,
          'montant' =>  $ets->montant_negoc_soc == 0 ? $ets->categorie->montant : $ets->montant_negoc_soc,
          'statut' => 0,
          'montantpaie' => 0,
          'annee' => $annee,
          'montant_negoc' => 0,
          'users_id' => $user_id != null ? $user_id : Auth::user()->id,
          'users_up' => Auth::user()->id
        ]
      );

      if ($facture->wasRecentlyCreated) {
        $facture->datefact = now();
        $facture->idFacture = $facture->id;
        $facture->save();
      }
    }
  }

  public function edit($idcat)
  {
  }
  public function show($idcat)
  {
  }
  public function update(Request $request)
  {
  }
}
