<?php

namespace App\Http\Controllers\facturation;

use Carbon\Carbon;
use App\Models\facture;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use App\Models\identification\societe;
use Illuminate\Support\Facades\Session;
use App\Http\Controllers\facturation\Facturation;
use App\Http\Controllers\recouvrement\facturation\Facture as FacturationFacture;
use Illuminate\Support\Facades\Auth;

class FacturationSearchAndActions extends Controller
{

    public function __construct()
    {
        $this->middleware('facturation');
    }

    public function search()
    {
        
        $condition = array();
        $lettre = new \App\Models\lettres();
        if (request('grille_id')) {
            $condition['grille_id'] = request('grille_id');
        }
        if (!empty(request('arrondissement_id'))) {
            $condition['societe.arrondissement_id'] = request('arrondissement_id');
        }
        if (!empty(request('voie_id'))) {
            $condition['id_adr_voie'] = request('voie_id');
        }

        if (!empty(request('nom_ets'))) {

            $ets_arg = 'LIKE';
            $ets_sai = '%' . request('nom_ets') . '%';
        } else {
            $ets_arg = '<>';
            $ets_sai = '';
        }
        if (!empty(request('adresse'))) {
            $adr_arg = 'LIKE';
            $adr_sai = '%' . request('adresse') . '%';
        } else {
            $adr_arg = '<>';
            $adr_sai = '';
        }

        if (
            empty(request('arrondissement_id')) and empty(request('grille_id')) and empty(request('nom_ets')) and empty(request('adresse'))
            and empty(request('voie_id')) and empty(request('dateCreateAt'))
        ) {
            Session::flash('erreur', 'Veuillez renseigner les champs!');
            $ets = [];
            return view("pages.facturation.facturation", compact('ets', 'lettre'));;
        } else {
            $ets = societe::where($condition)
                ->where('societe.nom_ets', $ets_arg, $ets_sai)
                ->where('societe.adresse', $adr_arg, $adr_sai)
                ->where('societe.fl_sup', 'N')
                ->where(function ($query) {
                if (request('date-creat-D') && request('date-creat-F')) {
                    $query->whereBetween('societe.created_at', [request('date-creat-D'), request('date-creat-F')]);
                } elseif (request('date-creat-D') && empty(request('date-creat-F')))
                $query->whereDate('societe.created_at', request('date-creat-D'));

                    return $query;
                })

                ->offset(0)->limit(50)->get();
                $annee = Carbon::now()->format('Y');
            return view('pages.facturation.facturation', compact('ets', 'lettre','annee'));
        }
    }

    public function searchAndGenerateNotification(Request $request)
    {
       
        $annee = Carbon::now()->year;
        $soc = new societe();

        $query = $soc->query();
        if ($request->mobile) {
            $query->where('societe.src_create', $request->mobile);
        }

        if ($request->ard_id) {
            $query->where('societe.arrondissement_id', $request->ard_id);
        }
        if ($request->nom_ets) {
            $query->where('nom_ets', 'LIKE', '%' . $request->nom_ets . '%');
        }

        if ($request->grille_id) {
            $query->where('grille_id', $request->grille_id);
        }

        if ($request->adr) {
            $query->where('adresse', $request->adr);
        }

        if ($request->voie_id) {
            $query->where('societe.id_adr_voie', $request->voie_id);
        }

        
        if (request('date-creat-D') && request('date-creat-F')) {
            $query->whereBetween('societe.created_at', [request('date-creat-D'), request('date-creat-F')]);
        } elseif (request('date-creat-D') && empty(request('date-creat-F')))
        $query->whereDate('societe.created_at', request('date-creat-D'));

       

        //Il s'agit ici de faire un left join de societe avec  les facture de l'année en cours  
        $query->leftJoin('factures', function ($join) use ($annee) {
            $join->on('factures.societe_id', '=', 'societe.id')
                ->where('factures.annee', '=', $annee);
        });
        
        if (request('dateD') && request('dateF')) {
            $query->whereBetween('factures.date_notif', [request('dateD'), request('dateF')]);
        } elseif (request('dateD') && empty(request('dateF')))
        $query->whereDate('factures.date_notif', request('dateD'));

        $query->leftJoin('paiement', function ($join) {
            $join->on('paiement.facture_id', '=', 'factures.id');
        })
            ->select(DB::raw("societe.*, factures.id as fact_id"))

            // pour garder les lignes avec des factures sans paiements😎😎  
            ->where('paiement.id_paie', '=', null);


        $results = $query->get();
        $var = 0;
        $user_id = request('user_id') != null ? request('user_id') : null;
        foreach ($results as $value) {

            $fact = new Facturation();
            $fact->facturer($value, $annee, $user_id);
            $var += 1;
        }
        if ($var >= 1) {
            Session::flash('message', "$var.' Facturation(s) effectuée(s)'");
            return redirect()->route('facturation.index');
        } else {
            Session::flash('message', 'Aucune facturation à effectuer');
            return redirect()->route('facturation.index');
        }
    }

    
}
