<?php

namespace App\Http\Controllers\facturation;

use App\Models\journal;
use Illuminate\Http\Request;
use App\Models\facture as fact;
use Barryvdh\DomPDF\Facade\Pdf;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use App\Models\identification\societe;
use Illuminate\Support\Facades\Session;

class Facture extends Controller
{

  public function index()
  {
    $query = fact::join('societe as s', 'factures.societe_id', '=', 's.id')
      ->select('factures.*', 's.id as societe_id')
      ->where('s.fl_sup', 'N');

    if (!(Auth::user()->type == 'admin_fonctionnel' or Auth::user()->type == 'admin_technique' or Auth::user()->type == 'Facturation' or Auth::user()->type == 'caisse'))
      $query->where('users_id', Auth::user()->id);

    $facture = $query->offset(0)->limit(35)->get();

    return view('pages.facturation.facture', compact('facture'));
  }

  public function store(Request $request)
  {
    $condition = array();
    $cond = 'form_jurid';

    if (!empty(request('chercher'))) {

      
      $lettre = new \App\Models\lettres();
      if (!empty(request('voie_id'))) {
        $condition['s.id_adr_voie'] = request('voie_id');
      }
      if (!empty(request('arrondissement_id'))) {
        $condition['s.arrondissement_id'] = request('arrondissement_id');
      }
      if (!empty(request('user_id'))) {
        $condition['factures.users_id'] = request('user_id');
      }

      if (!empty(request('nom_ets'))) {
        $ets_dtb = 's.nom_ets';
        $ets_arg = 'LIKE';
        $ets_sai = '%' . request('nom_ets') . '%';
      } else {
        $ets_dtb = 's.nom_ets';
        $ets_arg = '<>';
        $ets_sai = '';
      }
      if (!empty(request('adresse'))) {
        $adr_dtb = 's.adresse';
        $adr_arg = 'LIKE';
        $adr_sai = '%' . request('adresse') . '%';
      } else {
        $adr_dtb = 's.adresse';
        $adr_arg = '<>';
        $adr_sai = '';
      }



      if (empty(request('arrondissement_id')) and empty(request('voie_id')) and empty(request('nom_ets')) and empty(request('adresse')) and (empty(request('dateD')) || empty(request('dateF'))) and empty(request('user_id')) and empty(request('etat'))) {

        Session::flash('erreur', 'Veuillez renseigner les champs!');
        $facture = [];
        return view("pages.facturation.facture", compact('facture', 'lettre'));
      }
      if (
        Auth::user()->type == 'admin_fonctionnel' or Auth::user()->type == 'admin_technique' or Auth::user()->type == 'Facturation'
        or Auth::user()->type == 'caisse'
      ) {

        $facture = fact::join('societe as s', 'factures.societe_id', '=', 's.id')->join('users', 'factures.users_id', '=', 'users.id')
        ->where($condition)->where($ets_dtb, $ets_arg, $ets_sai)->where('s.fl_sup', 'N')
        ->where($adr_dtb, $adr_arg, $adr_sai)
        ->where(function ($query) {
          if (request('dateD') != "" and request('dateF') != "") {
            $query->whereBetween('date_notif', [request('dateD'), request('dateF')]);
          }
          if (request('date-creat-D') && request('date-creat-F')) {
            $query->whereBetween('s.created_at', [request('date-creat-D'), request('date-creat-F')]);
          } elseif (request('date-creat-D') && empty(request('date-creat-F')))
          $query->whereDate('s.created_at', request('date-creat-D'));
          return $query;
        })
          ->offset(0)->limit(50)->get();
      } else {

        $facture = fact::join('societe as s', 'factures.societe_id', '=', 's.id')
          ->where($condition)->where($ets_dtb, $ets_arg, $ets_sai)
          ->where('factures.users_id', Auth::user()->id)
          ->where('s.fl_sup', 'N')
          ->where(function ($query) {
            if (request('dateD') != "" and request('dateF') != "") {
              $query->whereBetween('date_notif', [request('dateD'), request('dateF')]);
            }
            if (request('dateCreateAt')) {
              $query->whereDate('s.created_at', request('dateCreateAt'));
            }
            return $query;
          })
          ->where($adr_dtb, $adr_arg, $adr_sai)->offset(0)->limit(50)->get();
      }
      return view("pages.facturation.facture", compact('facture', 'lettre'));
    }

    if (!empty(request('visualiser'))) {
      $request->validate([
        'id' => ['required'],
      ]);
      $factures = fact::find(request('id'));
      if ($factures) {
        $lettre = new \App\Models\lettres();
        $facts = $factures;
        $pdf = PDF::loadView('print/NotificationModel', compact('facts', 'lettre'));
        return $pdf->stream();
      } else {
        Session::flash('info', 'Données Vides!!');
        return redirect()->back();
      }
    }


    if (!empty(request('remiser'))) {
      $request->validate([
        'id' => ['required'],
        'montant' => ['required'],
        'motif' => ['required']
      ]);
      $factures = fact::find(request('id'));
      $ets = societe::where('societe.id', '=', $factures[0]->societe_id)->get();
      foreach ($factures as $key => $facture) {

        if ($facture->statut == 0) {
          $facture->users_up = Auth::user()->id;
          $facture->updated_at = now();
          $facture->montant_negoc = request('montant');
          $facture->save();
          $journal = new journal();
          $journal->type = 4;
          $journal->user_id = Auth::user()->id;
          $journal->contenu = 'Remise de la Facture Nº' . $facture->id . ' de la somme de ' . $facture->montant_negoc . 'Francs CFA';
          $journal->datej = now();
          $journal->save();
          $ets[0]->montant_negoc_soc = request('montant');
          $ets[0]->save();
        }
      }
      if ($factures[0]->statut != 0) {
        Session::flash('warning', "Impossible d'accorder une remise sur une facture en cours de paiement ou déjà payé.");
        return redirect()->back();
      } else {
        Session::flash('message', 'Remise accordée avec Succès ');
        $lettre = new \App\Models\lettres();
        $pdf = PDF::loadView('print/NotificationModel', compact('factures', 'lettre'));
        return $pdf->stream();
      }
    }

    if (!empty(request('transferer'))) {
      $request->validate([
        'id' => ['required'],
      ]);

      $factures = fact::find(request('id'));
      foreach ($factures as $facture) {
        $facture->users_id = request('user_id');
        $facture->save();
      }
      return redirect()->back();
    }
    if (!empty(request('annuler'))) {
      $request->validate([
        'id' => ['required'],
      ]);

      $factures = fact::find(request('id'));
      foreach ($factures as $facture) {
        if ($facture->statut == 0) {
          $facture->delete();;
          $journal = new journal();
          $journal->type = 4;
          $journal->user_id = Auth::user()->id;
          $journal->contenu = 'Annulation de la Facture' . $facture->id . '';
          $journal->datej = now();
          $journal->save();
        }
      }
      return redirect()->back();
    }
    if (!empty(request('signer'))) {

      $factures = fact::find(request('id'));
      foreach ($factures as $key => $value) {
        $value->statut = 1;
        $value->idsign = Auth::user()->id;
        $value->save();
      }
      Session::flash('message', 'Facture Signé avec Succès ');
      return redirect()->back();
    }
    if (!empty(request('facture'))) {
    }
  }

  public function edit($idcat)
  {
  }
  public function show($idcat)
  {
  }
  public function update(array $idcat)
  {
  }
  public function create(Request $request)
  {
  }
}
