<?php

namespace App\Http\Controllers\facturation;

use Illuminate\Http\Request;
use App\Models\facture as fact;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Session;


class FactureAffectation extends Controller
{
  public function __construct()
  {
    $this->middleware('facturation');
  }

  public function searchAffect(Request $request)
  {

    $fac = new fact();
    $query = $fac->query();

    if ($request->arrondissement_id) {
      $query->whereHas('societe', function ($query) use ($request) {
        $query->where('arrondissement_id', $request->arrondissement_id);
      });
    }

    if ($request->voie_id) {
      $query->whereHas('societe', function ($query) use ($request) {
        $query->where('id_adr_voie', $request->voie_id);
      });
    }

    /*if ($request->etat >= 0 && $request->etat != null) {
      $query->where('statut', $request->etat);
    }*/

    if ($request->nom_ets) {
      $query->whereHas('societe', function ($query) use ($request) {
        $query->where('nom_ets', 'LIKE', '%' . $request->nom_ets . '%');
      });
    }

    if ($request->adresse) {
      $query->whereHas('societe', function ($query) use ($request) {
        $query->where('adresse',  'LIKE', '%' . $request->adresse . '%');
      });
    }
    $query->whereHas('societe', function ($query) use ($request) {
      $query->where('fl_sup', 'N');
    });

    if (request('date-creat-D') && request('date-creat-F')) {
      $query->whereHas('societe', function ($query) use ($request) {
        $query->whereBetween('created_at', [request('date-creat-D'), request('date-creat-F')]);
      });
    } elseif (request('date-creat-D') && empty(request('date-creat-F'))){
      $query->whereHas('societe', function ($query) use ($request) {
        $query->whereDate('created_at', request('date-creat-D'));
      });
    }
    

    $results = $query->get();
    $box = 0;
    if (request('user_id')) {
      foreach ($results as $value) {
        /** @var fact $value */
        $value->users_id = request('user_id');
        $value->save();
        $box += 1;
      }

      if ($box >= 1) {
        Session::flash('message', 'Facture(s) affectée(s) ');
        return redirect()->back();
      } else {
        Session::flash('message', 'Pas de facture(s) à affecter ');
        return redirect()->back();
      }
    } else {
      Session::flash('message', 'Pas d\'agent selectionné !! ');
      return redirect()->back();
    }
  }
}
