<?php

namespace App\Http\Controllers\facturation;

use Illuminate\Http\Request;
use Illuminate\Support\Carbon;
use App\Models\facture as fact;
use Barryvdh\DomPDF\Facade\Pdf;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Storage;


class FacturePrint extends Controller
{

    public function visualiser(Request $request)
    {
        $request->validate([
            'ids' => ['required'],
        ]);
        $factures = fact::find(request('ids'));

        if (count($factures) != 0) {
            $lettre = new \App\Models\lettres();
            $facts = $factures;
            $pdf = PDF::loadView('print/NotificationModel', compact('facts', 'lettre'));
            return $pdf->stream();
        } else {
            Session::flash('info', 'Données Vides!!');
            return redirect()->back();
        }
    }

    public function visuImprim()
    {

        if (!(empty(request('grille_id')) and empty(request('arrondissement_id')) and empty(request('user_id')) and empty(request('etat')) and empty(request('nom_ets')) and empty(request('adresse')))) {
            $lettre = new \App\Models\lettres();
            $factures = array();
            $condition['societe.fl_sup'] = 'N';
            if (!empty(request('etat'))) {
                $condition['factures.statut'] = request('etat');
            }
            if (!empty(request('arrondissement_id'))) {
                $condition['societe.arrondissement_id'] = request('arrondissement_id');
            }

            if (
                Auth::user()->type == 'admin_fonctionnel' || Auth::user()->type == 'admin_technique' ||
                Auth::user()->type == 'Facturation' || Auth::user()->type == 'caisse'
            ) {
                if (!empty(request('user_id'))) {
                    $condition['factures.users_id'] = request('user_id');
                }
            } else {
                $condition['factures.users_id'] = Auth::user()->id;
            }


            $query = fact::join('societe', 'factures.societe_id', '=', 'societe.id')
                ->join('users', 'factures.users_id', '=', 'users.id')
                ->where($condition);
            if (!empty(request('nom_ets'))) {
                $query->where('societe.nom_ets', 'LIKE', '%' . request('nom_ets') . '%');
            }
            if (!empty(request('adresse'))) {
                $query->where('societe.adresse', 'LIKE', '%' . request('adresse') . '%');
            }
            if (request('date-creat-D') && request('date-creat-F')) {
                $query->whereBetween('societe.created_at', [request('date-creat-D'), request('date-creat-F')]);
            } elseif (request('date-creat-D') && empty(request('date-creat-F')))
            $query->whereDate('societe.created_at', request('date-creat-D'));

            $factures = $query->get();


            if (count($factures) != 0) {

                $fichiers = self::multiPrint($factures, 'print/NotificationModel', "un");
                return redirect()->back()->with('fichiers', $fichiers);
            } else {
                Session::flash('info', 'Données Vides!!');
                return redirect()->back();
            }
        } else {
            Session::flash('info', 'Aucun critère de recherche!!');
            return redirect()->back();
        }
    }


    public function recapAgent()
    {
        $annee = Carbon::now()->year;

        $condition['s.fl_sup'] = 'N';
        if (!empty(request('voie_id'))) {
            $condition['s.id_adr_voie'] = request('voie_id');
        }
        if (!empty(request('arrondissement_id'))) {
            $condition['s.arrondissement_id'] = request('arrondissement_id');
        }
        if (request('etat') >= 0 && request('etat') != null) {
            $condition['factures.statut'] = request('etat');
        }

        if (!empty(request('nom_ets'))) {
            $ets_dtb = 's.nom_ets';
            $ets_arg = 'LIKE';
            $ets_sai = '%' . request('nom_ets') . '%';
        } else {
            $ets_dtb = 's.nom_ets';
            $ets_arg = '<>';
            $ets_sai = '';
        }
        if (!empty(request('adresse'))) {
            $adr_dtb = 's.adresse';
            $adr_arg = 'LIKE';
            $adr_sai = '%' . request('adresse') . '%';
        } else {
            $adr_dtb = 's.adresse';
            $adr_arg = '<>';
            $adr_sai = '';
        }

        $condition['factures.users_id'] = request('user_id');
        $fichiers = array();
        $factures = fact::join('societe as s', 'factures.societe_id', '=', 's.id')->join('users', 'factures.users_id', '=', 'users.id')
            ->where($condition)
            ->where($ets_dtb, $ets_arg, $ets_sai)
            ->where($adr_dtb, $adr_arg, $adr_sai)
            ->where('factures.annee', '=', $annee)
            ->where(function ($query) {
            if (request('date-creat-D') && request('date-creat-F')) {
                $query->whereBetween('s.created_at', [request('date-creat-D'), request('date-creat-F')]);
            } elseif (request('date-creat-D') && empty(request('date-creat-F')))
                $query->whereDate('s.created_at', request('date-creat-D'));
                return $query;
            })
            ->get();


        if ($factures->count() > 0) {
            $fichiers = self::multiPrint($factures, 'print/NotificationModelBasPerAgent', "un");

            return redirect()->back()->with('fichiers', $fichiers);
        } else {
            Session::flash('info', "Pas de données pour l'agent choisi!!");
            return redirect()->back();
        }
    }


    public function multiPrint($models, $templates, $per)
    {
        $lettre = new \App\Models\lettres();
        $per = $per;
        if ($models->count() != 0) {
            $files = scandir(storage_path('app/public/pdf'));
            foreach ($files as $file) {

                $filePath = storage_path('app/public/pdf/') . $file;

                if (is_file($filePath)) {
                    unlink($filePath);
                }
            }
            $memory_limit = ini_get('memory_limit');
            set_time_limit(0);
            ini_set('memory_limit', '-1');


            $fichiers = array();
            $sousTableaux = $models->chunk(200);

            foreach ($sousTableaux as $facts) {
                $pdf = PDF::loadView($templates, compact('facts', 'lettre', 'per'));
                $fileName = 'pdf_' . uniqid() . '.pdf';

                Storage::disk('public')->put("pdf/{$fileName}", $pdf->download()->getOriginalContent());

                // Storage::disk('pdf')->put($fileName,$pdf->download()->getOriginalContent(),'public');
                array_push($fichiers, $fileName);
            }
            set_time_limit(30);
            return $fichiers;
        }
    }
}
