<?php

namespace App\Http\Controllers;

use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Carbon;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;

class rdvStatController extends Controller
{

    public function index(Request $request)
    {


        if ($request->annee == '' && $request->mois == '' && $request->debut == '') {
            $annee = Carbon::now()->year;
            $mois = Carbon::now()->month;

            $datas = self::getDataPerYear($annee);
            $datasM = self::getDataPerMonth($annee, $mois);

            return view('statistiques.rendezvous', compact('datas', 'datasM', 'annee', 'mois'));
        }

        if ($request->annee != '' && $request->mois == '' && $request->debut == '') {

            $annee = $request->annee;

            $datas = self::getDataPerYear($annee);
            return response()->json($datas);
        }


        if ($request->annee != '' && $request->mois != '') {
            $annee = $request->annee;
            $mois = $request->mois;

            $datas = self::getDataPerMonth($annee, $mois);
            return response()->json($datas);
        }

        if ($request->annee != '' && ($request->debut != '' || $request->fin != '')) {
            $annee = $request->annee;
            $debut = $request->debut;
            $fin = $request->fin;


            $datas = self::getDataPerCustomPlage($annee, $debut, $fin);
            return response()->json($datas);
        }
    }

    function getDataPerYear($annee)
    {

        $datas = DB::table('rendezvous as rdv')
            ->select(
                'ard.libellea as ardNom',
                'u.name as usnom',
                DB::raw('count(rdv.id_rdv) as nombreRDV'),
                DB::raw('count(CASE WHEN rdv.pa_statut_rdv_id <> 1 AND rdv.pa_statut_rdv_id <> 2 then 1 end) as rdvNonEff'),
                DB::raw('count(case when rdv.pa_statut_rdv_id = 2 then 1 end) as rdvValide'),
                DB::raw('count(case when rdv.pa_statut_rdv_id = 1 then 1 end) as rdvAnnule'),
                DB::raw('count(CASE WHEN rdv.pa_statut_rdv_id <> 1 AND rdv.pa_statut_rdv_id <> 2 and now() > rdv.daterdv then 1 end) as rdvRtard'),
                DB::raw('year(rdv.datefais ) as annee')
            )
            ->join('users as u', 'u.id', '=', 'rdv.user_id')
            ->join('societe', function ($join) use ($annee) {
                $join->on('societe.id', '=', 'rdv.societe_id')
                    ->whereYear('rdv.datefais', '=', $annee);
            })
            ->rightJoin('arrondissement as ard', 'societe.arrondissement_id', '=', 'ard.id')
            ->where('societe.fl_sup', 'N')
            ->groupBy('ard.id', 'u.id')
            ->orderBy('ardNom', 'asc')
            ->get();
        return $datas;
    }

    function getDataPerMonth($annee, $mois)
    {

        $datas = DB::table('rendezvous as rdv')
            ->select(
                'ard.libellea as ardNom',
                'u.name as usnom',
                DB::raw('count(rdv.id_rdv) as nombreRDV'),
                DB::raw('count(CASE WHEN rdv.pa_statut_rdv_id <> 1 AND rdv.pa_statut_rdv_id <> 2 then 1 end) as rdvNonEff'),
                DB::raw('count(case when rdv.pa_statut_rdv_id =2 then 1 end) as rdvValide'),
                DB::raw('count(case when rdv.pa_statut_rdv_id =1 then 1 end) as rdvAnnule'),
                DB::raw('count(CASE WHEN rdv.pa_statut_rdv_id <> 1 AND rdv.pa_statut_rdv_id <> 2 and now() > rdv.daterdv then 1 end) as rdvRtard'),
                DB::raw('year(rdv.datefais ) as annee'),
                DB::raw('month(rdv.datefais ) as mois')
            )
            ->join('users as u', 'u.id', '=', 'rdv.user_id')
            ->join('societe', function ($join) use ($annee, $mois) {
                $join->on('societe.id', '=', 'rdv.societe_id')
                    ->whereYear('rdv.datefais', '=', $annee)
                    ->whereMonth('rdv.datefais', '=', $mois);
            })
            ->where('societe.fl_sup', 'N')
            ->rightJoin('arrondissement as ard', 'societe.arrondissement_id', '=', 'ard.id')
            ->groupBy('ard.id', 'u.id')
            ->orderBy('ardNom', 'asc')
            ->get();
        return $datas;
    }

    function getDataPerCustomPlage($annee, $debut, $fin)
    {

        $datas = DB::table('rendezvous as rdv')
            ->select(
                'ard.libellea as ardNom',
                'u.name as usnom',
                DB::raw('count(rdv.id_rdv) as nombreRDV'),
                DB::raw('count(CASE WHEN rdv.pa_statut_rdv_id <> 1 AND rdv.pa_statut_rdv_id <> 2 then 1 end) as rdvNonEff'),
                DB::raw('count(case when rdv.pa_statut_rdv_id =2 then 1 end) as rdvValide'),
                DB::raw('count(case when rdv.pa_statut_rdv_id =1 then 1 end) as rdvAnnule'),
                DB::raw('count(CASE WHEN rdv.pa_statut_rdv_id <> 1 AND rdv.pa_statut_rdv_id <> 2 and now() > rdv.daterdv then 1 end) as rdvRtard'),
                DB::raw('year(rdv.datefais ) as annee'),
                DB::raw('month(rdv.datefais ) as mois')
            )
            ->join('users as u', 'u.id', '=', 'rdv.user_id')
            ->join('societe', function ($join) use ($annee, $debut, $fin) {
                $join->on('societe.id', '=', 'rdv.societe_id')
                    ->whereYear('rdv.datefais', '=', $annee)
                    ->whereBetween('rdv.datefais', [$debut, $fin]);
            })
            ->where('societe.fl_sup', 'N')
            ->rightJoin('arrondissement as ard', 'societe.arrondissement_id', '=', 'ard.id')
            ->groupBy('ard.id', 'u.id')
            ->orderBy('ardNom', 'asc')
            ->get();

        return $datas;
    }

    function showAppointementPerType()
    {
        $agent = User::select(['id', 'name'])->orderBy('name')->get();
        $sql = DB::table('rendezvous as rdv')
        ->select(
            'soc.id',
            'u.id',
            'u.name',
            'rdv.id_rdv',
            'soc.nom_ets',
            'soc.tel',
            'ard.libellea',
            DB::raw('count(rdv.id_rdv) as nombre'),
            DB::raw('count(CASE WHEN pa_motf_rdv_id = 4 THEN 1 END) as nb_appel'),
            DB::raw('count(CASE WHEN pa_motf_rdv_id = 5 THEN 1 END) as nb_physique'),
            DB::raw('count(CASE WHEN pa_motf_rdv_id = 6 THEN 1 END) as nb_Ndecroche'),
            DB::raw('count(CASE WHEN pa_motf_rdv_id = 24 THEN 1 END) as nb_interessee'),
            DB::raw('count(CASE WHEN pa_motf_rdv_id = 25 THEN 1 END) as nb_Ninteresse'),
            DB::raw('count(CASE WHEN pa_motf_rdv_id = 26 THEN 1 END) as nb_programme'),
            DB::raw('count(CASE WHEN pa_motf_rdv_id = 27 THEN 1 END) as nb_maj'),
            DB::raw('count(CASE WHEN pa_motf_rdv_id = 28 THEN 1 END) as nb_alc'),
           
        )
        ->rightJoin('societe as soc', 'rdv.societe_id', '=', 'soc.id')
        ->rightJoin('arrondissement as ard', 'soc.arrondissement_id', '=', 'ard.id')
        ->rightJoin('users as u','rdv.user_id','=','u.id')
        ->groupBy('ard.id')
        ->orderBy('ard.libellea')
        ->limit(20)
        ->get();
        return view('pages.rendezvous.rdvAgendaStatistique',compact('sql','agent'));
    }

    function ResearchOnAppointementStatistics(Request $request){
        $agent = User::select(['id', 'name'])->orderBy('name')->get();
        $sql = DB::table('rendezvous as rdv')
        ->select(
            'soc.id',
            'u.id',
            'u.name',
            'rdv.id_rdv',
            'soc.nom_ets',
            'soc.tel',
            'ard.libellea',
            DB::raw('count(rdv.id_rdv) as nombre'),
            DB::raw('count(CASE WHEN pa_motf_rdv_id = 4 THEN 1 END) as nb_appel'),
            DB::raw('count(CASE WHEN pa_motf_rdv_id = 5 THEN 1 END) as nb_physique'),
            DB::raw('count(CASE WHEN pa_motf_rdv_id = 6 THEN 1 END) as nb_Ndecroche'),
            DB::raw('count(CASE WHEN pa_motf_rdv_id = 24 THEN 1 END) as nb_interessee'),
            DB::raw('count(CASE WHEN pa_motf_rdv_id = 25 THEN 1 END) as nb_Ninteresse'),
            DB::raw('count(CASE WHEN pa_motf_rdv_id = 26 THEN 1 END) as nb_programme'),
            DB::raw('count(CASE WHEN pa_motf_rdv_id = 27 THEN 1 END) as nb_maj'),
            DB::raw('count(CASE WHEN pa_motf_rdv_id = 28 THEN 1 END) as nb_alc'),
           
        )
        ->rightJoin('societe as soc', 'rdv.societe_id', '=', 'soc.id')
        ->rightJoin('arrondissement as ard', 'soc.arrondissement_id', '=', 'ard.id')
        ->rightJoin('users as u','rdv.user_id','=','u.id');

        if(!empty($request->agent)){
            $sql->where('user_id',$request->agent)
            ->orWhereNotNull('user_fai_rdv_id',);
        }
        if (!empty($request->arrondissement_id)) {
            $sql->where('soc.arrondissement_id',$request->arrondissement_id);
        } 
        if ($request->date_deb) {
            $sql->whereDate('daterdv','>=',$request->date_deb);
        }
        if ($request->date_fin) {
            $sql->whereDate('daterdv','<=',$request->date_fin);
        }

        $sql = $sql
        ->groupBy('ard.id')
        ->orderBy('ard.libellea')
        ->get();
        return view('pages.rendezvous.rdvAgendaStatistique',compact('sql','agent'));
    }
}
