<?php

namespace App\Http\Controllers\recouvrement;

use App\Models\facture;
use App\Models\journal;
use App\Models\paiement;
use App\Models\rendezvous;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use App\Models\identification\societe;
use Illuminate\Support\Facades\Session;
use App\Models\identification\societe as IdentificationSociete;

class Caisse extends Controller
{
  public function __construct()
  {
    $this->middleware('caisse');
  }

  public function index()
  {
    $query = facture::join('societe as s', 'societe_id', '=', 's.id')
      ->where('s.fl_sup', 'N');
    if (!(Auth::user()->type == 'admin_fonctionnel' or Auth::user()->type == 'admin_technique' or Auth::user()->type == 'Facturation' or Auth::user()->type == 'caisse'))
      $query->where('factures.users_id', Auth::user()->id);

    $ets = $query->groupby('nom_ets')->orderBy('nom_ets')->offset(0)->limit(35)->get();
    return view("pages.recouvrement.caisse", compact('ets'));
  }
  public function create(Request $request)
  {
  }

  public function store(Request $request)
  {

    if (!empty(request('paiement'))) {

      $request->validate([
        'idets' => ['required'],
      ]);
      $ets = societe::find(request('idets'));
      return view("paiement", compact('ets'));
    }

    if (!empty(request('geolocaliser'))) {
      $request->validate([
        'idets' => ['required'],
        'geoloc' => ['required'],
      ]);
      $societe = societe::find(request('idets'));
      $societe->geoloc = request('geoloc');
      $societe->save();
      Session::flash('message', 'Geolocalisation effectuée avec succès');
      return redirect()->back();
    }

    if (!empty(request('notifier'))) {
      $ets = facture::join('societe as s', 'societe_id', '=', 's.id')->where('s.fl_sup', 'N')
        ->groupby('nom_ets')->orderBy('nom_ets')->offset(0)->limit(20)->get();
      $request->validate([
        'facture_id' => ['required']
      ]);

      $facture = facture::find(request('facture_id'));
      if ($facture->user_id_notif != null and $facture->date_notif != null) {
        Session::flash('errors', 'Il existe déja une notification.');
        return redirect()->back();
      }
      $facture->user_id_notif = request('user_id_notif');
      $facture->date_notif = request('date_notif');
      // dd($facture);
      if (!empty($facture->user_id_notif && $facture->date_notif)) {
        $facture->save();
        Session::flash('success', 'Notification effectuée avec succès');
        return view('pages.recouvrement.caisse', compact('ets'));
      } else {
        Session::flash('errors', 'Echec de notification!');
        return redirect()->back();
      }
    }

    if (!empty(request('annulNotif'))) {
      $ets = facture::join('societe as s', 'societe_id', '=', 's.id')->where('s.fl_sup', 'N')
        ->groupby('nom_ets')->orderBy('nom_ets')->offset(0)->limit(20)->get();
      return view('pages.recouvrement.caisse', compact('ets'));
    }
  }


  public function show($idcat)
  {

    $rendezvous = rendezvous::find(request($idcat));

    if (!empty($idcat))
      return view("pages/rendezVousDetail");
    else {
      Session::flash('info', 'Auccun détail!!');
      return redirect()->back();
    }
  }
  public function update($idcat)
  {
    $paiement = paiement::find($idcat);
    $paiement->statut = 1;
    $paiement->save();
  }


  public function notifier(Request $request)
  {
    if (!empty(request('notifier'))) {
      $request->validate([
        'idets' => ['required'],
        'user_id_notif' => ['required']
      ]);

      $ets = IdentificationSociete::find(request('idets'));
      $factures = $ets->factures;

      if (count($factures) != 0)
        return view('pages.recouvrement.notifcaisse', compact('ets'));
      else {
        Session::flash('warning', 'Aucune facture disponible pour ' . request('nom_ets') . ' !!');
        return redirect()->back();
      }
    }
  }
}
