<?php

namespace App\Http\Controllers\recouvrement;

use App\Models\facture;
use App\Models\paiement;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Session;

class CaisseSearchAndActions extends Controller
{

    public function __construct()
    {
      $this->middleware('caisse');
    }

    public function search (Request $request) {
      
        $lettre = new \App\Models\lettres();
        
        $ets = facture:: join('societe as s', 'societe_id', '=', 's.id')
          ->where('s.fl_sup', 'N');
  
        if (empty(request('numero')) && empty(request('activite_id')) && empty(request('nom_ets')) && empty(request('adresse')) && empty(request('grille_id'))) {
          Session::flash('erreur', 'Veuillez renseigner les informations pour la recherche!');
          return redirect()->back();
        }
  
        if (!empty(request('numero'))) 
          $ets->where('s.arrondissement_id', request('numero'));
        
        if (!empty(request('activite_id'))) 
          $ets->where('s.activite_id', request('activite_id'));
        
        if (!empty(request('nom_ets'))) 
          $ets->where('s.nom_ets', 'LIKE','%'.request('nom_ets').'%');
        
        if (!empty(request('adresse'))) 
          $ets->where('s.adresse', 'LIKE', '%' . request('adresse') . '%');
        
        if (!empty(request('grille_id'))) 
          $ets->where('s.grille_id', request('grille_id'));

          if (!(Auth::user()->type == 'admin_fonctionnel' or Auth::user()->type == 'admin_technique' or Auth::user()->type == 'Facturation' or Auth::user()->type == 'caisse'))
          $ets->where('factures.users_id', Auth::user()->id);
    
        
        $ets = $ets->offset(0)->limit(40)->get();
  
        return view("pages.recouvrement.caisse", compact('ets', 'lettre'));
     }

      
}
