<?php

namespace App\Http\Controllers\recouvrement;

use App\Models\facture;
use App\Models\rendezvous;
use App\Models\Attestation;
use Illuminate\Http\Request;
use Barryvdh\DomPDF\Facade\Pdf;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Session;
use App\Models\paiement as ModelsPaiement;
use App\Models\identification\societe as IdentificationSociete;

class Paiement extends Controller
{

  public function index()
  {
    $paiements = (Auth::user()->type == 'admin_fonctionnel' or Auth::user()->type == 'admin_technique') ?
      ModelsPaiement::orderBy('created_at', 'DESC')->offset(0)->limit(100)->get() :
      ModelsPaiement::where('user_id', Auth::user()->id)->orderBy('created_at', 'DESC')->offset(0)->limit(100)->get();
    return view('pages.recouvrement.readPaiement', compact('paiements'));
  }

  public function store(Request $request)
  {

    $imageName = null;
    $imageNewName = null;
    if (!empty(request('valider'))) {
      $request->validate([
        'idets' => ['required'],
        'montant' => ['required'],
        'moyen' => ['required'],
        'image.*' => 'required|mimetypes:jpg,jpeg,bmp,png,csv,txt,xlx,xls,pdf',
      ]);
      $ets = IdentificationSociete::find(request('idets'));
      if ($request->hasFile('image')) {
        $imageName = $request->file('image')->getClientOriginalName();
        $image_path = $request->file('image')->store('image', 'public');
        $imageNewName = substr($image_path, 6);
      }
      
      if (empty(request('facture_id'))) {
        $facture = facture::create([
          'entite' => 'etablissement',
          'societe_id' => $ets->id,
          'montant' => request('montant'),
          'datefact' => now(),
          'annee' => date('Y'),
          'facture' => $ets->id . '' . date('Y'),
          'montantpaie' => 0,
          'statut' => 2,

          'users_id' => Auth::user()->id,
          'users_up' => Auth::user()->id
        ]);
        $paiement = ModelsPaiement::create([
          'entite' => $ets->form_jurid,
          'facture_id' => $facture->id,
          'montant' => request('montant'),
          'recu' => request('recu'),
          'societe_id' => $ets->id,
          'modalite' => request('modalite'),
          'moyen' => request('moyen'),
          'datepaie' => request('date') == null ? now() : request('date'),
          'agent_recouvr' => request('user_id') == null ? Auth::user()->id : request('user_id'),
          'statut' => 0,
          'lien_recu_manu' => $imageNewName,
          'user_id' => Auth::user()->id
        ]);
        $montantp = $facture->montantpaie + request('montant');
        $facture->statut = 2;
        $facture->montantpaie = $montantp;
        $lettre = new \App\Models\lettres();
        return view('pages.recouvrement.readPaiement', compact('paiements'));
      } else {
        $lafacture = facture::find(request('facture_id'));
        if ($lafacture->statut != 3) {
          $montantf = $lafacture->montant_negoc == 0 ? $lafacture->montant : $lafacture->montant_negoc;
          $montant = request('montant') > $montantf ? ($lafacture->montantpaie == 0 ? $montantf :
            $montantf - $lafacture->montantpaie) : ($lafacture->montantpaie + request('montant') <= $montantf ? request('montant') : $montantf - $lafacture->montantpaie);
          $montantfp = $lafacture->montantpaie + $montant;
          $montantp = $montantfp > $montantf ? $montantf : $montantfp;


          $paiement = ModelsPaiement::create([
            'entite' => 'etablissement',
            'facture_id' => $lafacture->id,
            'montant' =>  $montant,
            'recu' => request('recu'),
            'societe_id' => $ets->id,
            'modalite' => 'Avance',
            'moyen' => request('moyen'),
            'datepaie' => request('date') == null ? now() : request('date'),
            'agent_recouvr' => request('user_id'),
            'statut' => 0,
            'lien_recu_manu' =>   $imageNewName,
            'user_id' => Auth::user()->id
          ]);


          if ($montantp == $montantf) {
            $lafacture->statut = 3;
          } else {
            $lafacture->statut = 2;
          }

          $lafacture->montantpaie = $montantp;
          $lafacture->users_up = Auth::user()->id;
          $lafacture->updated_at = now();
          $lafacture->save();
          $paiements = $paiement;
          $paiement = ModelsPaiement::find($paiement->id_paie);
          $lettre = new \App\Models\lettres();
          Session::flash('sucess', 'Paiement effectué avec succès');
          return redirect(route('caisse.index'));
        } else {
          Session::flash('warning', 'Facture soldée !!');
          return redirect(route('caisse.index'));
        }
      }
    }

    if (!empty(request('annuler')))
      return redirect(route('caisse.index'));

    if (!empty(request('validerR'))) {
      $request->validate([
        'idets' => ['required'],
        'daterdv' => ['required'],
        'description' => ['required'],
        'type' => ['required']
      ]);
      $rendezvous = rendezvous::create([
        'societe_id' => request('idets'),
        'description' => request('description'),
        'type' => request('type'),
        'daterdv' => request('daterdv'),
        'datefais' => now(),
        'user_id' => Auth::user()->id
      ]);
      Session::flash('sucess', 'Enregistrement effectué avec succès');
      return redirect()->back();
    }

    if (!empty(request('imprimer'))) {
      $paiement = ModelsPaiement::find(request('id'));
      $lettre = new \App\Models\lettres();

      if ($paiement <> null and $paiement->first()->facture_id <> null) {
        $pdf = PDF::loadView('pages.recouvrement.recuCaisse', compact('paiement', 'lettre'));
        return $pdf->stream();
      } else {
        return redirect()->back();
      }
    } elseif (!empty(request('generer'))) {
      
      $paiements = ModelsPaiement::find(request('id'));
      if ($paiements != null) {
        $box=0;
        foreach ($paiements as $paiement) {
          
          if (empty($paiement->societe->attestation->first()->id)) {
            
            $attestaion = Attestation::create([
              'societe_id' => $paiement->societe->id,
              'type' => 'cotisation',
              'dates' => now(),
              'etat' => 0,
              'users_id' => Auth::user()->id
            ]);
          } $box++;
        }
        Session::flash('success', $box.' attestations generées avec succès!');
      } else Session::flash('info', 'Echec de génération!');
      return redirect('/paiement');
    }

    $condition = array();
    $cond = 'form_jurid';


    if (!empty(request('facture'))) {

      $factures = facture::where('annee', '=', request('annee'))->where('statut', '=', request('statut'))->get();

      return view('compta/facture', compact('factures'));
    }
    if (!empty(request('Retour'))) 
      return redirect(route('caisse.index'));
    
  }
  public function edit($idcat)
  {
    $lepaiement = ModelsPaiement::find($idcat);
    $lepaiement->statut = 1;
    $lepaiement->save();
    Session::flash('success', 'Validation effectuée avec succès');
    return redirect()->back();
  }
  public function show($idcat)
  {
    $ets = IdentificationSociete::find($idcat);
    $factures = $ets->Factures;
    if (count($factures) != 0)
      return view("pages.recouvrement.paiementDetail", compact('ets'));
    else {
      Session::flash('message', 'Auccun détail!!');
      return redirect()->back();
    }
  }
  
  public function editP(Request $request)
  {
    if (!empty(request('paiement'))) {

      $request->validate([
        'idets' => ['required'],
      ]);
      $ets = IdentificationSociete::find(request('idets'));
      $factures = $ets->factures;
      if (count($factures) != 0)
        return view("pages.recouvrement.makePaiement", compact('ets'));
      else {
        Session::flash('message', 'Auccune facture disponible pour ' . request('nom_ets') . ' !!');
        return redirect()->back();
      }
    }

    if (!empty(request('annuler'))) {
      $lepaiement = ModelsPaiement::find(request('id_paie'));
      $lepaiement->statut = 5;
      $facture = $lepaiement->facture;
      $facture->users_up = Auth::user()->id;
      $facture->updated_at = now();
      $facture->montantpaie = $facture->montantpaie - $lepaiement->montant;
      if ($facture->montantpaie == 0)
        $facture->statut = 0;
      else  $facture->statut = 2;
      $facture->save();
      $lepaiement->save();
      Session::flash('message', 'Annulation effectuée avec succès');
      return redirect()->back();
    }

    if (!empty(request('validerR'))) {
      $request->validate([
        'idets' => ['required'],
        'daterdv' => ['required'],
        'observation' => ['required'],
        'type' => ['required']
      ]);
      $rendezvous = rendezvous::create([
        'societe_id' => request('idets'),
        'observation' => request('observation'),
        'type' => request('type'),
        'daterdv' => request('daterdv'),
        'datefais' => now(),
        'user_id' => Auth::user()->id
      ]);
      Session::flash('success', 'Enregistrement effectué avec succès');
      return redirect()->back();
    }
    return redirect()->back();
  }
}
