<?php

namespace App\Http\Controllers\recouvrement;

use Carbon\Carbon;
use Illuminate\Http\Request;
use App\Exports\exportPaiement;
use Barryvdh\DomPDF\Facade\Pdf;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Maatwebsite\Excel\Facades\Excel;
use Illuminate\Support\Facades\Session;
use App\Models\paiement as ModelsPaiement;

class PaiementSearchAndActions extends Controller
{

  public $box;

  public function search(Request $request)
  {
    
    $lettre = new \App\Models\lettres();
    $paiements = self::searchProcess($request);

    if ($paiements == null) {
      $paiements =  [];
      Session::flash('info', 'Veuillez renseigner les champs!');
      return view('pages.recouvrement.readPaiement', compact('paiements', 'lettre'));
    } else
      return view('pages.recouvrement.readPaiement', compact('paiements', 'lettre'));
  }

  public function multiValidation(Request $request)
  {
    
    if (
      empty(request('date1')) || empty(request('date2')) and empty(request('nom_ets')) and empty(request('grille_id'))
      and empty(request('arrondissement_id')) and empty(request('user_id'))
    ) {

      Session::flash('info', 'Accun critère de recherche défini!');
      return redirect()->back();
    } else {

      $paiements = array();
      $condition = array();

      $condition['societe.fl_sup'] = 'N';
      if (!empty(request('arrondissement_id')))
        $condition['societe.arrondissement_id'] = request('arrondissement_id');

      $query = ModelsPaiement::join('societe', 'paiement.societe_id', '=', 'societe.id')
      ->where('paiement.statut','!=',1)->where($condition);
      if (request('date1') && request('date2'))
      $query->whereBetween('paiement.datepaie', [request('date1'), request('date2')]);
      if (request('grille_id'))
        $query->where('societe.grille_id', '=', request('grille_id'));
      if (request('user_id'))
        $query->where('paiement.user_id', '=', request('user_id'));
      if ($request->nom_ets)
        $query->where('societe.nom_ets', 'LIKE', '%' . $request->nom_ets . '%');
      if ($request->adresse)
        $query->where('societe.adresse', 'LIKE', '%' . $request->adresse . '%');


      $paiements = $query->get();


      if (count($paiements) != 0) {
        foreach ($paiements as $paiement) {
          $paiement->statut = 1;
          $paiement->save();
        }
        Session::flash('success', count($paiements) . ' Validation(s) effectuée(s) avec succès');
        return redirect('/paiement');
      } else {
        Session::flash('info', 'Accune donnée trouvée pour validation!');
        return redirect('/paiement');
      }
    }
  }

  public function dataExportation(Request $request)
  {

    if (request('dataExportation')) {
      $dateD = Carbon::createFromFormat('Y-m-d', request('date1'));
      $dateF = Carbon::createFromFormat('Y-m-d', request('date2'));

      if ($dateD->greaterThan($dateF)) {
        Session::flash('info', 'La date de début de la période est supérieure à la date de fin!');
        return redirect('/paiement');
      }

      $file = self::dataExportationProcess($request);

      if (request('fileType') == 'PDF' && $file != null) {
        return $file->stream();
      } elseif (request('fileType') == 'Excel' && $file == 1) {

        Session::flash("download", $this->box);
        Session::flash("success", "Fichier généré avec succès");
        return redirect("/paiement");
      } elseif ($file == null) {
        Session::flash('info', 'Pas de donnée pour cette période!');
        return redirect('/paiement');
      }
    } else if (request('dataExportationC')) {

      $periode = "";

      if (request('periode') == "Aujourd'hui")
        $periode = Carbon::today()->toDateString();
      elseif (request('periode') == "Hier")
        $periode = Carbon::today()->subDay()->toDateString();
      elseif (request('periode') == "Avant hier")
        $periode = Carbon::today()->subDays(2)->toDateString();


      $file = self::dataExportationProcess($request, null, $periode);

      if (request('fileType') == 'PDF' && $file != null) {
        return $file->stream();
      } elseif (request('fileType') == 'Excel' && $file == 1) {

        Session::flash("download", $this->box);
        Session::flash("success", "Fichier généré avec succès");
        return redirect("/paiement");
      } elseif ($file == null) {
        Session::flash('info', 'Pas de donnée pour ' . $request->periode . '!');
        return redirect('/paiement');
      }
    }
  }

  public function dataExportationProcess(Request $request, $typePaiement = null, $periode = null)
  {


    $dateD = $request->date1 ? Carbon::parse(Carbon::createFromFormat('Y-m-d', request('date1')))->format('d/m/Y') : null;
    $dateF = $request->date1 ? Carbon::parse(Carbon::createFromFormat('Y-m-d', request('date2')))->format('d/m/Y') : null;
    $Courant = $request->dataExportationC;

    set_time_limit(0);
    ini_set('memory_limit', '-1');

    $condition = array();
    if (!(Auth::user()->type == 'admin_fonctionnel' or Auth::user()->type == 'admin_technique' or Auth::user()->type == 'caisse'))
      $condition['user_id'] = Auth::user()->id;

    $paiements = ModelsPaiement::join('societe as s', 'societe_id', '=', 's.id')
      ->where('fl_sup', 'N')
      ->where($condition)
      ->when($typePaiement != null, function ($query) {
        return $query->where('statut', 1);
      })
      ->when(request('date1') != null && request('date2') != null, function ($query) {

        return $query->whereBetween('datepaie', [request('date1'), request('date2')]);
      })
      ->when($periode != null, function ($query) use ($periode) {

        return $query->whereDate('datepaie', $periode);
      })
      ->get();

    $montantTotal = $paiements->sum('montant');
    if ($paiements->count() == 0) {
      return null;
    } elseif (request('fileType') == 'PDF') {
      $pdf = PDF::loadView('print/templatePaiement', compact('paiements', 'dateD', 'dateF', 'periode', 'montantTotal', 'typePaiement', 'Courant'));
      set_time_limit(30);
      return $pdf;
    } elseif (request('fileType') == 'Excel') {

      $files = scandir(storage_path('app/public/excel'));
      foreach ($files as $file) {

        $filePath = storage_path('app/public/excel/') . $file;

        if (is_file($filePath)) {
          unlink($filePath);
        }
      }

      if($typePaiement==null){
      $this->box = 'paiements' . (request('date1') ? request('date1') : $periode) . (request('date2') ? 'to' . request('date2') : '') . '.xlsx';
        $filePath = 'public/excel/'.$this->box;
      }
      else{
      $this->box = 'recettes' . (request('date1') ? request('date1') : $periode) . (request('date2') ? 'to' . request('date2') : '') . '.xlsx';
        $filePath = 'public/excel/' . $this->box;
      }
     
       return Excel::store(new exportPaiement(
        request('date1') ? request('date1') : $periode,
        request('date2') ? request('date2') : null,
        $typePaiement,
        request('dataExportationC') ? true : null
      ), $filePath);
    }
  }

  public function searchProcess(Request $request, $statut = null)
  {
    $condition = array();

    if (!(Auth::user()->type == 'admin_fonctionnel' or Auth::user()->type == 'admin_technique' or Auth::user()->type == 'Facturation' or Auth::user()->type == 'caisse'))
      $condition['paiement.user_id'] = Auth::user()->id;
    if (request('grille_id'))
      $condition['s.grille_id'] = request('grille_id');
    if (request('activite_id'))
      $condition['s.activite_id'] = request('activite_id');
    if (request('numero'))
      $condition['s.arrondissement_id'] = request('numero');


    if (
      empty(request('numero')) and empty(request('grille_id')) and empty(request('date1'))
      and empty(request('date2')) and empty(request('nom_ets')) and empty(request('adresse')) and empty(request('annee'))
    ) return null;

    $query = ModelsPaiement::join('societe as s', 'societe_id', '=', 's.id')
      ->where($condition)->where('fl_sup', 'N');
    if ($statut != null)
      $query->where('paiement.statut', '=', $statut);
    if ($request->nom_ets)
      $query->where('s.nom_ets', 'LIKE', '%' . $request->nom_ets . '%');
    if ($request->adresse)
      $query->where('s.adresse', 'LIKE', '%' . $request->adresse . '%');
    if ($request->annee)
      $query->whereYear('datepaie', '=', $request->annee);
    if ($request->date1 && $request->date2)
      $query->whereBetween('datepaie', [$request->date1, $request->date2]);
    else
      $query->whereNotNull('datepaie');

    return  $query->offset(0)->limit(50)->distinct()->get();
  }
}
