<?php

namespace App\Http\Controllers\rendezvous;

use App\Models\historique;
use Carbon\Carbon;
use App\Models\User;
use App\Models\journal;
use App\Models\param_glob;
use App\Models\rendezvous;
use App\Models\admin\grille;
use Illuminate\Http\Request;
use Barryvdh\DomPDF\Facade\Pdf;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use App\Models\admin\arrondissement;
use Illuminate\Support\Facades\Auth;
use App\Models\identification\societe;
use App\Models\identification\categorie;

/**
 * Summary of RdvController
 */
class RdvController extends Controller
{
  /**
   * Display a listing of the resource.
   *
   *   
   */
  public function index()
  {
    $arr = arrondissement::all();
    $categorie = grille::all();
    $parametreMotif = param_glob::where('code_type_param', 'RDMTF')->get();
    $paramType = param_glob::where('code_type_param', 'TYPRD')->get();
    $value = societe::where('fl_sup', 'N')->orderBy('nom_ets')->offset(0)->take(20)->get();
    return view('pages.rendezvous.rendezvous', compact('value', 'arr', 'categorie', 'parametreMotif', 'paramType'));
  }


  /**
   * Show the form for creating a new resource.
   *
   * 
   */
  public function create(Request $request, $id)
  {

  }

  /**
   * Store a newly created resource in storage.
   *
   * @param  \Illuminate\Http\Request  $request
   * 
   */
  public function store(Request $request)
  {
    if (!empty(request('validerR'))) {
      //  dd(request());
      $request->validate([
        // 'idets' => ['required'],
        'daterdv' => ['required'],
        'description' => ['required'],
        'type' => ['required'],
        'motif' => ['required']
      ]);
      $rendezvous = new rendezvous;
      $societe = societe::find(request('idets'));
      // $statut = param_glob::find('11');
      $motif = param_glob::find(request('motif'));
      $type = param_glob::find(request('type'));
      // $rendezvous->pa_statut_rdv_id = $statut->id;
      $rendezvous->pa_motf_rdv_id = $motif->id;
      $rendezvous->pa_type_rdv_id = $type->id;
      $rendezvous->description = request('description');
      $rendezvous->societe_id = $societe->id;
      $rendezvous->daterdv = request('daterdv');

      $rendezvous->date_create_rdv = now();
      $rendezvous->user_id = Auth::user()->id;
      $rendezvous->save();

      return redirect()->route('rdv.showDetails', $societe->id)->with('message', 'Création du rendezvous effectué avec succès');

    } elseif (!empty(request('ModifierR'))) {
      //dd(request());
      $request->
        validate([
          'idr' => ['required'],
          'daterdv' => ['required'],
          'motifRepla' => ['required'],
          'type' => ['required']
        ]);
      // les données de l'ancien rendez vous
      $rdv = rendezvous::find(request('idr'));
      $statut = param_glob::find('3');
      $rdv->pa_motf_repl_rdv_id = request('motifRepla');
      $rdv->pa_statut_rdv_id = $statut->id;
      $rdv->user_fai_rdv_id = Auth::user()->id;
      $rdv->datefais = Carbon::now();
      $rdv->save();


      $rendezvous = new rendezvous;
      $societe = societe::find(request('idets'));
      $motif = param_glob::find(request('motif'));
      $type = param_glob::find(request('type'));
      $rendezvous->pa_motf_rdv_id = $motif->id;
      $rendezvous->pa_type_rdv_id = $type->id;
      $rendezvous->description = request('description');
      $rendezvous->societe_id = $societe->id;
      $rendezvous->daterdv = request('daterdv');
      $rendezvous->date_create_rdv = now();
      $rendezvous->user_id = Auth::user()->id;
      $rendezvous->save();

      //journalisation de l'operation
      $journal = new journal();
      $journal->type = 3;
      $journal->user_id = \Auth::user()->id;
      $journal->contenu = 'Replanification du rendezvous de la societe' . $rdv->societe->nom_ets . '';
      $journal->datej = now();
      $journal->save();

      return redirect()->route('rdvListe.index')->with('message', 'Modification effectuée avec succès');


    }
    // elseif (!empty(request('valideR'))) {
    //   dd(request());
    //   $request->validate([
    //     'idr' => ['required']
    //   ]);

    //   $rendezvous = rendezvous::find(request('idr'));
    //   $statut = param_glob::find('2');
    //   $rendezvous->datefais = now();
    //   $rendezvous->pa_statut_rdv_id = $statut->id;
    //   $rendezvous->user_fai_rdv_id = Auth::user()->id;
    //   $rendezvous->save();

    //   return redirect()->route('rdvListe.index')->with('message', 'Validation effectuée avec succès');


    // }
    elseif (!empty(request('liste'))) {
      return view('pages/listeRendezVous');
    } elseif (!empty(request('deleteRdv'))) {
      // dd(request());
      $request->validate([
        'idr' => ['required'],
      ]);

      $rendezvous = rendezvous::find(request('idr'));
      $statut = param_glob::find('1');
      $rendezvous->pa_statut_rdv_id = $statut->id;
      // $rendezvous->datefais = now();
      $rendezvous->user_fai_rdv_id = Auth::user()->id;
      $rendezvous->save();

      return redirect()->route('rdvListe.index')->with('message', 'Suppression effectuée avec succès');

    } elseif (!empty(request('geolocaliser'))) {
      $request->validate([
        'idets' => ['required'],
        'geoloc' => ['required'],
      ]);
      $societe = societe::find(request('idets'));
      $societe->geoloc = request('geoloc');
      $societe->save();
      \Session::flash('message', 'Geolocalisation effectuée avec succès');
      return redirect()->back();
    } elseif (!empty(request('ModifierPros'))) {
    } elseif (!empty(request('callAppointement'))) {
      //  dd(request());
      $request->validate([
        // 'idets' => ['required'],
        'daterdv' => ['required'],
        'description' => ['required'],
        'motif' => ['required']
      ]);
      $rendezvous = new rendezvous;
      $societe = societe::select(['id'])->find(request('idets'));
      // $statut = param_glob::find('11');
      $motif = param_glob::select(['id'])->find(request('motif'));
      $statut = param_glob::select(['id'])->find(2);
      $type = param_glob::select(['id'])->find(21);
      // $rendezvous->pa_statut_rdv_id = $statut->id;
      $rendezvous->pa_motf_rdv_id = $motif->id;
      $rendezvous->pa_type_rdv_id = $type->id;
      $rendezvous->description = request('description');
      $rendezvous->societe_id = $societe->id;
      $rendezvous->daterdv = request('daterdv');
      $rendezvous->pa_statut_rdv_id = $statut->id;
      $rendezvous->date_create_rdv = Carbon::now();
      $rendezvous->datefais = Carbon::now();
      $rendezvous->user_id = Auth::user()->id;
      if ($request->Decroche) {
        $rendezvous->fl_decroche = 'O';
      }
      $rendezvous->save();

      return redirect()->route('rdvListe.index')->with('message', 'Création du rendezvous effectué avec succès');

    }


  }
  public function delete($id)
  {
    // dd('je rentre');
    $rendezvous = rendezvous::find($id);
    $statut = param_glob::find('1');
    $rendezvous->pa_statut_rdv_id = $statut->id;
    $rendezvous->datefais = Carbon::now();
    $rendezvous->user_fai_rdv_id = Auth::user()->id;
    $rendezvous->save();

    return redirect()->route('rdvListe.index')->with('message', 'Suppression effectuée avec succès');

  }
  /**
   * Display the specified resource.
   *
   * @param  \App\Models\rendezvous  $rendezvous
   * 
   */

  public function listeRendezvousIndex(Request $request)
  {

    $user = user::select(['name', 'id'])->orderBy('name')->get();
    $arr = arrondissement::select(['id', 'libellea'])->get();
    $unique = param_glob::select(['id', 'libelle_param'])->where('code_type_param', 'RDSTU')->get();
    $parametreRepl = param_glob::select(['id', 'libelle_param'])->where('code_type_param', 'RDRPL')->get();
    $parametreMotif = param_glob::select(['id', 'libelle_param'])->where('code_type_param', 'RDMTF')->get();
    $paramType = param_glob::select(['id', 'libelle_param'])->where('code_type_param', 'TYPRD')->get();
    $socNat = param_glob::select(['id', 'libelle_param'])->where('code_type_param', 'NOTSO')->get();
    $auth = Auth::user();
    $userRoles = ['isFichier', 'isAdmin', 'isAdminTechnique', 'isChefEquipe'];
    if ($auth->canAny($userRoles)) {

      $sql = DB::table('rendezvous as rdv')
        ->select(
          'rdv.societe_id',
          'grille.code',
          'rdv.id_rdv',
          'soc.tel',
          'soc.adresse',
          'soc.nom_ets',
          'soc.tel',
          DB::raw('count(rdv.societe_id) as nombre'),
        )
        ->Join('societe as soc', 'rdv.societe_id', '=', 'soc.id')
        ->Join('grille as grille', 'grille.id', '=', 'soc.grille_id')
      ;

      // if ($auth->can('isFichier')) {
      //   $list->join(DB::raw('(SELECT id FROM societe WHERE user_affecte_id = ' . $auth->id . ') as societe'), function ($join) {
      //     $join->on('rendezvous.societe_id', '=', 'societe.id');
      //   });
      // }

      $list = $sql->orderBy('daterdv')
        ->whereYear('daterdv', Carbon::now()->year)
        ->groupBy('rdv.societe_id')
        ->limit(20)
        ->get()
      ;

      $isFiltered = false;
      session()->put('previous', $list);
      $previousLink = true;
      return view(
        'pages.rendezvous.listeRendezvous',
        compact(
          'list',
          'user',
          'unique',
          'parametreRepl',
          'paramType',
          'parametreMotif',
          'arr',
          'isFiltered',
          'socNat',
          'previousLink'
        )
      );

    }
  }


  public function vision($idSoc)
  {
    $value = societe::find($idSoc);
    $paramResult = param_glob::where('code_type_param', 'RDRSLT')->get();
    $parametreRepl = param_glob::where('code_type_param', 'RDRPL')->get();
    $parametreMotif = param_glob::where('code_type_param', 'RDMTF')->get();
    $paramType = param_glob::where('code_type_param', 'TYPRD')->get();
    return view('pages.rendezvous.createRdv', compact('value', 'paramType', 'parametreMotif'));
  }

  public function createCallAppointement($id)
  {
    $value = societe::find($id);
    $paramResult = param_glob::where('code_type_param', 'RDRSLT')->get();
    $parametreRepl = param_glob::where('code_type_param', 'RDRPL')->get();
    $parametreMotif = param_glob::where('code_type_param', 'RDMTF')->get();
    $paramType = param_glob::where('code_type_param', 'TYPRD')->get();
    return view('pages.rendezvous.phoneAppointement', compact('value', 'parametreMotif'));
  }
}