<?php

namespace App\Http\Controllers\rendezvous\parametre;

use App\Http\Controllers\Controller;
use App\Models\param_glob;
use Carbon\Carbon;
use Illuminate\Http\Request;

class rdvParametrageController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * 
     */
    public function index()
    {
        $statut = param_glob::orderBy("code_type_param")->where("fl_sup", "N")
            ->limit(15)->get();
        return view('pages.rendezvous.rendezvousParametrage', compact('statut'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * 
     */
    public function create()
    {
        return view('pages.rendezvous.parametrage.CreateAndEditRdvParam');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     */
    public function store(Request $request)
    {
        $searchTerm = $request->searchTerm;
        $filterType = $request->filterType;
        $query = param_glob::query();
        if ($searchTerm) {
            $query->where('libelle_param', 'like', '%' . $searchTerm . '%')
                ->orWhere('code_param', 'like', '%' . $searchTerm . '%')
                ->orWhere('code_type_param', 'like', '%' . $searchTerm . '%');
        }

        if ($filterType) {
            $query->where('code_type_param', $filterType);
        }

        $statut = $query->orderBy("code_type_param")->where("fl_sup", "N")->get();
        return view('pages.rendezvous.rendezvousParametrage', compact('statut'));
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * 
     */
    public function edit($id)
    {

        $param = param_glob::findOrFail($id);
        return view('pages.rendezvous.parametrage.paramEdit', compact('param'));
    }


    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * 
     */
    public function update(Request $request, $id)
    {
        // Validation des données
        $request->validate([
            'libelle' => ['required']
        ]);

        // Récupération de l'objet à mettre à jour
        $updateStatut = param_glob::find($id);

        // Vérification si l'objet existe
        if ($updateStatut) {
            // Mise à jour des données
            $updateStatut->libelle_param = $request->input('libelle');
            $updateStatut->code_type_param = request('typeParam');
            $updateStatut->save();

            // Redirection avec un message de succès
            return redirect()->route('rdvParam')->with('message', 'Modification du statut du rendez-vous effectuée avec succès');
        } else {
            // Gestion de l'erreur si l'objet n'existe pas
            return redirect()->route('rdvParam')->with('error', 'Le statut du rendez-vous n\'a pas été trouvé.');
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * 
     */
    public function destroy($id)
    {
        $deleteParam = param_glob::find($id);
        if ($deleteParam) {
            $deleteParam->fl_sup = "O";
            $deleteParam->save();
            return redirect()->route('rdvParam')->with('message', 'Suppression effectuée avec succès');
        } else {
            return redirect()->route('rdvParam')->with('error', 'Le paramètre n\'a pas été trouvé');
        }


    }

    public function createStatut(Request $request)
    {
        // dd(request());
        $request->validate([
            'typeParam' => ['required'],
            'libelle' => ['required']
        ]);

        $codeTypeParam = request('typeParam');

        $lastStatut = param_glob::where('code_type_param', $codeTypeParam)
            ->orderBy('code_param', 'desc')
            ->first();

        if ($lastStatut) {
            $lastCode = $lastStatut->code_param;
        } else {
            // Si aucun enregistrement n'est trouvé
            $lastCode = $codeTypeParam . '00';
        }

        // Extraction de la partie numérique
        $prefix = substr($lastCode, 0, 5); // RDSTU
        $number = substr($lastCode, 5); // 00

        $newNumber = str_pad((int) $number + 1, 2, '0', STR_PAD_LEFT);


        $newCode = $prefix . $newNumber;

        $newStatut = new param_glob();
        $newStatut->code_type_param = $codeTypeParam;
        $newStatut->code_param = $newCode;
        $newStatut->libelle_param = request('libelle');
        // $newStatut-> updated_at = Carbon::now();
        // $newStatut->created_at = Carbon::now();

        $newStatut->save();
        return redirect()->route('rdvParam')->with('message', 'Création du statut du rendezvous effectué avec succès');
    }
}
