<?php

namespace App\Http\Controllers\rendezvous\rdv;

use App\Models\admin\arrondissement;
use Carbon\Carbon;
use App\Models\User;
use App\Models\param_glob;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\DB;

/**
 * Summary of rendezVousRechercheControl
 */
class deepResearchOnRdvController extends Controller
{
    public function index()
    {


        $user = user::select(['id', 'name'])->orderBy('name')->get();
        $unique = param_glob::select(['id', 'libelle_param'])->where('code_type_param', 'RDSTU')->get();
        $paramType = param_glob::select(['id', 'libelle_param'])->where('code_type_param', 'TYPRD')->get();
        $socNat = param_glob::select(['id', 'libelle_param'])->where('code_type_param', 'NOTSO')->get();
        $arr = arrondissement::select(['id', 'libellea'])->get();

        $sql = DB::table('rendezvous as rdv')
            ->select(
                'soc.id',
                'rdv.id_rdv',
                'soc.nom_ets',
                'soc.tel',
                'ard.libellea',
                DB::raw('count(rdv.id_rdv) as nombre'),
                DB::raw('count(CASE WHEN daterdv < now() AND pa_statut_rdv_id NOT IN (1, 2, 3) THEN 1 END) as rdv_passe'),
                DB::raw('count(CASE WHEN daterdv > now() AND pa_statut_rdv_id NOT IN (1, 2, 3) THEN 1 END) as rdv_next'),
                DB::raw('count(CASE WHEN pa_statut_rdv_id = 2 THEN 1 END) as rdv_validé'),
                DB::raw('count(CASE WHEN pa_statut_rdv_id = 1 THEN 1 END) as rdv_supprimé'),
                DB::raw('count(CASE WHEN pa_statut_rdv_id = 3 THEN 1 END) as rdv_modifié')
            )
            ->rightJoin('societe as soc', 'rdv.societe_id', '=', 'soc.id')
            ->rightJoin('arrondissement as ard', 'soc.arrondissement_id', '=', 'ard.id')
            ->groupBy('rdv.societe_id')
            ->orderBy('daterdv');
        $result = $sql->limit(25)->get();
        session()->put('previousDeep', $result);
        $previousLink = false;
        return view('pages.rendezvous.deepResearchOnRdvView', compact('result', 'user', 'unique', 'paramType', 'socNat', 'arr', 'previousLink'));
    }

    public function getDeepResearchForSocietyAndAppointement(Request $request)
    {
        // dd($request->filtrageType);
        //Declaration des variables contenant les request
        $datedeb = $request->date_de_deb;
        $datefin = $request->date_de_fin;
        $debut = $request->date_deb;
        $fin = $request->date_fin;
        $StartDate = $request->datefais_deb;
        $EndDate = $request->datefais_fin;
        $action = $request->action;
        $agent = $request->agent;
        $nb = $request->nombre;
        $statut = $request->statut;
        $nature = $request->natureProsp;
        $contact = $request->contact;
        $nom = $request->nom_ets;
        $periode = $request->filtrageType;
        $arrondissement = $request->arrondissement_id;
        $region = $request->region_id;
        $ville = $request->id_ville;
        $province = $request->id_province;
        $origine = $request->origine_id;
//dd($request);
        $specificInputFields = $request->only([
            'date_de_deb',
            'date_de_fin',
            'date_deb',
            'date_fin',
            'action',
            'agent',
            'nombre',
            'statut',
            'natureProsp',
            'contact',
            'nom_ets',
            'filtrageType',
            'arrondissement_id',
            'region_id',
            'datefais_deb',
            'datefais_fin',
            'region_id',
            'id_ville',
            'id_province',
            'origine_id'
        ]);
        $filteredInput = array_filter($specificInputFields);


        $user = user::select(['id', 'name'])->orderBy('name')->get();
        $unique = param_glob::select(['id', 'libelle_param'])->where('code_type_param', 'RDSTU')->get();
        $paramType = param_glob::select(['id', 'libelle_param'])->where('code_type_param', 'TYPRD')->get();
        $socNat = param_glob::select(['id', 'libelle_param'])->where('code_type_param', 'NOTSO')->get();
        $arr = arrondissement::select(['id', 'libellea'])->get();

        // $select = ';
        $sql = DB::table('rendezvous as rdv')
            ->select(
                'soc.id',
                'rdv.id_rdv',
                'soc.nom_ets',
                'soc.tel',
                'ard.libellea',
                DB::raw('count(rdv.id_rdv) as nombre'),
                DB::raw('count(CASE WHEN daterdv < now() AND (pa_statut_rdv_id NOT IN (1, 2, 3) or pa_statut_rdv_id is null) THEN 1 END) as rdv_passe'),
                DB::raw('count(CASE WHEN daterdv > now() AND (pa_statut_rdv_id NOT IN (1, 2, 3) or pa_statut_rdv_id is null) THEN 1 END) as rdv_next'),
                DB::raw('count(CASE WHEN pa_statut_rdv_id = 2 THEN 1 END) as rdv_validé'),
                DB::raw('count(CASE WHEN pa_statut_rdv_id = 1 THEN 1 END) as rdv_supprimé'),
                DB::raw('count(CASE WHEN pa_statut_rdv_id = 3 THEN 1 END) as rdv_modifié')
            )
            ->rightJoin('societe as soc', 'rdv.societe_id', '=', 'soc.id')
            ->rightJoin('arrondissement as ard', 'soc.arrondissement_id', '=', 'ard.id');
        if (!empty($filteredInput)) {

            // condition par agent
            if ($agent) {
                $sql->where(function ($query) use ($request) {
                    if (!empty($request->statut)) {
                        $query->Where('user_fai_rdv_id', $request->agent);
                    } elseif (empty($request->statut)) {
                        $query->where('user_id', $request->agent);
                    }
                });
            } elseif (!empty($nom)) {
                $sql
                    ->where('nom_ets', 'LIKE', '%' . $nom . '%');
            }
            // condition pour la durée de contact du prospect

            if ($StartDate) {
                $sql->havingRaw('Max(datefais) >= ?', [$StartDate]);
            }
            if ($EndDate) {
                $sql->havingRaw('Max(datefais) <= ?', [$EndDate]);
            }

            // condition poar date de rendezvous
            if ($datedeb && $datefin) {
                $sql->whereBetween('daterdv', [$datedeb, $EndDate]);
            } elseif ($datedeb) {
                $sql->whereDate('daterdv', '>=', $datedeb);
            } elseif ($datefin) {
                $sql->whereDate('daterdv', '<=', $datefin);
            }
            if ($debut && $fin) {
                $sql->whereBetween('date_create_rdv', [$debut, $fin]);
            } elseif ($debut) {
                $sql->whereDate('date_create_rdv', '>=', $debut);
            } elseif ($fin) {
                $sql->whereDate('date_create_rdv', '<=', $fin);
            }

            // condition pour les statut
            if (!empty($statut)) {
                $late = param_glob::where("libelle_param","En retard")->get();
                $sql->where(function ($query) use ($statut) {
                    if ($statut == param_glob::where("libelle_param","En retard")->first()) {
                        $query->whereDate('daterdv', '<', Carbon::now())
                            ->where(function ($subQuery) {
                                $subQuery->whereNotIn('pa_statut_rdv_id', [1, 2, 3])
                                    ->orWhereNull('pa_statut_rdv_id');
                            });
                    } elseif ($statut == 11) {
                        $query->whereDate('daterdv', '>', Carbon::now())
                            ->where(function ($subQuery) {
                                $subQuery->whereNotIn('pa_statut_rdv_id', [1, 2, 3])
                                    ->orWhereNull('pa_statut_rdv_id');
                            });
                    } else {
                        $query->where('pa_statut_rdv_id', $statut)
                            ->orWhereNull('pa_statut_rdv_id');
                    }
                });
            } elseif (!empty($action)) {
                $sql->where('pa_type_rdv_id', $action);
            }


            // condition pour le nombre de rdv
            switch ($nb) {
                case '1':
                    $sql->havingRaw('COUNT(*) BETWEEN 0 AND 3');
                    break;
                case '2':
                    $sql->havingRaw('COUNT(*) BETWEEN 4 AND 8');
                    break;
                case '3':
                    $sql->havingRaw('COUNT(*) > 8');
                    break;
            }

            //condition pour le temps de realisation des rdv
            if ($contact) {
                $sql->leftjoin(DB::raw('(SELECT societe_id, MAX(COALESCE(datefais, date_create_rdv)) as date_max_rdv FROM rendezvous GROUP BY societe_id) as maxRdv'), function ($join) {
                    $join->on('rdv.societe_id', '=', 'maxRdv.societe_id');
                });
                switch ($contact) {
                    case 'yesterday':
                        $sql->whereRaw('DATE(maxRdv.date_max_rdv) = ?', [Carbon::now()->yesterday()->format('Y-m-d')]);
                        break;
                    case 'today':
                        $sql->whereRaw('day(maxRdv.date_max_rdv) = ?', [Carbon::now()->format('d')]);
                        break;
                    case '3DaysAgo':
                        $sql->whereRaw('day(maxRdv.date_max_rdv) = ?', [Carbon::now()->subDays(3)->format('d')]);
                        break;
                    case '5DaysAgo':
                        $sql->whereRaw('day(maxRdv.date_max_rdv) = ?', [Carbon::now()->subDays(5)->format('d')]);
                        break;
                    case 'last_week':
                        $sql->whereRaw('maxRdv.date_max_rdv BETWEEN ? AND ?', [Carbon::now()->subWeek(), Carbon::now()]);
                        break;
                    case 'last_month':
                        $sql->whereRaw('month(maxRdv.date_max_rdv) = ? AND year(maxRdv.date_max_rdv) = ?', [Carbon::now()->subMonth()->format('m'), Carbon::now()->year]);
                        break;
                    case 'firstQuarter':
                        $sql->whereRaw('month(maxRdv.date_max_rdv) BETWEEN ? AND ? AND year(maxRdv.date_max_rdv) = ?', [1, 3, Carbon::now()->year]);
                        break;
                    case 'secondQuarter':
                        $sql->whereRaw('month(maxRdv.date_max_rdv) BETWEEN ? AND ? AND year(maxRdv.date_max_rdv) = ?', [4, 6, Carbon::now()->year]);
                        break;
                    case 'thirdQuarter':
                        $sql->whereRaw('month(maxRdv.date_max_rdv) BETWEEN ? AND ? AND year(maxRdv.date_max_rdv) = ?', [7, 9, Carbon::now()->year]);
                        break;
                    case 'fourthQuarter':
                        $sql->whereRaw('month(maxRdv.date_max_rdv) BETWEEN ? AND ? AND year(maxRdv.date_max_rdv) = ?', [10, 12, Carbon::now()->year]);
                        break;
                    case 'firstSemester':
                        $sql->whereRaw('month(maxRdv.date_max_rdv) BETWEEN ? AND ? AND year(maxRdv.date_max_rdv) = ?', [1, 6, Carbon::now()->year]);
                        break;
                    case 'secondSemester':
                        $sql->whereRaw('month(maxRdv.date_max_rdv) BETWEEN ? AND ? AND year(maxRdv.date_max_rdv) = ?', [7, 12, Carbon::now()->year]);
                        break;
                    case 'last_year':
                        $sql->whereRaw('year(maxRdv.date_max_rdv) = ?', [Carbon::now()->subYear()->format('Y')]);
                        break;
                    case 'never':
                        $sql->whereNull('daterdv');
                        break;
                }
            }
            // Add conditions for periode
            if ($periode) {
                $day = null;
                $week = null;
                $month = null;
                $year = null;
                switch ($periode) {
                    case 'today':
                        $day = Carbon::now();
                        break;

                    case 'tomorrow':
                        $day = Carbon::tomorrow();
                        break;

                    case 'Yesterday':
                        $day = Carbon::yesterday();
                        break;

                    case 'this_week':
                        $week = [Carbon::now()->startOfWeek(), Carbon::now()->endOfWeek()];
                        break;

                    case 'next_week':
                        $week = [Carbon::now()->startOfWeek()->addWeek(), Carbon::now()->endOfWeek()->addWeek()];
                        break;

                    case 'last_week':
                        $week = [Carbon::now()->subWeek(), Carbon::now()];
                        break;

                    case 'this_month':
                        $month = Carbon::now()->month;
                        break;

                    case 'next_month':
                        $month = Carbon::now()->addMonth();
                        break;

                    case 'last_month':
                        $month = Carbon::now()->subMonth();
                        break;

                    case 'this_year':
                        $year = Carbon::now()->year;
                        break;

                    case 'last_year':
                        $year = Carbon::now()->subYear();
                        break;
                }

                $sql->where(function ($query) use ($day, $week, $month, $year) {
                    if ($day) {
                        $query->whereDate('daterdv', $day)
                            ->whereNull('datefais');
                    }if ($week) {
                        $query->whereBetween('daterdv', $week)
                            ->whereNull('datefais');
                    }if ($month) {
                        $query->whereYear('daterdv', Carbon::now()->year)
                            ->whereMonth('daterdv', $month)
                            ->whereNull('datefais');
                    }if ($year) {
                        $query->whereYear('daterdv', $year);
                    }
                });
            }
            
           
            //arrondissement et nature condition
            if (!empty($arrondissement)) {
                $sql
                    ->where('soc.arrondissement_id', $arrondissement);
            } elseif (!empty($nature)) {
                $sql
                    ->where('pa_nature_soc_id', $nature);
            }
            
            if (!empty($region)) {
                $sql
                    ->where('soc.id_pa_region', $region);
            }
            if (!empty($province)) {
                $sql
                    ->where('soc.id_pa_province', $province);
            }
            if (!empty($ville)) {
                $sql
                    ->where('soc.id_pa_commune', $ville);
            }
            if (!empty($origine)) {
                $sql
                    ->where('soc.id_pa_origin', $origine);
            }

            $result = $sql
                ->where('soc.fl_sup', 'N')
                ->where('pa_statut_soc_id','<>',16)
                ->groupBy('rdv.societe_id')
                ->groupBy('soc.id')
                ->get();
        } else {
            $result = $sql
                ->where('soc.fl_sup', 'N')
                ->groupBy('rdv.societe_id')
                ->limit(25)->get();
        }
        session()->put('previousDeep', $result);
        $previousLink = false;
        return view('pages.rendezvous.deepResearchOnRdvView', compact('result', 'user', 'unique', 'paramType', 'socNat', 'arr'));
    }
}