<?php

namespace App\Http\Controllers\rendezvous\rdv;

use App\Models\admin\arrondissement;
use App\Models\identification\societe;
use App\Models\User;
use Carbon\Carbon;
use App\Models\historique;
use App\Models\param_glob;
use App\Models\rendezvous;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;


class rdvShowDetailsController extends Controller
{


  public function showRdv(Request $request,$id)
  {
    $previousLink= false;
    $statement = 'id_rdv,rendezvous.societe_id,daterdv,pa_statut_rdv_id,
      pa_motf_rdv_id,description,rendezvous.user_id,user_fai_rdv_id,datefais,pa_type_rdv_id';

    $now = Carbon::now();
    $historyDate = Rendezvous::where('rendezvous.societe_id', '=', $id)
      ->whereIn('pa_statut_rdv_id', [1, 2, 3])
      ->orderBy('datefais', 'desc')
      ->get();
    $rendezvous = rendezvous::where('rendezvous.societe_id', '=', $id)
      ->where(function ($query) use ($now) {
        $query->whereDay('daterdv', '<=', $now)
          ->WhereDay('daterdv', '>=', $now)
          ->orwhereNotIn('pa_statut_rdv_id', [1, 2, 3])
          ->orwhereNull('pa_statut_rdv_id');
      })
      ->orderBy('daterdv', 'asc')
      ->get();
    $det = societe::find($id);

    $parametreRepl = param_glob::where('code_type_param', 'RDRPL')->get();
    $parametreMotif = param_glob::where('code_type_param', 'RDMTF')->get();
    $paramResult = param_glob::where('code_type_param', 'RDRSLT')->get();
    $paramType = param_glob::where('code_type_param', 'TYPRD')->get();
    $socNat = param_glob::where('code_type_param', 'NOTSO')->get();
    $socType = param_glob::where('code_type_param', 'TYPSO')->get();
    $socStat = param_glob::where('code_type_param', 'STCSO')->get();
    if($request->action == 'deepSearch'){
       $previousLink= false;
    }elseif($request->action == 'listeSearch'){
      $previousLink= true;
    }
    // $late = param_glob::find( 29);
    return view(
      "pages.rendezvous.rendezVousDetail",
      compact(
        'rendezvous',
        'parametreRepl',
        'paramType',
        'parametreMotif',
        'paramResult',
        'det',
        'now',
        'socNat',
        'socType',
        'socStat',
        'historyDate',
        'previousLink'
      )
    );
  }

  public function searchAndShowRdv(Request $request,$id)
  {
    $previousLink="";
    $statement = 'id_rdv,rendezvous.societe_id,daterdv,pa_statut_rdv_id,
    fact.montant_negoc as montantNegocier, paie.montant as montantPayer,
    pa_motf_rdv_id,description,rendezvous.user_id,user_fai_rdv_id,datefais,pa_type_rdv_id';

    $paramResult = param_glob::where('code_type_param', 'RDRSLT')->get();
    $parametreRepl = param_glob::where('code_type_param', 'RDRPL')->get();
    $parametreMotif = param_glob::where('code_type_param', 'RDMTF')->get();
    $paramType = param_glob::where('code_type_param', 'TYPRD')->get();
    $socNat = param_glob::where('code_type_param', 'NOTSO')->get();
    $socType = param_glob::where('code_type_param', 'TYPSO')->get();
    $socStat = param_glob::where('code_type_param', 'STCSO')->get();
    $now = Carbon::now();
    // $late = param_glob::where('id', 12)->get();
    $getData = session()->get('key');
    $result = collect($getData);
    $rendezvous = $result
      ->filter(function ($item) use ($now, $id) {
        // Filtrer par societe_id
        if ($item['societe_id'] != $id) {
          return false;
        }
        // Filtrer par date
        if (!($item['daterdv'] <= $now || $item['daterdv'] >= $now)) {
          return false;
        }
        // Filtrer par statut de rendez-vous
        if (in_array($item['pa_statut_rdv_id'], [1, 2, 3]) && !is_null($item['pa_statut_rdv_id'])) {
          return false;
        }
        return true;
      })
      ->sortByDesc('daterdv');
    //  dump($rendezvous);

    // $historyDate = collect($test)->sortBy('daterdv')
    //   ->whereIn('pa_statut_rdv_id', [2, 3])
    //   ->where('societe_id', $id);

    $historyDate = Rendezvous::where('rendezvous.societe_id', '=', $id)
      ->whereIn('pa_statut_rdv_id', [1, 2, 3])
      ->orderBy('datefais', 'desc')
      ->get();

    // dd($historyDate);
    $det = societe::find($id);
    if($request->action == 'deepSearch'){
      $previousLink= false;
   }elseif($request->action == 'listeSearch'){
     $previousLink= true;
   }

    return view(
      "pages.rendezvous.rendezVousDetail",
      compact(
        'rendezvous',
        'parametreRepl',
        'paramType',
        'parametreMotif',
        'paramResult',
        'det',
        'socNat',
        'socType',
        'socStat',
        'historyDate',
        'previousLink'
      )
    );

  }

  public function showAppointementResult(Request $request, $id)
  {

    $valider = $request->action;
    $upd = $request->modifier;
    $appointements = rendezvous::find($id);
    $societe = societe::find($appointements->societe_id);
    $paramResult = param_glob::select(['id', 'libelle_param'])->where('code_type_param', 'RDRSLT')->get();
    $parametreRepl = param_glob::select(['id', 'libelle_param'])->where('code_type_param', 'RDRPL')->get();
    $parametreMotif = param_glob::select(['id', 'libelle_param'])->where('code_type_param', 'RDMTF')->get();
    $paramType = param_glob::select(['id', 'libelle_param'])->where('code_type_param', 'TYPRD')->get();
    $socNat = param_glob::select(['id', 'libelle_param'])->where('code_type_param', 'NOTSO')->get();
    $socType = param_glob::select(['id', 'libelle_param'])->where('code_type_param', 'TYPSO')->get();
    $socStat = param_glob::select(['id', 'libelle_param'])->where('code_type_param', 'STCSO')->get();

    return view(
      'modals.rendezvous.rendezvousCreateValiderAnnuler',
      compact(
        'appointements',
        'parametreRepl',
        'societe',
        'paramType',
        'parametreMotif',
        'paramResult',
        'socNat',
        'socType',
        'socStat',
      )
    );

  }

  public function InsertProspectNoteAndAppointementResult(Request $request, $id)
  {
    // dd($request);
    $appointements = rendezvous::find($id);
    $appointements->observation = $request->observation;
    $appointements->pa_statut_rdv_id = 2;
    $appointements->user_fai_rdv_id = Auth::user()->id;
    $appointements->datefais = Carbon::now();
    if ($request->Decroche) {
      $appointements->fl_decroche = 'O';
    }
    $appointements->save();

    $society = societe::find($appointements->societe_id);
    $society->pa_statut_soc_id = $request->statut;
    $society->pa_type_soc_id = $request->type;
    $society->pa_nature_soc_id = $request->nature;
    $society->description = $request->description;
    $society->save();

    return redirect()->route('rdv.showDetails', $society->id)->with('message', 'Operation réusi');
  }

  public function showAppointementBack()
  {
    $user = User::select(['name', 'id'])->orderBy('name')->orderBy('name')->get();
    $unique = param_glob::select(['id', 'libelle_param'])->where('code_type_param', 'RDSTU')->get();
    $paramType = param_glob::select(['id', 'libelle_param'])->where('code_type_param', 'TYPRD')->get();
    $socNat = param_glob::select(['id', 'libelle_param'])->where('code_type_param', 'NOTSO')->get();
    $arr = arrondissement::select(['id', 'libellea'])->get();
    $result = collect(session()->get('previousDeep'));
    return view('pages.rendezvous.deepResearchOnRdvView', compact('result', 'user', 'unique', 'paramType', 'socNat', 'arr'));
  }
  public function showAppointementBackList(Request $request)
  {
    $isFiltered = false;
    $user = User::select(['name', 'id'])->orderBy('name')->orderBy('name')->get();
    $unique = param_glob::select(['id', 'libelle_param'])->where('code_type_param', 'RDSTU')->get();
    $paramType = param_glob::select(['id', 'libelle_param'])->where('code_type_param', 'TYPRD')->get();
    $socNat = param_glob::select(['id', 'libelle_param'])->where('code_type_param', 'NOTSO')->get();
    $arr = arrondissement::select(['id', 'libellea'])->get();
    $list = collect(session()->get('previous'));
    if($request->isfiltered ==true and $request->action='listeSearch'){
      $isFiltered = true;
    }
    
    return view('pages.rendezvous.listeRendezvous', compact('list', 'user', 'unique', 'arr', 'isFiltered', 'paramType', 'socNat'));

  }
}