<?php

namespace App\Http\Controllers\rendezvous\rdv;

use Carbon\Carbon;
use App\Models\rendezvous;
use Illuminate\Http\Request;
use Barryvdh\DomPDF\Facade\Pdf;
use App\Http\Controllers\Controller;

/**
 * Summary of RdvController
 */
class rendezVousImpressionController extends Controller
{

  //imprime tous les elements de la recherche
  public function getAllitemsAfterSearch()
  {
    
    $rd = session()->get('key');
    $rdvs = collect($rd);
    $rdv = $rdvs->sortBy('daterdv')->all();
    $now = Carbon::now();
    $pdf = PDF::loadView('pages.rendezvous.impressionRDV', compact('rdv', 'now'));
    dd($now);
    return $pdf->stream();
  }
  /*imprime tous les rendezvous present dans la table rendezvous 
   *quand la recherche n'es pas faite
   */
  public function getAllBeforeSearch()
  {
    $rdv = rendezvous::with('societe')->orderBy('daterdv')->get();
    $now = Carbon::now();
    //dd($rdv);
    $pdf = PDF::loadView('pages.rendezvous.impressionRDV', compact('rdv', 'now'));
    return $pdf->stream();
  }

  //imprimer les rendezvous par societe
  public function getPrintForSociety($id)
  {
    $rdv = rendezvous::where('societe_id', $id)->orderBy('daterdv')->get();
    $now = Carbon::now();
    $pdf = PDF::loadView('pages.rendezvous.impressionRDV', compact('rdv', 'now'));
    return $pdf->stream();
  }
  //imprimer les rendezvous par societe apres la recherche effectuée
  public function getPrintForSocietyAfterSearch($id)
  {

    $rdv = collect(session()->get('key'))
      ->where('societe_id', '=', $id)->sortBy('daterdv')->all();
    $now = Carbon::now();
    $pdf = PDF::loadView('pages.rendezvous.impressionRDV', compact('rdv', 'now'));
    return $pdf->stream();
  }

}