<?php

namespace App\Http\Controllers\rendezvous\rdv;

use App\Models\admin\arrondissement;
use Carbon\Carbon;
use App\Models\User;
use App\Models\param_glob;
use App\Models\rendezvous;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\DB;
use Barryvdh\DomPDF\Facade\Pdf;
/**
 * Summary of rendezVousRechercheControl
 */
class rendezVousRechercheController extends Controller
{


 public function getDateFiltererd(Request $request)
  {
// dd($request);
    //Declaration des variables contenant les request
    $datedeb = $request->date_de_deb;
    $datefin = $request->date_de_fin;
    $debut = $request->date_deb;
    $fin = $request->date_fin;
    $agent = $request->agent;
    $nb = $request->nombre;
    $statut = $request->statut;
    $motif = $request->motif;
    $nom = $request->nom_ets;
    $periode = $request->filtrageType;
    $arrondissement = $request->arrondissement_id;
    $region = $request->region_id;
    $province = $request->province_id;
    $commune = $request->commune_id;

    // Declaration des variables alimentant les combobox au niveau de la vue(Blade)
    $user = user::select(['name', 'id'])->orderBy('name')->orderBy('name')->get();
    $unique = param_glob::select(['id', 'libelle_param'])->where('code_type_param', 'RDSTU')->get();
    $paramType = param_glob::select(['id', 'libelle_param'])->where('code_type_param', 'TYPRD')->get();
    $socNat = param_glob::select(['id', 'libelle_param'])->where('code_type_param', 'NOTSO')->get();
    $arr = arrondissement::select(['id', 'libellea'])->get();
    
    $liste = rendezvous::query();

    $list = DB::table('rendezvous as rdv')
      ->select(
        'societe_id',
        'grille.code',
        'rdv.id_rdv',
        'soc.tel',
        'soc.adresse',
        'soc.nom_ets',
        'soc.tel',
        DB::raw('count(rdv.societe_id) as nombre'),
      )
      ->Join('societe as soc', 'rdv.societe_id', '=', 'soc.id')
      ->Join('grille as grille', 'grille.id', '=', 'soc.grille_id')
    ;
   
    //Conditions des filtres
    if ($request->agent) {
      $list->where(function ($query) use ($request) {
        if (!empty($request->statut)) {
          $query->Where('user_fai_rdv_id', $request->agent);
        } elseif (empty($request->statut)) {
          $query->where('user_id', $request->agent);
        }
      });

      $liste->where(function ($query) use ($request) {
        if (!empty($request->statut)) {
          $query->Where('user_fai_rdv_id', $request->agent);
        } elseif (empty($request->statut)) {
          $query->where('user_id', $request->agent);
        }
      });
    }

    if ($request->statut) {
      //dd(request());
      $list->where(function ($query) use ($statut) {
        
        $query->whereYear('daterdv', Carbon::now()->year);
        if ($statut == 29) {
          $query->whereDate('daterdv', '<', Carbon::now())
            ->where(function ($subQuery) {
              $subQuery->whereNotIn('pa_statut_rdv_id', [1, 2, 3])
                ->orWhereNull('pa_statut_rdv_id');
            });
        } elseif ($statut == 11) {
          $query->whereDate('daterdv', '>', Carbon::now())
            ->where(function ($subQuery) {
              $subQuery->whereNotIn('pa_statut_rdv_id', [1, 2, 3])
                ->orWhereNull('pa_statut_rdv_id');
            });
        } else {
          $query->where('pa_statut_rdv_id', $statut)
            ->orWhereNull('pa_statut_rdv_id');
        }
      });


      $liste->where(function ($query) use ($statut) {
        
        $query->whereYear('daterdv', Carbon::now()->year);
        if ($statut == 29) {
          $query->whereDate('daterdv', '<', Carbon::now())
            ->where(function ($subQuery) {
              $subQuery->whereNotIn('pa_statut_rdv_id', [1, 2, 3])
                ->orWhereNull('pa_statut_rdv_id');
            });
        } elseif ($statut == 11) {
          $query->whereDate('daterdv', '>', Carbon::now())
            ->where(function ($subQuery) {
              $subQuery->whereNotIn('pa_statut_rdv_id', [1, 2, 3])
                ->orWhereNull('pa_statut_rdv_id');
            });
        } else {
          $query->where('pa_statut_rdv_id', $statut)
            ->orWhereNull('pa_statut_rdv_id');
        }
      });

    }

    if ($motif) {
      $list->where('pa_motf_rdv_id', $motif);
      $liste->where('pa_motf_rdv_id', $motif);
    }

    if ($datedeb) {
      $list->whereDate('daterdv', '>=', $datedeb);
      $liste->whereDate('daterdv', '>=', $datedeb);
    } elseif ($datefin) {
      $list->whereDate('daterdv', '<=', $datefin);
      $liste->whereDate('daterdv', '<=', $datefin);
    }

    if ($debut) {
      //dd(request());
      $list->whereDate('date_create_rdv', '>=', $debut);
      $liste->whereDate('date_create_rdv', '>=', $debut);
    } elseif ($fin) {
      $list->whereDate('date_create_rdv', '<=', $fin);
      $liste->whereDate('date_create_rdv', '<=', $fin);
    }

    if ($nom) {
      $list->where('soc.nom_ets', 'LIKE', '%' . $nom . '%');

      $liste->join('societe as soc', 'soc.id', '=', 'rendezvous.societe_id')
        ->where('nom_ets', 'LIKE', '%' . $nom . '%');
    }

    switch ($nb) {
      case '1':
        $list->havingRaw('COUNT(*) BETWEEN 0 AND 3');
        break;
      case '2':
        $list->havingRaw('COUNT(*) BETWEEN 4 AND 8');
        break;
      case '3':
        $list->havingRaw('COUNT(*) > 8');
        break;
    }

    if ($periode) {
      $day = null;
      $week = null;
      $month = null;
      $year = null;
      switch ($request->filtrageType) {
        case 'today':
          $day = Carbon::now();
          $liste->whereDate('daterdv', Carbon::now());
          break;

        case 'tomorrow':
          $day = Carbon::tomorrow();
          $liste->whereDate('daterdv', Carbon::tomorrow());
          break;

        case 'Yesterday':
          $day = Carbon::yesterday();
          $liste->whereDate('daterdv', Carbon::yesterday());
          break;

        case 'this_week':
          $week = [Carbon::now()->startOfWeek(), Carbon::now()->endOfWeek()];
          $liste->whereBetween('daterdv', [Carbon::now()->startOfWeek(), Carbon::now()->endOfWeek()]);
          break;

        case 'next_week':
          $week = [Carbon::now()->startOfWeek()->addWeek(), Carbon::now()->endOfWeek()->addWeek()];
          $liste->whereBetween('daterdv', [Carbon::now()->startOfWeek()->addWeek(), Carbon::now()->endOfWeek()->addWeek()]);
          break;

        case 'lask_week':
          $week = [Carbon::now()->subWeek(), Carbon::now()];
          $liste->whereBetween('daterdv', [Carbon::now()->subWeek(), Carbon::now()]);
          break;

        case 'this_month':
          $month = Carbon::now()->month;

          $liste->whereMonth('daterdv', Carbon::now()->month)
            ->whereYear('daterdv', Carbon::now()->year);
          break;

        case 'next_month':
          $month = Carbon::now()->addMonth();

          $liste->whereMonth('daterdv', Carbon::now()->addMonth())
            ->whereYear('daterdv', Carbon::now()->year);
          break;

        case 'last_month':
          $month = Carbon::now()->subMonth();

          $liste->whereMonth('daterdv', Carbon::now()->subMonth())
            ->whereYear('daterdv', Carbon::now()->year);
          break;

        case 'this_year':
          $year = Carbon::now()->year;
          $liste->whereYear('daterdv', Carbon::now()->year);

          break;

        case 'last-year':
          $year = Carbon::now()->subYear();

          $liste->selectRaw('*,count(*) as nombre')->groupBy('societe_id')->whereYear('daterdv', Carbon::now()->subYear());
          break;
      }

      $list->where(function ($query) use ($day, $week, $month, $year) {
        if ($day) {
          $query->whereDate('daterdv', $day)
            ->whereNull('datefais');
        }if ($week) {
          $query->whereBetween('daterdv', $week)
            ->whereNull('datefais');
        }if ($month) {
          $query->whereYear('daterdv', Carbon::now()->year)
            ->whereMonth('daterdv', $month)
            ->whereNull('datefais');
        }if ($year) {
          $query->whereYear('daterdv', $year);
        }
      });


    }

    if ($arrondissement) {
      $list
        ->where('arrondissement_id', $arrondissement);

      $liste->join('societe', 'id', '=', 'rendezvous.societe_id')
        ->where('arrondissement_id', $arrondissement);
    }

    if ($region) {
      $list
        ->where(' id_pa_region', $region);

      $liste->join('societe', 'id', '=', 'rendezvous.societe_id')
      ->where('id_pa_region', $region);
    }
    if ($province) {
      $list
        ->where('id_pa_province', $province);

      $liste->join('societe', 'id', '=', 'rendezvous.societe_id')
      ->where('id_pa_province', $province);
    }
    if ($commune) {
      $list
        ->where('id_pa_commune', $commune);

      $liste->join('societe', 'id', '=', 'rendezvous.societe_id')
      ->where('id_pa_commune', $commune);
    }
    $list = $list->orderBy('daterdv')
      ->groupBy('rdv.societe_id')
      ->get();
    $requestData = $request->all();

    if($request->action){
      $list = collect(session()->get('previous'));
      return view('pages.rendezvous.listeRendezvous', compact('list', 'user', 'unique', 'arr', 'isFiltered', 'paramType', 'socNat'));

    }

    session()->put('previous',$list);
    $lis = $liste->get();

    $back = url()->full();
    session()->put('previousUrl', $back);

    //enregistement des données dans la session
    session()->put('key', $lis);
    $isFiltered = true;
    $previousLink= true;
    return view('pages.rendezvous.listeRendezvous', compact('list', 'user', 'unique', 'arr', 'isFiltered', 'paramType', 'socNat'));

  }

  public function SearchAndPrint(Request $request)
  {
    $rdv = self::getDataForPrint($request);
    $now = Carbon::now();
    //dd($rdv);
    $pdf = PDF::loadView('pages.rendezvous.impressionRDV', compact('rdv', 'now'));
    return $pdf->stream();
  }

  public function getDataForPrint(Request $request)
  {

    //Declaration des variables contenant les request
    $datedeb = $request->date_de_deb;
    $datefin = $request->date_de_fin;
    $debut = $request->date_deb;
    $fin = $request->date_fin;
    $agent = $request->agent;
    $nb = $request->nombre;
    $statut = $request->statut;
    $motif = $request->motif;
    $nom = $request->nom_ets;
    $periode = $request->filtrageType;
    $arrondissement = $request->arrondissement_id;

    // Declaration des variables alimentant les combobox au niveau de la vue(Blade)
    $user = user::select(['name', 'id'])->orderBy('name')->orderBy('name')->get();
    $unique = param_glob::select(['id', 'libelle_param'])->where('code_type_param', 'RDSTU')->get();
    $paramType = param_glob::select(['id', 'libelle_param'])->where('code_type_param', 'TYPRD')->get();
    $socNat = param_glob::select(['id', 'libelle_param'])->where('code_type_param', 'NOTSO')->get();
    $arr = arrondissement::select(['id', 'libellea'])->get();
    $liste = rendezvous::query();

    $sql = rendezvous::query();

    //Conditions des filtres
    if ($request->agent) {
      $sql->where(function ($query) use ($request) {
        if (!empty($request->statut)) {
          $query->Where('user_fai_rdv_id', $request->agent);
        } elseif (empty($request->statut)) {
          $query->where('user_id', $request->agent);
        }
      });
    }

    if ($request->statut) {
      //dd(request());
      $sql->where(function ($query) use ($request) {
        if ($request->statut == 29) {
          $query->whereDate('daterdv', '<', Carbon::now())
          ;
        } elseif ($request->statut == 11) {
          $query->whereDate('daterdv', '>', Carbon::now())
            ->WhereNull('pa_statut_rdv_id');
        } elseif (!empty($request->statut)) {
          $query->where('pa_statut_rdv_id', $request->statut)
            ->WhereNull('pa_statut_rdv_id');
        }
      });
    }




    if ($motif) {
      $sql->where('pa_motf_rdv_id', $motif);
    }
    if ($datedeb && $datefin) {
      $sql->whereDate('daterdv', '>=', $datedeb)->whereDate('daterdv', '<=', $datefin);
    } elseif ($datedeb) {
      $sql->whereDate('daterdv', '>=', $datedeb);
    } elseif ($datefin) {
      $sql->whereDate('daterdv', '<=', $datefin);
    }
    if ($debut && $fin) {
      $sql->whereDate('date_create_rdv', '>=', $debut)->whereDate('date_create_rdv', '<=', $fin);
    } elseif ($debut) {
      //dd(request());
      $sql->whereDate('date_create_rdv', '>=', $debut);
    } elseif ($fin) {
      $sql->whereDate('date_create_rdv', '<=', $fin);
    }
    if ($nom) {
      $sql->whereHas('societe', function ($query) use ($nom) {
        $query->where('nom_ets', 'LIKE', '%' . $nom . '%');
      });
    }
    switch ($nb) {
      case '1':
        $sql->havingRaw('COUNT(*) BETWEEN 0 AND 3');
        break;
      case '2':
        $sql->havingRaw('COUNT(*) BETWEEN 4 AND 8');
        break;
      case '3':
        $sql->havingRaw('COUNT(*) > 8');
        break;
    }

    if ($periode) {
      $day = null;
      $week = null;
      $month = null;
      $year = null;
      switch ($request->filtrageType) {
        case 'today':
          $day = Carbon::now();
          break;

        case 'tomorrow':
          $day = Carbon::tomorrow();
          break;

        case 'Yesterday':
          $day = Carbon::yesterday();
          break;

        case 'this_week':
          $week = [Carbon::now()->startOfWeek(), Carbon::now()->endOfWeek()];
          break;

        case 'next_week':
          $week = [Carbon::now()->startOfWeek()->addWeek(), Carbon::now()->endOfWeek()->addWeek()];
          break;

        case 'lask_week':
          $week = [Carbon::now()->subWeek(), Carbon::now()];
          break;

        case 'this_month':
          $month = Carbon::now()->month;
          break;

        case 'next_month':
          $month = Carbon::now()->addMonth();
          break;

        case 'last_month':
          $month = Carbon::now()->subMonth();
          break;

        case 'this_year':
          $year = Carbon::now()->year;
          break;

        case 'last-year':
          $year = Carbon::now()->subYear();
          break;
      }

      $sql->where(function ($query) use ($day, $week, $month, $year) {
        if ($day) {
          $query->whereDate('daterdv', $day);
        }if ($week) {
          $query->whereBetween('daterdv', $week);
        }if ($month) {
          $query->whereYear('daterdv', Carbon::now()->year)
            ->whereMonth('daterdv', $month);
        }if ($year) {
          $query->whereYear('daterdv', $year);
        }
      });

    }
    //select pour impression
    $selectForPrint =
      'id_rdv,
    societe_id,
    user_id,
    pa_motf_rdv_id,
    daterdv,
    pa_statut_rdv_id,
    description,
    user_fai_rdv_id,
    pa_type_rdv_id';

    if ($arrondissement) {
      $sql
        ->where('soc.arrondissement_id', $arrondissement);
    }
    $lis = $sql->selectRaw($selectForPrint)->get();

    $list = $sql->orderBy('daterdv')
      ->get();
    return $lis;

  }
}