<?php

namespace App\Http\Controllers\rendezvous\societe;


use App\Models\admin\grille;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\admin\arrondissement;
use Illuminate\Support\Facades\Auth;
use App\Models\identification\societe;
use App\Models\param_glob;

/**
 * Summary of RdvController
 */
class rdvSocieteRechercheController extends Controller
{
  public function searchInSociete(Request $request)
  {
    //utilisateur connecté
    $user = Auth::user();

    //liste des roles d'un utilisateur
    $userRoles = ['isFichier', 'isAdmin', 'isAdminTechnique', 'isSuperviseur', 'isSigne', 'isRecouvreur'];

    if ($user->canAny($userRoles)) {

      $arr = arrondissement::all();
      $categorie = grille::all();
      $value = societe::query();

      $parametreMotif = param_glob::where('code_type_param', 'RDMTF')->get();
      $paramType = param_glob::where('code_type_param', 'TYPRD')->get();
      //requete du select 
      // $select = 'id,nom_ets,adresse,tel,grille_id';

      //search by name
      if ($request->nom_ets) {
        $value->where('nom_ets', 'LIKE', '%' . request('nom_ets') . '%');
      }

      //search by period(year,month,week,day)
      if ($request->adresse) {
        $value->where('adresse', 'LIKE', '%' . request('adresse') . '%');
      }

      //search by Arrondissement
      if ($request->arrondissement) {
        $value->where('arrondissement_id', $request->arrondissement)->offset(0)->take(100);
      }

      //search by categorie
      if ($request->categorie) {
        $value->where('categorie_id', $request->categorie)->offset(0)->take(100);
      }

      $value = $value->where('fl_sup', 'N')->get();
      // dd($value);
      return view('pages.rendezvous.rendezvous', compact('value', 'arr', 'categorie', 'paramType', 'parametreMotif'));
    } else {
      return redirect()->route('home');
    }

  }

}