<?php

namespace App\Http\Controllers\Users;

use Session;
use App\Models\taxe;
use App\Models\User;
use App\Models\facture;
use App\Models\admin\grille;
use Illuminate\Http\Request;
use Illuminate\Auth\AuthManager;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use App\model\identification\gerant ;
use App\model\identification\location;
use App\model\identification\societe ;
use App\model\identification\voiture ;
use Illuminate\Support\Facades\Validator;
use App\Models\identification\etablissement;
use App\Models\Attestation as ModelsAttestation;

class Agent extends Controller
{
  public function __construct()
    {
       // $this->middleware('admin');
      
    }
  public function index()
  {
    $agent=User::all();
    return view('pages.users.agent', compact('agent'));
  }
protected function validator(array $data)
{
  return Validator::make($data, [
        'name' => ['required', 'string', 'max:255'],
        'email' => ['required', 'string', 'email', 'max:255', 'unique:users'],
        'password' => ['required', 'string', 'min:8', 'confirmed'],
    ]);
}
  public function create(Request $request)
    {

    }
    public function store(Request $request)
     {
      // dd($request);
    if(!empty(request('valider'))){
         $request->validate([
        'name' => ['required', 'string', 'max:255'],
        'email' => ['required', 'string', 'max:255', 'unique:users'],
        'password' => ['required', 'string', 'min:8', 'confirmed'],
         ]);

            User::create([
                'name' => $request['name'],
                'email' => $request['email'],
                'type' => $request['type'],
                'password' => Hash::make($request['password']),
            ]);
            \Session::flash('message', 'Création Réussie');
              
            return redirect()->back();
     }
    if (!empty(request('modifierc'))) {
     
      $categorie = grille::find(request('id'));
      return view('pages/categorie', compact('categorie'));
    
     
    }
    if (!empty(request('supprimer'))) {

      $user = User::find(request('idets'));
      //$user->delete();
      \Session::flash('message', 'Supprission  Réussie');
      return redirect()->back();
    }
    if (!empty(request('Modifier'))) {

      $user = User::find(request('idets'));
      return view('profile',compact('user'));
    }
    if (!empty(request('Modification'))) {
      $request->validate([
        'code' => ['required', 'string', 'max:255'],
        'montant' => ['required'],
        'activite' => ['required', 'string'],
      ]);
      if(!empty(request('categorie_id'))){
       // dd($request);
      $categorie = grille::find(request('categorie_id'));
      $categorie->code=$request['code'];
      $categorie->activite =$request['activite'];
      $categorie->montant=$request['montant'];
      $categorie->save();
      return redirect()->back();
    }
    else{
      grille::create([
                'code' => $request['code'],
                'activite' => $request['activite'],
                'montant' => $request['montant'],
      ]);
        return redirect()->back();
 }
  
}

     if(!empty(request('signer'))){

        $attestations=ModelsAttestation::find(request('id'));
        foreach ($attestations as $key => $value) {
            $value->etat=1;
            $value->idsign=Auth::user()->id;
            $value->save();
        }
        return redirect()->back();
    }

    }

    public function edit($idcat)
      {

      }
      public function show($idcat)
        {


      }
     
  public function destroy($id)
  {
   // dd($request);

    $ets = User::find($id);
    $ets->delete();
    \Session::flash('message', 'Suppression Réussie');
    return redirect()->back();

  }
      public function update(Request $request, $id)
        {
          $request->validate([
           
          
            'password' => ['required', 'string', 'min:6', 'confirmed'],
        ]);
        $user =\App\Models\User::find($id);
        $user->password=Hash::make($request['password']);
        $user->save();
        \Session::flash('message', 'Modification Réussie');
        return redirect()->back();

        }


}
