<?php

namespace App\Http\Controllers;

use App\Models\Voie;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

class voieController extends Controller
{
    
  /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {

            $voies = Voie::orderBy('nom_voie', 'ASC')->get();
            
            return view('voie',compact('voies'));
        
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('create_voie');
    }

    
    public function store(Request $request)
    {
        $request->validate([
            'nom_voie' => 'required',
            'type' => 'required',
            'arrondissement_adr_id' => 'required'
        ]);

        Voie::create($request->all());

        return redirect()->route('voies.index')
            ->with('success', 'Nouvelle voie ajoutée avec succès.');

    }

    
    
    public function show($id)
    {
        //
    }

    

    public function edit(Voie $voie)
    {
        return view('edit_voie', compact('voie'));
    }

    
    
    public function update(Request $request, Voie $voie)
    {
        
        $request->validate([
            'nom_voie' => 'required',
            'type' => 'required',
            'arrondissement_adr_id' => 'required'
        ]);
        $voie->update($request->all());

        return redirect()->route('voies.index')
            ->with('success', 'Voie editée avec succès');

    }

    
    public function destroy(Voie $voie)
    {
        $voie->delete();

        return redirect()->route('voies.index')
            ->with('success', 'Voie supprimée avec succès');    
    }

}
