<?php

namespace App\Http\Livewire;

use App\Models\param_glob;
use Livewire\Component;
use App\Models\ParamGlob;

class ParamSearch extends Component
{
    public $searchTerm;
    public $filterType;

    public function render()
    {
        $query = param_glob::query();

        if ($this->searchTerm) {
            $query->where('libelle_param', 'like', '%' . $this->searchTerm . '%');
        }

        if ($this->filterType) {
            $query->where('code_type_param', $this->filterType);
        }

        $statut = $query->paginate(10);

        return view('livewire.param-search', compact('statut'));
    }
}
