<?php

namespace App\Http\Livewire;

use App\Models\admin\arrondissement;
use App\Models\admin\grille;
use App\Models\identification\societe;
use App\Models\param_glob;
use Illuminate\Support\Facades\Auth;
use Livewire\Component;

class SearchOnSocForRendezvous extends Component
{
    public $searchTerm;
    
    public $arrondissement;
    public $categorie;

    public $arr;
    public $categories;
    public $parametreMotif;
    public $paramType;

    public function mount()
    {
        // Initialisation les données nécessaires
        $this->arr = arrondissement::all();
        $this->categories = grille::all();
        $this->parametreMotif = param_glob::where('code_type_param', 'RDMTF')->get();
        $this->paramType = param_glob::where('code_type_param', 'TYPRD')->get();
    }

    public function render()
    {
        $user = Auth::user();
        $userRoles = ['isFichier', 'isAdmin', 'isAdminTechnique'];

        if ($user->canAny($userRoles)) {
            $query = societe::query();
            $select = 'id,nom_ets,adresse,tel,grille_id';

            if ($this->searchTerm) {
                $query->where('nom_ets', 'LIKE', '%' . $this->searchTerm . '%')
                ->orWhere('adresse', 'LIKE', '%' . $this->searchTerm . '%');
            }

            // if ($this->adresse) {
            //     $query->where('adresse', 'LIKE', '%' . $this->adresse . '%');
            // }

            if ($this->arrondissement) {
                $query->where('arrondissement_id', $this->arrondissement);
            }

            if ($this->categorie) {
                $query->where('grille_id', $this->categorie);
            }
            // if($user->can('isFichier')){
            //     $value->where('user_affecte_id', $user->id);
            // }
            $value = $query->selectRaw($select)->where('fl_sup', 'N')->get();

            return view('livewire.search-on-soc-for-rendezvous', [
                'value' => $value
            ]);
        } else {
            return redirect()->route('home');
        }
    }
}
