<?php

namespace App\Http\Livewire;

use App\Models\admin\arrondissement;
use App\Models\admin\grille;
use App\Models\identification\categorie;
use App\Models\identification\societe;
use App\Models\lettres;
use Illuminate\Support\Facades\Auth;
use Livewire\Component;

class SocieteSearch extends Component
{
    public $search_term;
     public $arrondissement_id;
    public $categorie_id;
    public $grille_id;
    public $selectedIds = [];
    public function mount()
    {
        $this->arrondissements = arrondissement::all();
        $this->grilles = grille::all();
        $this->categories = categorie::all();
        // $this->lettre = new \App\Models\lettres();
    }
    public function render()
    {
        $user = Auth::user();
        $userRoles = ['isFichier', 'isAdmin', 'isAdminTechnique','isChefEquipe'];
        if ($user->canAny($userRoles)) {
            $query = societe::query();

            if ($this->search_term) {
                $query->where('nom_ets', 'LIKE', '%' . $this->search_term . '%')
                    ->orWhere('adresse', 'LIKE', '%' . $this->search_term . '%');
            }

            if ($this->categorie_id) {
                $query->where('categorie_id', $this->categorie_id);
            }

            if ($this->grille_id) {
                $query->where('grille_id', $this->grille_id);
            }

            if ($this->arrondissement_id) {
                $query->where('arrondissement_id', $this->arrondissement_id);
            }
            // if($user->can('isFichier')){
            //     $query->where('user_affecte_id', $user->id);
            // }
            $this->ets = $query->where('fl_sup', 'N')->limit(50)->get();
            return view('livewire.societe-search', [
                'ets' => $this->ets

            ]);
        } else {
            return redirect()->route('home');
        }

    }

}
