<?php

namespace App\Http\Middleware;

use Closure;
use Auth;

class IsRecouvreur
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle($request, Closure $next)
    {
        if (Auth::user()->can('isAdmin') || Auth::user()->can('isAdminTechnique') || Auth::user()->can('isRecouvreur')) {
            return $next($request);
        }

        return redirect('home')->with('error', 'Vous n\'avez pas accès à la Recouvrement');
    }
}
