<?php

namespace App\Http\Middleware;

use Closure;
use Auth;

class IsCompta
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle($request, Closure $next)
    {
        if (Auth::user()->can('isAdmin') || Auth::user()->can('isCompta') || Auth::user()->can('isFacturation') ) {
            return $next($request);
        }

        return redirect('home')->with('error', 'Vous n\'avez pas accès à la Comptabilité');
    }
}
