<?php

namespace App\Jobs;
use Webklex\PDFMerger\Facades\PDFMergerFacade as PDFMerger;
use Barryvdh\DomPDF\Facade\Pdf;
use Illuminate\Bus\Queueable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Support\Facades\Storage;

class GeneratePdfJob implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;


    private $factures;
    private $lettre;

    /**
     * Create a new job instance.
     *
     * @return void
     */
    public function __construct($factures, $lettre)
    {
        $this->factures = $factures;
        $this->lettre = $lettre;
    }

    /**
     * Execute the job.
     *
     * @return void
     */
    public function handle()
    {
        set_time_limit(0);
        $lettre = $this->lettre;
        $oMerger1 = PDFMerger::init();
        
        dd($this->factures);
        $sousTableaux = $this->factures->chunk(500);

        //do {
           
           // $factures[0] = $facture;
           //for ($a=0; $a < 8; $a++) { 
            // $factures->nextCursor();
           
            // $facts=$factures->items();
            foreach ($sousTableaux as $facts) {
              
           

            $pdf= PDF::loadView('print/NotificationModelCorps', compact('facts', 'lettre'));
            Storage::put("processes/box.pdf",$pdf->download()->getOriginalContent());

            // $pdf2= PDF::loadView('print/NotificationModelBas', compact('facts'));
            // Storage::put("processes/bas.pdf",$pdf2->download()->getOriginalContent());
            
            $oMerger1->addPDF(storage_path("app/processes/box.pdf"));     
           // $oMerger2->addPDF(storage_path('app/processes/bas.pdf'));       
        }
    
        
        $oMerger1->merge();
        //

        $oMerger1->save(public_path("ListeNotif.pdf"));
       // $oMerger2->save(public_path("TableauResume.pdf"));

       $oMerger2 = PDFMerger::init();
       
       $sousTableaux = $this->factures->chunk(200);
       foreach ($sousTableaux as $facts) {

        $pdf2= PDF::loadView('print/NotificationModelBas', compact('facts'));
        Storage::put("processes/bas.pdf",$pdf2->download()->getOriginalContent());
        $oMerger2->addPDF(storage_path('app/processes/bas.pdf'));  
       }
       $oMerger2->merge();
       $oMerger2->save(public_path("TableauResume.pdf"));

        unlink(storage_path('app/processes/box.pdf'));
       // unlink(storage_path('app/processes/bas.pdf'));
        
        $response = response()
        ->file(public_path("ListeNotif.pdf"), [
         'Title' => "Notifications"
     ]);
       
    }
}
