<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class equipes extends Model
{
    use HasFactory;

    protected $table = 'equipes';
    public $timestamps = false;
    protected $primaryKey = 'equipe_id';

    protected $fillable = ['nom', 'user_id', 'fl_sup'];

    public function equipe()
    {
        return $this->belongsTo(User::class, 'user_id');
    }

    public function membres()
    {
        return $this->belongsToMany(User::class, 'equipes_users', 'equipe_id', 'user_id')
            ->withPivot('fl_actif', 'date_fin')
            ->withTimestamps();
    }
}
