<?php
namespace App\Models\identification;


use Illuminate\Database\Eloquent\Model;

class etablissement extends Model
{
   protected $table = 'etablissement';
   public $timestamps = true;
   protected $primaryKey = 'idets';
   protected $fillable = ['idets','nom_ets','observations','effectif','adresse','type_voie','idgerant',
    'idzadmin','idgrille','	id','enseigne','nbre_femme','geoloc','idsociete','patente','num_patente','regime','residence'
    ,'etatCot'];
   public function societe()
   {
    return $this->belongsTo('\App\Models\identification\societe','idsociete','idsociete');
   }
   public function user()
   {
    return $this->belongsTo('\App\User','id','id');
   }
   public function gerant()
   {
    return $this->hasOne('\App\Models\identification\gerant','idgerant','idgerant');
   }
   public function categorie()
   {
    return $this->hasOne('\App\Models\identification\categorie','idcat','idcat');
   }
   public function grille()
   {
    return $this->hasOne('\App\Models\admin\grille','idgrille','idgrille');
   }
   public function facture()
   {
    return $this->hasMany('App\Models\facture','numero','idets');
   }
   public function attestation()
   {
    return $this->hasMany('App\Models\Attestation','idets','idets');
   }
   public function zone()
   {
    return $this->belongsTo('\App\Models\admin\zone','idzadmin','idzadmin');
   }
}
