<?php
namespace App\Models\identification;


use Illuminate\Database\Eloquent\Model;

class societe extends Model
{

   protected $table = 'societe';
   public $timestamps = true;
   protected $primaryKey = 'id';
   protected $fillable = [
      'id',
      'nom_ets',
      'sigle',
      'adresse',
      'form_jurid',
      'tel',
      'contact',
      'email',
      'rccm',
      'datercm',
      'ville',
      'grille_id',
      'activite',
      'capital',
      'effectif',
      'nationaux',
      'cadres',
      'employeur',
      'arrondissement_id',
      'datecre',
      'gerant_id',
      'site',
      'femme',
      'categorie_id',
      'activite_id',
      'geoloc',
      'montant_negoc_soc',
      'id_adr_voie',
      'id_rel_rdv',
      'fl_sup',
      'user_create_id',
      'user_update_id',
      'date_sup',
      'src_create',
      'tscreate_idusers',
      'pa_nature_soc_id',
      'pa_statut_soc_id',
      'pa_type_soc_id',
      'description',
      'id_pa_region',
      'id_pa_province',
      'id_pa_commune',
      'id_pa_origin'
   ];

   public function gerant()
   {
      return $this->hasOne('\App\Models\identification\gerant', 'id', 'gerant_id');
   }
   public function section()
   {
      return $this->belongsTo('\App\Models\identification\categorie', 'categorie_id');
   }
   public function categorie()
   {
      return $this->belongsTo('\App\Models\admin\grille', 'grille_id');
   }
   public function arr()
   {
      return $this->belongsTo('\App\Models\admin\arrondissement', 'arrondissement_id', 'id');
   }


   public function factures()
   {
      return $this->hasMany('App\Models\facture', 'societe_id');
   }
   public function attestation()
   {
      return $this->hasMany('App\Models\Attestation', 'id');
   }
   public function compte()
   {
      return $this->hasMany('App\Models\identification\compte', 'societe_id');
   }
   public function paiements()
   {
      return $this->hasMany('App\Models\paiement', 'societe_id');
      //return $this->hasMany('App\Models\paiement', 'id');
   }
   public function voie()
   {
      return $this->belongsTo('\App\Models\Voie', 'id_adr_voie');
   }
   public function rendezvous()
   {
      return $this->hasMany('\App\Models\rendezvous', 'societe_id');
   }
   public function natureSoc()
   {
      return $this->belongsTo('App\Models\param_glob', 'pa_nature_soc_id', 'id');
   }
   public function statutSoc()
   {
      return $this->belongsTo('App\Models\param_glob', 'pa_statut_soc_id', 'id');
   }
   public function typeSoc()
   {
      return $this->belongsTo('App\Models\param_glob', 'pa_type_soc_id', 'id');
   }

   public function region()
   {
      return $this->belongsTo('App\Models\pa_region', 'id_pa_region', 'ID_REG');
   }


   public function province()
   {
      return $this->belongsTo('App\Models\pa_province', 'id_pa_province', 'ID_PROV');
   }


   public function commune()
   {
      return $this->belongsTo('App\Models\pa_commune', 'id_pa_commune', 'ID_COM');
   }

   public function originClient()
   {
      return $this->belongsTo('App\Models\param_glob', 'id_pa_origin', 'id');
   }
   public function delete()
   {
      // delete all related photos 
      $this->factures()->delete();
      $this->attestation()->delete();
      $this->compte()->delete();
      $this->paiements()->delete();
      // as suggested by Dirk in comment,
      // it's an uglier alternative, but faster
      // Photo::where("user_id", $this->id)->delete()

      // delete the user
      return parent::delete();
   }


}
