<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class incidents extends Model
{
    use HasFactory;
    protected $table ='incidents';
    public $timestamps = false;
    protected $primaryKey = 'id_incidents';
    protected $fillable = ['id_incidents', 'user_id', 'description','id_param_statut_client','id_param_type_pb_client',
    'id_param_statut_pb_client','date_probleme','description_resolution','date_resolution'];

    public function parametresStatutClient()
    {
        return $this->belongsTo('App\Models\param_glob', 'id_param_statut_client', 'id');
    }
    public function parametresStatutPb()
    {
        return $this->belongsTo('App\Models\param_glob', 'id', 'id_param_statut_pb_client');
    }
    public function parametresType()
    {
        return $this->belongsTo('App\Models\param_glob', 'id', 'id_param_type_pb_client');
    }
    public function societe()
    {
        return $this->hasOne('App\Models\identification\societe', 'id','id_societe');
    }
}
