<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class rendezvous extends Model
{
    public $timestamps = false;
    protected $table = 'rendezvous';
    protected $primaryKey = 'id_rdv';
    protected $fillable = [
        'id_rdv',
        'user_id',
        'societe_id',
        'daterdv',
        'datefais',
        'type',
        'statut',
        'description',
        'date_create_rdv',
        'user_fai_rdv_id',
        'pa_motf_repl_rdv_id',
        'pa_statut_rdv_id',
        'pa_motf_rdv_id',
        'motif_replanif',
        'tscreate_idusers',
        'pa_type_rdv_id'
    ];
    public function agent()
    {
        return $this->belongsTo('App\Models\User', 'user_id');
    }
    public function societe()
    {
        return $this->belongsTo('App\Models\identification\societe', 'societe_id');
    }
    public function parametresStatut()
    {
        return $this->belongsTo('App\Models\param_glob', 'pa_statut_rdv_id', 'id');
    }
    public function parametresMotif()
    {
        return $this->belongsTo('App\Models\param_glob', 'pa_motf_rdv_id', 'id');
    }
    public function parametresType()
    {
        return $this->belongsTo('App\Models\param_glob', 'pa_type_rdv_id', 'id');
    }

    public function agentModif()
    {
        return $this->belongsTo('App\Models\User', 'user_fai_rdv_id');
    }
    
}