<?php

namespace App\Providers;

use Illuminate\Contracts\Auth\Access\Gate as GateContract;
use Illuminate\Foundation\Support\Providers\AuthServiceProvider as ServiceProvider;

class AuthServiceProvider extends ServiceProvider
{
    /**
     * The policy mappings for the application.
     *
     * @var array
     */
    protected $policies = [
        // 'App\Models\Model' => 'App\Policies\ModelPolicy',
    ];

    /**
     * Register any authentication / authorization services.
     *
     * @return void
     */

    public function boot(GateContract $gate)
    {
        $this->registerPolicies($gate);

        $gate->define('isAdmin', function($user){
            return $user->type == 'admin_fonctionnel';
        });

        $gate->define('isAdminTechnique', function($user){
            return $user->type == 'admin_technique';
        });

        $gate->define('isFacturation', function($user){
            return $user->type == 'facturation';
        });

        $gate->define('isCaisse', function($user){
            return $user->type == 'caisse';
        });
        $gate->define('isCompta', function ($user) {
            return $user->type == 'comptabilite';
        });

        $gate->define('isRecouvreur', function ($user) {
            return $user->type == 'recouvreur';
        });
        
        
        $gate->define('isFichier', function($user){
            return $user->type == 'fichier';
        });
        $gate->define('isSigne', function($user){
            return $user->type == 'sg';
        });
        $gate->define('isSuperviseur', function($user){
            return $user->type == 'superviseur';
        });
        $gate->define('isChefEquipe', function($user){
            return $user->type == 'chefEquipe';
        });
    }
}
