@extends('layouts.app')
@section('contenu')
@include('layouts.alert')

<div class="col-lg-22">
        <div class="box-inner">
            <div class="box-header well" data-original-title="">
                <h2><i class="glyphicon glyphicon-indent-left"></i> Histogramme des recouvrements </h2>
                <div class="box-icon">
            <a href="#" class="btn btn-minimize btn-round btn-default"><i
                    class="glyphicon glyphicon-chevron-up"></i></a>
            <a href="#" class="btn btn-close btn-round btn-default"><i class="glyphicon glyphicon-remove"></i></a>
        </div>
            </div>
           
            <div class="box-content" id="MyChart" style="width:1200px;height: 700px" ></div>
        </div>
</div>

    <br>

<!--
<a class="btn btn-success" href="{{route('stats.store')}}" type="submit"  data-toggle="modal" data-target="#periode">
                                <i class="glyphicon glyphicon-wrench"></i>
                                Filtrer les statisques
                            </a>-->

<div class="form-group text-left">  
    <a href="{{ url()->previous() }}" class="button btn btn-danger"><i class="glyphicon glyphicon-arrow-left"></i> Retour</a>
&nbsp;&nbsp;&nbsp;
    <button type="button" class="btn btn-success" data-toggle="modal" data-target="#myModal">
        <i class="glyphicon glyphicon-wrench"></i>
        <a href="{{route('stats.store')}}"></a>
                    Filtrer les statisques
    </button>

</div>
<!--Daebut modal-->
<div class="modal fade" id="myModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
        <form method="POST" action="{{route('stats.store')}}">
            @csrf
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal">X</button>
                                                <h3>Choisissez une periode</h3>
            </div>
            <div class="modal-body">
                
                <div class="form-group">
                    <label>Filtre Par Date</label>
                    <div class="nk-int-st">
                        <select name="filtrageType" id="" class="form-control">
                            <option  value=""></option>
                            <option  value="today">Aujourd'hui</option>
                            <option  value="Yesterday">Hier</option>
                            <option value="this_week">Cette Semaine</option>
                            <option  value="lask_week">Semaine Dernière</option>
                            <option  value="this_month">Ce Mois</option>
                            <option  value="last_month">Le Mois Passé</option>
                            <option  value="this_year">Cette Année</option>
                            <option  value="last-year">L'année Passée</option>
                        </select>
                    </div>
                </div>
              
                <div class="form-group">
                    
                    <div class="col-lg-4 ">
                    <label>Date Debut</label>   <input type="date" name="date_de_deb" id="" class="form-control" />
                        
                    </div>
                    <div class="col-lg-4">
                    <label>Date Fin</label>  <input type="date" name="date_de_fin" id="" class="form-control" />
                       
                    </div>
                </div>
                                            

            </div>
                       <br>   <br>   <br>                 
            <div class="modal-footer">
                <a href="#" class="btn btn-danger" data-dismiss="modal">Annuler</a>
                <button  name="filtreStats" type="submit" id="filtreStats" value="filtreStats" class="btn btn-success"><a href="{{route('stats.store')}}"></a>Filtrer</button>
            </div>
        </div>
</form>
    </div>
</div>
            
                        
@endsection
<script type="text/javascript" src="https://www.gstatic.com/charts/loader.js"></script>
<script src="https://www.gstatic.com/charts/loader.js"></script>
<script type="text/javascript">

     google.charts.load('current', {'packages':['bar']}); 
     //dessin histogramme pour le nombre de recouvrement par agent
    google.charts.setOnLoadCallback(drawChartNombre);

   
    //appel de fonction pour l'histogramme par nombre
    function drawChartNombre()
    {
        //initialisation des données pour nombre
            var data = google.visualization.arrayToDataTable([
                ['Date','Montant', 'Nombre'],

                //on boucle sur les societes
                @foreach($number as $value)
                //initialisation des données
                ["{{$value->year}}",{{$value->nombre}},{{$value->somme}}],
                @endforeach
            ]);
            function name(params) {
                data.sort({column: 1, desc: true});
            }
            //initialisation des options
            var options = {
                chart: {
                    title: 'Performances Recouvrement',
                    subtitle: 'Date, Nombre de recouvrement,Montant recouvré',
                },
               vAxis:{
                minValue:0,
                maxValue: 100, 
              title: 'Valeur' 
          
               },
                series: {
                        0: { axis: 'Montant' },
                        1: { axis: 'Nombre' } 
                        },
                
                axes: {
            y: {
                Montant: {label: 'Nombre de recouvrement'}, // ordonnée gauche
                nombre: {side: 'right', label: 'Montant Recouvré'} // ordonnée droite.
            }
          }
          
            }
            //dessin du graphique
            var chart = new google.charts.Bar(document.getElementById('MyChart'));
            chart.draw(data, google.charts.Bar.convertOptions(options));
            $(window).resize(function() {
                chart.draw(data, google.charts.Bar.convertOptions(options));
            })
    }

</script>


