@extends('layouts.app')
@section('contenu')
<div class="box col-md-12">
    <div class="box-inner">
        <div class="box-content">
            <h2 class="text-center">{{$client->nom_ets ?? ''}}</h2>
        </div>

        <div>
            <form action="{{ route('PbClient', $client->id) }}" method="post">
                @csrf 
                <div class="container">
                    <h3 class="text-center">Difficultés rencontrées</h3>

                    <!-- Champ pour Type -->
                    <div class="form-group">
                        <label for="type">Type :</label>
                        <select class="form-control" id="type" name="type_pb_client" required>
                            <option value="" disabled selected>Choisissez un type</option>
                            @foreach ($types as $type)
                            <option value="{{ $type->id }}">
                                {{ $type->libelle_param }}
                            </option>
                            @endforeach
                        </select>
                    </div>

                    <!-- Champ pour Statut -->
                    <div class="form-group">
                        <label for="statut">Statut :</label>
                        <select class="form-control" id="statut" name="statut_pb" required>
                            <option value="" disabled selected>Choisissez un statut</option>
                            @foreach ($statuts as $statut)
                            <option value="{{ $statut->id }}">
                                {{ $statut->libelle_param }}
                            </option>
                            @endforeach
                        </select>
                    </div>

                     <!-- Champ des dates de début du problème -->
                     <div class="form-group">
                        <label for="date_deb">Date problème :</label>
                        <input type="date" name="date_prob" id="" class="form-control">
                    </div>

                    <!-- Champ pour Description -->
                    <div class="form-group">
                        <label for="description" >Description :</label>
                        <textarea class="form-control" id="description" name="description" rows="10" required></textarea>
                    </div>

                    <!-- Bouton pour soumettre -->
                    <div class="form-group text-center">
                        <button type="submit" class="btn btn-primary">Enregistrer</button>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection