@extends('layouts.app')
@section('contenu')
<div class="box col-md-12">
    <div class="box-inner">
        <div class="box-content">
            <h2 class="text-center">{{$clients->nom_ets ?? ''}}</h2>
        </div>
        <div>
            <form action="{{route('impression')}}" method="post">
                @csrf
                <div class="container">
                    <h3 class="text-center">Difficultés rencontrées</h3>

                    <!-- Champ pour Type -->
                    <div class="form-group">
                        <label for="type">Type :</label>
                        <select class="form-control" id="type" name="statut">
                            <option value="" disabled selected>Choisissez un statut</option>
                            @foreach ($statuts as $value)
                            <option value="{{ $value->id }}" {{ (old("statut")==$value->id || (isset($clients) &&
                                $clients->id_param_statut_client == $value->id)) ? 'selected' : ''}}>
                                {{ $value->libelle_param }}
                            </option>
                            @endforeach
                        </select>
                    </div>
                    <div class="form-group text-center">
                        <button name="save" class="btn btn-primary">Enregistrer</button>
                    </div>

                    <div class="form-group text-center">
                        <a  type="button" name="proformaBills" class="btn btn-default" data-toggle="modal"
                            data-target="#proforma">proforma</a>

                        <a type="button" name="commande" class="btn btn-default" data-toggle="tooltip"
                            title="bon de commande"> bon commande</a>

                        <a type="button" name="livraison" class="btn btn-default" data-toggle="tooltip"
                            title="bordereau de livraison">bordereau livraison</a>

                        <a type="button" name="contrat" class="btn btn-default" data-toggle="tooltip"
                            title="contrat">contrat</a>

                        <a type="button" name="definitiveBills" class="btn btn-default" data-toggle="tooltip"
                            title="facture definitive">facture définitive</a>

                        <a type="button" name="serviceOrder" class="btn btn-default" data-toggle="tooltip"
                            title="ordre de service"> ordre service</a>

                    </div>

                </div>
                <!--Pour la modification d'un rendezvous-->
                @include('modals.incidents.documentAdministratifModal')
            </form>
        </div>
    </div>
</div>
@endsection