@extends('layouts.app')
@section('contenu')
<div class="box col-md-12">
    <div class="box-inner">
        <div class="box-content">
            <h2 class="text-center">{{$client->societe->nom_ets ?? ''}}</h2>
        </div>

        <div>
            <form action="{{ route('handleEdit', $client->id_incidents) }}" method="post">
                @csrf
                <div class="container">

                    <h3 class="text-center">Difficultés rencontrées</h3>
                    <a href="{{ url()->previous() }}" data-toggle="tooltip" title="Retour">
                        <span class="glyphicon glyphicon-arrow-left btn btn-danger"></span></a>
                    <hr>

                    <!-- Champ pour Type -->
                    <div class="form-group">
                        <label for="type">Type :</label>
                        <select class="form-control" id="type" name="type_pb_client">
                            <option value="" disabled selected>Choisissez un type</option>
                            @foreach ($types as $type)
                                                    <option value="{{ $type->id }}" {{ (old('type_pb_client') == $type->id || (isset($client) &&
                                $client->id_param_type_pb_client == $type->id)) ? 'selected' : '' }}>
                                                        {{ $type->libelle_param }}
                                                    </option>
                            @endforeach
                        </select>

                    </div>

                    <!-- Champ pour Statut -->
                    <div class="form-group">
                        <label for="statut">Statut :</label>
                        <select class="form-control" id="statut" name="statut_pb">
                            <option value="" disabled selected>Choisissez un statut</option>
                            @foreach ($statuts as $statut)
                                                    <option value="{{ $statut->id }}" {{ old('statut_pb', $client->id_param_statut_pb_client) ==
                                $statut->id ? 'selected' : '' }}>
                                                        {{ $statut->libelle_param }}
                                                    </option>
                            @endforeach
                        </select>
                    </div>

                    <!-- Champ des dates de début du problème -->
                    <div class="form-group">
                        <label for="date_prob">Date problème :</label>
                        <input type="date" name="date_prob" id="date_prob" class="form-control"
                            value="{{ isset($client->date_probleme) ? $client->date_probleme : old('date_prob') }}">
                    </div>

                    <!--whamps pour la date de résolution des problèmes-->
                    <div class="form-group">
                        <label for="date_resolution">Date de résolution :</label>
                        <input type="date" name="date_resol" id="date_resol" class="form-control"
                            value="{{ isset($client->date_resolution) ? $client->date_resolution : old("date_resol ") }}">
                    </div>

                    <!-- Champ pour Description -->
                    <div class="form-group">
                        <label for="description">Description du problème :</label>
                        <textarea class="form-control" id="description" name="description"
                            rows="10">{{ isset($client->description) ? $client->description : old('description') }}</textarea>
                    </div>

                    <div class="form-group">
                        <label for="descriptif">Description de la resolution:</label>
                        <textarea name="descriptif" id="descriptif" class="form-control" rows="15"
                            placeholder="Entrez une description" required>{{ isset($client->description_resolution) ? $client->description_resolution :
    old('descriptif') }}</textarea>
                    </div>

                    <!-- Bouton pour soumettre -->
                    <div class="form-group text-center">
                        <button type="submit" class="btn btn-primary">Enregistrer</button>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection