@extends('layouts.app')
@section('contenu')

<div class="row">
    <div class="col-lg-12 margin-tb">
        <div class="pull-right">
            <h2>Ajouter une voie</h2>
        </div>
        <div class="pull-left">
            <a class="btn btn-primary" href="{{ route('voies.index') }}" title="Retour"> <i class="glyphicon glyphicon-chevron-left"></i>Retour </a>
        </div>
    </div>
</div>

@if ($errors->any())
    <div class="alert alert-danger">
        <strong>Whoops!</strong> Il semble avoir une erreur avec des champ.<br><br>
        <ul>
            @foreach ($errors->all() as $error)
                <li>{{ $error }}</li>
            @endforeach
        </ul>
    </div>
@endif
<form action="{{ route('voies.store') }}" method="POST" >
    @csrf

    <div class="row">
        <div class="col-xs-12 col-sm-12 col-md-12">
            <div class="form-group">
                <strong>Nom</strong>
                <input type="text" name="nom_voie" class="form-control">
            </div>
        </div>
        <div class="col-xs-12 col-sm-12 col-md-12">
            <div class="form-group">
                <strong>Type</strong>
                <input type="text" class="form-control" name="type"></input>
            </div>
        </div>
        <div class="col-xs-12 col-sm-12 col-md-12">
            <div class="form-group">
                <strong>Arrondissement</strong>
                <select class="form-control" name="arrondissement_adr_id" >
                           
                    @foreach(  App\Models\admin\arrondissement::orderBy('libellea')->get() as $ard)
                    <option value="{{ $ard->id }}">{{ $ard->libellea }}</option>
                    @endforeach
                
                </select>
            </div>
        </div>
       
        <div class="col-xs-12 col-sm-12 col-md-12 text-center">
            <button type="submit" class="btn btn-primary">Ajouter</button>
        </div>
    </div>

</form>

    @endsection