@extends('layouts.app')
@section('contenu')

<div class="row">
    <div class="col-lg-12 margin-tb">
        <div class="pull-right">
            <h2>Modification de voie</h2>
        </div>
        <div class="pull-left">
            <a class="btn btn-primary" href="{{ route('voies.index') }}" title="Retour"> <i class="glyphicon glyphicon-chevron-left"></i> Retour</a>
        </div>
    </div>
</div>

@if ($errors->any())
    <div class="alert alert-danger">
        <strong>Whoops!</strong> Il semble avoir une erreur avec certains champs.<br><br>
        <ul>
            @foreach ($errors->all() as $error)
                <li>{{ $error }}</li>
            @endforeach
        </ul>
    </div>
@endif

<form action="{{ route('voies.update', $voie->id) }}" method="POST">
    @csrf
    @method('PUT')

    <div class="row">
        <div class="col-xs-12 col-sm-12 col-md-12">
            <div class="form-group">
                <strong>Nom </strong>
                <input type="text" name="nom_voie" value="{{ $voie->nom_voie }}" class="form-control">
            </div>
        </div>
        <div class="col-xs-12 col-sm-12 col-md-12">
            <div class="form-group">
                <strong>Type</strong>
                <input class="form-control"  name="type" value="{{ $voie->type }}"/>
            </div>
        </div>
        <div class="col-xs-12 col-sm-12 col-md-12">
            <div class="form-group">
                <strong>Arrondissement:</strong>

                <select class="form-control" name="arrondissement_adr_id" value="{{ $voie->arrondissement->libellea ?? old('arrondissement_adr_id') }}" @if(!empty($detail )) disabled  @endif>
                           
                    @foreach(  App\Models\admin\arrondissement::orderBy('libellea')->get() as $ard)
                    <option value="{{ $ard->id }}">{{ $ard->libellea }}</option>
                    @endforeach

                </select>
            </div>
        </div>
       
        <div class="col-xs-12 col-sm-12 col-md-12 text-center">
            <button type="submit" class="btn btn-primary">Modifier</button>
        </div>
    </div>

</form>

@endsection